/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.pdf.ContinuousDistribution;

public class Uniform
extends ContinuousDistribution {
    private double lower = -1.7976931348623157E308;
    private double range;
    private double upper = Double.MAX_VALUE;

    public Uniform() {
        this(0.0, 1.0);
    }

    public Uniform(double a, double b) {
        if (!(a <= b)) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.setLower(a);
        this.setUpper(b);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = Double.isNaN(x) ? Double.NaN : (x <= this.lower ? 0.0 : (x >= this.upper ? 1.0 : (x - this.lower) / this.getRange()));
        return ret;
    }

    public double getLower() {
        return this.lower;
    }

    private double getRange() {
        return this.range;
    }

    public double getUpper() {
        return this.upper;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? this.lower : (p == 1.0 ? this.upper : this.lower + p * this.getRange()));
        return ret;
    }

    public void setLower(double low) {
        if (Double.isNaN(low)) {
            throw new IllegalArgumentException("Lower bound must be a number.");
        }
        if (low > this.upper) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.lower = low;
        this.setRange(this.getUpper() - low);
    }

    private void setRange(double value) {
        this.range = value;
    }

    public void setUpper(double up) {
        if (Double.isNaN(up)) {
            throw new IllegalArgumentException("Upper bound must be a number.");
        }
        if (up < this.lower) {
            throw new IllegalArgumentException("Upper bound must be greater than lower bound.");
        }
        this.upper = up;
        this.setRange(up - this.getLower());
    }
}

