/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.num.pdf;

import jhplot.math.num.Constants;
import jhplot.math.num.NumericException;
import jhplot.math.num.pdf.ContinuousDistribution;
import jhplot.math.num.special.Erf;

public class Normal
extends ContinuousDistribution {
    private double mean;
    private double standardDeviation;

    public Normal() {
        this(0.0, 1.0);
    }

    public Normal(double m, double s) {
        this.setMean(m);
        this.setStandardDeviation(s);
    }

    @Override
    public double cumulativeProbability(double x) throws NumericException {
        double ret = Double.isInfinite(x) ? (x < 0.0 ? 0.0 : 1.0) : 0.5 * (1.0 + Erf.erf((x - this.getMean()) / (this.getStandardDeviation() * Constants.SQRT_2)));
        return ret;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    public double inverseCumulativeProbability(double p) throws NumericException {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : Constants.SQRT_2 * this.getStandardDeviation() * Erf.inverseErf(2.0 * p - 1.0) + this.getMean()));
        return ret;
    }

    public void setMean(double m) {
        if (Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be a valid number.");
        }
        this.mean = m;
    }

    public void setStandardDeviation(double std) {
        if (std <= 0.0 || Double.isNaN(std)) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = std;
    }
}

