/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jhplot.math.io.BinaryInputStream;
import jhplot.math.io.BinaryOutputStream;

public class BinaryFile {
    public static String LITTLE_ENDIAN = "LITTLE_ENDIAN";
    public static String BIG_ENDIAN = "BIG_ENDIAN";
    private boolean bigEndian;
    private File file;

    public BinaryFile(File f, String endian) {
        this.file = f;
        this.bigEndian = this.isBigEndian(endian);
    }

    private boolean isBigEndian(String endian) {
        boolean be;
        if (endian.equals(LITTLE_ENDIAN)) {
            be = false;
        } else if (endian.equals(BIG_ENDIAN)) {
            be = true;
        } else {
            throw new IllegalArgumentException("The Endian type : " + endian + "is unknown. You must specify LITTLE_ENDIAN or BIG_ENDIAN.");
        }
        return be;
    }

    public static double[] readDoubleArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readDoubleArray();
    }

    public static float[] readFloatArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readFloatArray();
    }

    public static int[] readIntArray(File f, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        return bf.readIntArray();
    }

    public static void writeDoubleArray(File f, double[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeDoubleArray(array, false);
    }

    public static void appendDoubleArray(File f, double[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeDoubleArray(array, true);
    }

    public static void writeFloatArray(File f, float[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeFloatArray(array, false);
    }

    public static void appendFloatArray(File f, float[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeFloatArray(array, true);
    }

    public static void writeIntArray(File f, int[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeIntArray(array, false);
    }

    public static void appendIntArray(File f, int[] array, String endian) {
        BinaryFile bf = new BinaryFile(f, endian);
        bf.writeIntArray(array, true);
    }

    public int[] readIntArray() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        BinaryInputStream bs = new BinaryInputStream((InputStream)bis, this.bigEndian);
        return bs.readIntArray();
    }

    public float[] readFloatArray() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        BinaryInputStream bs = new BinaryInputStream((InputStream)bis, this.bigEndian);
        return bs.readFloatArray();
    }

    public double[] readDoubleArray() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        BinaryInputStream bs = new BinaryInputStream((InputStream)bis, this.bigEndian);
        return bs.readDoubleArray();
    }

    public byte[] readByteArray() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        BinaryInputStream bs = new BinaryInputStream((InputStream)bis, this.bigEndian);
        return bs.readByteArray();
    }

    public void writeIntArray(int[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file, append);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BinaryOutputStream bs = new BinaryOutputStream((OutputStream)bos, this.bigEndian);
        bs.writeIntArray(array, append);
    }

    public void writeFloatArray(float[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file, append);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BinaryOutputStream bs = new BinaryOutputStream((OutputStream)bos, this.bigEndian);
        bs.writeFloatArray(array, append);
    }

    public void writeDoubleArray(double[] array, boolean append) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file, append);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BinaryOutputStream bs = new BinaryOutputStream((OutputStream)bos, this.bigEndian);
        bs.writeDoubleArray(array, append);
    }

    public void writeByteArray(byte[] bytes, boolean append) {
        if (this.file.exists()) {
            System.out.println("Warning : the file " + this.file.getName() + " already exists !");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file, append);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        BinaryOutputStream bs = new BinaryOutputStream((OutputStream)bos, this.bigEndian);
        bs.writeByteArray(bytes, append);
    }

    public int readInt() {
        return this.readIntArray()[0];
    }

    public float readFloat() {
        return this.readFloatArray()[0];
    }

    public double readDouble() {
        return this.readDoubleArray()[0];
    }

    public byte readByte() {
        return this.readByteArray()[0];
    }

    public void writeInt(int i, boolean append) {
        this.writeIntArray(new int[]{i}, append);
    }

    public void writeFloat(float f, boolean append) {
        this.writeFloatArray(new float[]{f}, append);
    }

    public void writeDouble(double d, boolean append) {
        this.writeDoubleArray(new double[]{d}, append);
    }

    public void writeByte(byte b, boolean append) {
        this.writeByteArray(new byte[]{b}, append);
    }

    public static void main(String[] args) {
        if (args[0].equals("-readarray")) {
            String man = "Usage: BinaryFile -readarray file [option]\n[options] are:\n  -endian <big|little, default = big>\n  -data <double|float|int, default = double>";
            File file = null;
            String data = "double";
            String endian = BIG_ENDIAN;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-endian")) {
                    if (args[i + 1].equals("little")) {
                        endian = LITTLE_ENDIAN;
                    }
                    ++i;
                    continue;
                }
                if (args[i].equals("-data")) {
                    data = args[i + 1];
                    ++i;
                    continue;
                }
                file = new File(args[i]);
                if (!file.exists()) {
                    System.out.println("File " + file + " doesn't exists.\n" + man);
                }
                ++i;
            }
            if (data.equals("double")) {
                double[] d = BinaryFile.readDoubleArray(file, endian);
                for (int j = 0; j < d.length; ++j) {
                    System.out.println(d[j] + "");
                }
            } else if (data.equals("float")) {
                float[] d = BinaryFile.readFloatArray(file, endian);
                for (int j = 0; j < d.length; ++j) {
                    System.out.println(d[j] + "");
                }
            } else if (data.equals("int")) {
                int[] d = BinaryFile.readIntArray(file, endian);
                for (int j = 0; j < d.length; ++j) {
                    System.out.println(d[j] + "");
                }
            } else {
                System.out.println(man);
            }
        } else {
            System.out.println("Option not implemented.");
        }
    }
}

