/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import jasymca.Jasymca;
import jasymca.PlotGraph;
import jasymca.StringFmt;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import jscl.math.Expression;
import jscl.text.ParseException;
import org.matheclipse.core.eval.EvalUtilities;
import org.matheclipse.core.expression.F;

public class Symbolic {
    private EvalUtilities symja = null;
    private Jasymca j = null;
    private String engine = "jasymca";

    public Symbolic(String engine) {
        this.engine = engine;
        if (engine.equalsIgnoreCase("jasymca")) {
            this.j = new Jasymca();
        }
        if (engine.equalsIgnoreCase("symja")) {
            F.initSymbols();
            this.symja = new EvalUtilities();
        }
    }

    public Symbolic() {
        this("jasymca");
    }

    public String getEngineName() {
        return this.engine;
    }

    public Object getEngine() {
        if (this.symja != null) {
            return this.symja;
        }
        if (this.j != null) {
            return this.j;
        }
        return null;
    }

    public String eval(String str) throws Exception {
        if (this.engine.equalsIgnoreCase("jasymca")) {
            int n = str.length() - 1;
            if (n < 0 || "\n".equals(str.substring(n))) {
                this.exec(str);
                return str;
            }
            return this.eval0(str);
        }
        if (this.engine.equalsIgnoreCase("jscl")) {
            return this.simplify(this.expand(str));
        }
        if (this.engine.equalsIgnoreCase("symja")) {
            return this.symja.evaluate(str).toString();
        }
        return "";
    }

    public void exec(String str) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
        try {
            while (((InputStream)is).available() > 0) {
                List code = this.j.pars.compile(is, System.out);
                if (code == null) continue;
                this.j.proc.process_list(code, false);
                this.j.proc.printStack();
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private String eval0(String str) throws Exception {
        if (str.equals("plot")) {
            return this.plot();
        }
        try {
            this.j.proc.process_list(this.j.pars.compile(str), false);
            this.j.proc.printStack();
            return StringFmt.compact(this.j.env.getValue("ans").toString());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String toJava(String s) throws ParseException {
        return Expression.valueOf((String)s).toJava();
    }

    public String toMathML(String s) throws ParseException {
        return Expression.valueOf((String)s).toMathML();
    }

    private String plot() throws Exception {
        PlotGraph g = null;
        Frame[] f = Frame.getFrames();
        for (int i = 0; i < f.length; ++i) {
            if (!(f[i] instanceof PlotGraph)) continue;
            g = (PlotGraph)f[i];
        }
        try {
            return "print";
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public String expand(String s) throws ParseException {
        return Expression.valueOf((String)s).expand().toString();
    }

    public String factorize(String s) throws ParseException {
        return Expression.valueOf((String)s).factorize().toString();
    }

    public String elementary(String s) throws ParseException {
        return Expression.valueOf((String)s).elementary().toString();
    }

    public String simplify(String s) throws ParseException {
        return Expression.valueOf((String)s).simplify().toString();
    }

    public String numeric(String s) throws ParseException {
        return Expression.valueOf((String)s).numeric().toString();
    }

    public static String derivative(String s) throws ParseException {
        return Expression.valueOf((String)s).numeric().toString();
    }
}

