/*
 * Decompiled with CFR 0.152.
 */
package jhplot.math;

import java.io.Serializable;

public class Complex
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;

    public Complex(double u, double v) {
        this.x = u;
        this.y = v;
    }

    public double real() {
        return this.x;
    }

    public double imag() {
        return this.y;
    }

    public double mod() {
        if (this.x != 0.0 || this.y != 0.0) {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
        return 0.0;
    }

    public double arg() {
        return Math.atan2(this.y, this.x);
    }

    public Complex conj() {
        return new Complex(this.x, -this.y);
    }

    public Complex plus(Complex w) {
        return new Complex(this.x + w.real(), this.y + w.imag());
    }

    public Complex minus(Complex w) {
        return new Complex(this.x - w.real(), this.y - w.imag());
    }

    public Complex minusReal(double w) {
        return new Complex(this.x - w, this.y);
    }

    public Complex times(Complex w) {
        return new Complex(this.x * w.real() - this.y * w.imag(), this.x * w.imag() + this.y * w.real());
    }

    public Complex times(double k) {
        this.x *= k;
        this.y *= k;
        return this;
    }

    public Complex divide(double k) {
        this.x /= k;
        this.y /= k;
        return this;
    }

    public Complex div(Complex w) {
        double den = Math.pow(w.mod(), 2.0);
        return new Complex((this.x * w.real() + this.y * w.imag()) / den, (this.y * w.real() - this.x * w.imag()) / den);
    }

    public Complex exp() {
        return new Complex(Math.exp(this.x) * Math.cos(this.y), Math.exp(this.x) * Math.sin(this.y));
    }

    public Complex log() {
        return new Complex(Math.log(this.mod()), this.arg());
    }

    public Complex sqrt() {
        double r = Math.sqrt(this.mod());
        double theta = this.arg() / 2.0;
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    private double cosh(double theta) {
        return (Math.exp(theta) + Math.exp(-theta)) / 2.0;
    }

    private double sinh(double theta) {
        return (Math.exp(theta) - Math.exp(-theta)) / 2.0;
    }

    public Complex sin() {
        return new Complex(this.cosh(this.y) * Math.sin(this.x), this.sinh(this.y) * Math.cos(this.x));
    }

    public Complex cos() {
        return new Complex(this.cosh(this.y) * Math.cos(this.x), -this.sinh(this.y) * Math.sin(this.x));
    }

    public Complex sinh() {
        return new Complex(this.sinh(this.x) * Math.cos(this.y), this.cosh(this.x) * Math.sin(this.y));
    }

    public Complex cosh() {
        return new Complex(this.cosh(this.x) * Math.cos(this.y), this.sinh(this.x) * Math.sin(this.y));
    }

    public Complex tan() {
        return this.sin().div(this.cos());
    }

    public Complex chs() {
        return new Complex(-this.x, -this.y);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        if (this.x != 0.0 && this.y > 0.0) {
            return this.x + " + " + this.y + "i";
        }
        if (this.x != 0.0 && this.y < 0.0) {
            return this.x + " - " + -this.y + "i";
        }
        if (this.y == 0.0) {
            return String.valueOf(this.x);
        }
        if (this.x == 0.0) {
            return this.y + "i";
        }
        return this.x + " + i*" + this.y;
    }
}

