/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jhplot.F1D;
import jhplot.F2D;
import jhplot.FND;
import jhplot.FPR;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.P2D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;
import promc.io.PBufFile;

public class PFile {
    private FileOutputStream oof = null;
    private FileInputStream iif = null;
    private int nev = 0;
    private static final int FILE_VERSION = 1;
    private ZipOutputStream zout;
    static final int BUFFER = 2048;
    private byte[] data;
    private ZipInputStream zin;
    private ZipFile zipFile;
    private Map<String, Integer> map = null;
    private ArrayList<FileEntry> entries = null;

    public PFile(String file, String option, boolean mapNames) {
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.oof = new FileOutputStream(file);
                this.zout = new ZipOutputStream(new BufferedOutputStream(this.oof));
                this.data = new byte[2048];
                this.zipFile = null;
                ZipEntry entry = new ZipEntry("info");
                this.zout.putNextEntry(entry);
                String a = new String(Integer.toString(1));
                byte[] theByteArray = a.getBytes();
                entry.setSize(theByteArray.length);
                this.zout.write(theByteArray);
                this.zout.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (option.equalsIgnoreCase("r")) {
            try {
                this.zipFile = new ZipFile(file);
                this.iif = new FileInputStream(file);
                this.zin = new ZipInputStream(this.iif);
                if (mapNames) {
                    this.mapNames();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.ErrorMessage("Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mapNames() {
        if (this.zin == null || this.zipFile == null) {
            return false;
        }
        if (this.map != null || this.entries != null) {
            return false;
        }
        this.map = new HashMap<String, Integer>();
        this.entries = new ArrayList();
        block5: while (true) {
            try {
                ZipEntry ze;
                while ((ze = this.zin.getNextEntry()) != null) {
                    String a = ze.getName();
                    if (a.equals("info")) continue;
                    PBufFile.Record record = null;
                    try {
                        InputStream zz = this.zipFile.getInputStream(ze);
                        record = PBufFile.Record.parseFrom((InputStream)zz);
                        String title = "";
                        if (record == null) {
                            return false;
                        }
                        title = record.hasName() ? record.getName() : (record.hasF1D() ? record.getF1D().getName() : (record.hasF2D() ? record.getF2D().getName() : (record.hasFND() ? record.getFND().getName() : (record.hasFPR() ? record.getFPR().getName() : (record.hasP0I() ? record.getP0I().getName() : (record.hasP0D() ? record.getP0D().getName() : (record.hasPXY() ? record.getPXY().getName() : (record.hasPXYZ() ? record.getPXYZ().getName() : (record.hasP1D() ? record.getP1D().getName() : (record.hasH1D() ? record.getH1D().getName() : (record.hasPND() ? record.getPND().getName() : (record.hasPNI() ? record.getPNI().getName() : (record.hasH2D() ? record.getH2D().getName() : "")))))))))))));
                        this.map.put(title, new Integer(a.toString()));
                        this.entries.add(new FileEntry(title, new Integer(a.toString()).intValue(), ze.getCompressedSize(), record.getSerializedSize()));
                        this.zin.closeEntry();
                        continue block5;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                        return true;
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public int getVersion() {
        String tmp = "0";
        if (this.zipFile == null) {
            return 0;
        }
        ZipEntry ze = this.zipFile.getEntry("info");
        long size = ze.getSize();
        if (size > 0L) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.zipFile.getInputStream(ze)));
                while ((line = br.readLine()) != null) {
                    tmp = line;
                }
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Integer.parseInt(tmp);
    }

    public PFile(String file) {
        this(file, "r", true);
    }

    public PFile(String file, String option) {
        this(file, option, true);
    }

    public boolean write(Object ob) {
        Serializable pnd;
        boolean success = true;
        PBufFile.Record.Builder record = PBufFile.Record.newBuilder();
        if (ob instanceof String) {
            record.setName((String)ob);
            success = true;
        } else if (ob instanceof F1D) {
            F1D f1d = (F1D)ob;
            PBufFile.Record.F1D.Builder p = PBufFile.Record.F1D.newBuilder().setName(f1d.getTitle());
            p.setDefinition(f1d.getName());
            p.setMax(f1d.getMax());
            p.setMin(f1d.getMin());
            success = true;
        } else if (ob instanceof FND) {
            FND fnd = (FND)ob;
            PBufFile.Record.FND.Builder p = PBufFile.Record.FND.newBuilder().setName(fnd.getTitle());
            p.setDefinition(fnd.getName());
            p.setVars(fnd.getVarString());
            success = true;
        } else if (ob instanceof F2D) {
            F2D f2d = (F2D)ob;
            PBufFile.Record.F2D.Builder p = PBufFile.Record.F2D.newBuilder().setName(f2d.getTitle());
            p.setDefinition(f2d.getName());
            p.setMaxX(f2d.getMaxX());
            p.setMinX(f2d.getMinX());
            p.setMaxY(f2d.getMaxY());
            p.setMinY(f2d.getMinY());
            success = true;
        } else if (ob instanceof FPR) {
            FPR fpr = (FPR)ob;
            PBufFile.Record.FPR.Builder p = PBufFile.Record.FPR.newBuilder().setName(fpr.getTitle());
            p.setDefinition(fpr.getName());
            p.setDivU(fpr.getDivU());
            p.setDivV(fpr.getDivV());
            success = true;
        } else if (ob instanceof P0I) {
            PBufFile.Record.P0I.Builder p0i = PBufFile.Record.P0I.newBuilder().setName(((P0I)ob).getTitle());
            for (int i = 0; i < ((P0I)ob).size(); ++i) {
                p0i.addValue((long)((P0I)ob).get(i));
            }
            record.setP0I(p0i);
            success = true;
        } else if (ob instanceof P0D) {
            PBufFile.Record.P0D.Builder p0d = PBufFile.Record.P0D.newBuilder().setName(((P0D)ob).getTitle());
            for (int i = 0; i < ((P0D)ob).size(); ++i) {
                p0d.addValue(((P0D)ob).get(i));
            }
            record.setP0D(p0d);
            success = true;
        } else if (ob instanceof P2D) {
            P2D p2d = (P2D)ob;
            PBufFile.Record.PXYZ.Builder p = PBufFile.Record.PXYZ.newBuilder().setName(p2d.getTitle());
            for (int i = 0; i < ((P2D)ob).size(); ++i) {
                p.addX(p2d.getX(i));
                p.addY(p2d.getY(i));
                p.addZ(p2d.getZ(i));
            }
            record.setPXYZ(p);
            success = true;
        } else if (ob instanceof PND) {
            pnd = (PND)ob;
            PBufFile.Record.PND.Builder p = PBufFile.Record.PND.newBuilder().setName(((PND)pnd).getTitle());
            int n = ((PND)pnd).getDimension();
            p.setDimension(n);
            for (int i = 0; i < ((PND)pnd).size(); ++i) {
                for (int j = 0; j < n; ++j) {
                    p.addValue(((PND)pnd).get(i, j));
                }
            }
            record.setPND(p);
            success = true;
        } else if (ob instanceof PNI) {
            pnd = (PNI)ob;
            PBufFile.Record.PNI.Builder p = PBufFile.Record.PNI.newBuilder().setName(((PNI)pnd).getTitle());
            int n = ((PNI)pnd).getDimension();
            p.setDimension(n);
            for (int i = 0; i < ((PNI)pnd).size(); ++i) {
                for (int j = 0; j < n; ++j) {
                    p.addValue(((PNI)pnd).get(i, j));
                }
            }
            record.setPNI(p);
            success = true;
        } else if (ob instanceof P1D) {
            PBufFile.Record.PXY.Builder p;
            P1D p1d = (P1D)ob;
            if (p1d.dimension() == 2) {
                p = PBufFile.Record.PXY.newBuilder().setName(p1d.getTitle());
                for (int i = 0; i < ((P1D)ob).size(); ++i) {
                    p.addX(p1d.getX(i));
                    p.addY(p1d.getY(i));
                }
                record.setPXY(p);
                success = true;
            } else {
                p = PBufFile.Record.P1D.newBuilder().setName(p1d.getTitle());
                for (int i = 0; i < ((P1D)ob).size(); ++i) {
                    p.addX(p1d.getX(i));
                    p.addY(p1d.getY(i));
                    p.addXleft(p1d.getXleft(i));
                    p.addXright(p1d.getXright(i));
                    p.addYupper(p1d.getYupper(i));
                    p.addYlower(p1d.getYlower(i));
                    p.addXsysleft(p1d.getXleftSys(i));
                    p.addXsysright(p1d.getXrightSys(i));
                    p.addYsysupper(p1d.getYupperSys(i));
                    p.addYsyslower(p1d.getYlowerSys(i));
                    record.setP1D((PBufFile.Record.P1D.Builder)p);
                }
            }
            success = true;
        } else if (ob instanceof H1D) {
            H1D h = (H1D)ob;
            PBufFile.Record.H1D.Builder p = PBufFile.Record.H1D.newBuilder().setName(h.getTitle());
            p.setIsFixedBins(h.isFixedBinning());
            p.setMean(h.mean());
            p.setRms(h.rms());
            p.setNentries(h.entries());
            p.setMin(h.getMin());
            p.setMax(h.getMax());
            p.setBins(h.getBins());
            p.setOverflow(h.getOverflowlowHeight());
            p.setUnderflow(h.getUnderflowHeight());
            int ibins = h.getBins() + 2;
            for (int i = 0; i < ibins - 1; ++i) {
                p.addHeights(h.binHeight(i));
                p.addErrors(h.binError(i));
                p.addEntries(h.binEntries(i));
                p.addMeans(h.binMean(i));
                p.addRmses(h.binRms(i));
                if (i >= ibins - 2) continue;
                p.addEdges(h.binLowerEdge(i));
            }
            p.addEdges(h.binUpperEdge(h.getBins() - 1));
            record.setH1D(p);
            success = true;
        } else if (ob instanceof H2D) {
            H2D h2 = (H2D)ob;
            PBufFile.Record.H2D.Builder p = PBufFile.Record.H2D.newBuilder().setName(h2.getTitle());
            p.setNentries(h2.entries());
            p.addSummary((double)h2.getBinsX());
            p.addSummary(h2.getMinX());
            p.addSummary(h2.getMaxX());
            p.addSummary((double)h2.getBinsY());
            p.addSummary(h2.getMinY());
            p.addSummary(h2.getMaxY());
            p.addSummary(h2.getMeanX());
            p.addSummary(h2.getRmsX());
            p.addSummary(h2.getMeanY());
            p.addSummary(h2.getRmsY());
            p.addOutofrange(h2.getUnderflowHeightY() + h2.getUnderflowHeightX());
            p.addOutofrange(h2.getUnderflowHeightY());
            p.addOutofrange(h2.getUnderflowHeightY() + h2.getOverflowHeightX());
            p.addOutofrange(h2.getUnderflowHeightX());
            p.addOutofrange(h2.getOverflowHeightX());
            p.addOutofrange(h2.sumAllBinHeights());
            p.addOutofrange(h2.getOverflowHeightY() + h2.getUnderflowHeightX());
            p.addOutofrange(h2.getOverflowHeightY());
            p.addOutofrange(h2.getOverflowHeightY() + h2.getOverflowHeightX());
            int ibinsX = h2.getBinsX() + 2;
            int ibinsY = h2.getBinsY() + 2;
            int kk = 0;
            for (int j1 = 0; j1 < ibinsX - 1; ++j1) {
                for (int j2 = 0; j2 < ibinsY - 1; ++j2) {
                    p.addHeights(h2.get().binHeight(j1, j2));
                    p.addErrors(h2.get().binError(j1, j2));
                    p.addEntries(h2.get().binEntries(j1, j2));
                    p.addMeansX(h2.get().binMeanX(j1, j2));
                    p.addRmsesX(h2.get().binRmsX(j1, j2));
                    p.addMeansY(h2.get().binMeanY(j1, j2));
                    p.addRmsesY(h2.get().binRmsY(j1, j2));
                    ++kk;
                }
            }
            p.setIsFixedBins(true);
            record.setH2D(p);
            success = true;
        } else {
            success = false;
            return success;
        }
        ++this.nev;
        String firec = Integer.toString(this.nev);
        try {
            this.data = record.build().toByteArray();
            ZipEntry entry = new ZipEntry(firec);
            this.zout.putNextEntry(entry);
            entry.setSize(this.data.length);
            this.zout.write(this.data);
            this.zout.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
            success = false;
            return success;
        }
        return success;
    }

    public int size() {
        if (this.zipFile == null) {
            return this.nev;
        }
        return this.zipFile.size() - 1;
    }

    public int getNEntries() {
        return this.size();
    }

    public ArrayList<FileEntry> getEntries() {
        return this.entries;
    }

    public String entriesToString() {
        String tmp = "";
        if (this.iif == null) {
            return tmp;
        }
        try {
            ZipEntry ze;
            while ((ze = this.zin.getNextEntry()) != null) {
                String a = ze.getName();
                if (!a.equals("info")) {
                    tmp = tmp + a + "\n";
                }
                this.zin.closeEntry();
            }
            this.zin.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public Object read(String name) {
        if (this.zipFile == null) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        int index = this.map.get(name);
        return this.read(index);
    }

    public Object read() {
        ++this.nev;
        return this.read(this.nev);
    }

    public String listEntries() {
        if (this.entries == null) {
            this.mapNames();
        }
        Collections.sort(this.entries);
        String tmp = "\nID  |  Title  |   Serialized size (bytes)  |   Compressed size (bytes)\n";
        for (int i = 0; i < this.entries.size(); ++i) {
            FileEntry a = this.entries.get(i);
            String s1 = Long.toString(a.getSerializedSize());
            String s2 = Long.toString(a.getCompressedSize());
            String s3 = Long.toString(a.getID());
            tmp = tmp + s3 + "  ->  " + a.getName() + " -->  " + s1 + " --> " + s2 + "\n";
        }
        return tmp;
    }

    public Object read(int index) {
        Object ob = null;
        if (this.zipFile == null) {
            return ob;
        }
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        if (entry == null) {
            return ob;
        }
        InputStream zz = null;
        PBufFile.Record record = null;
        try {
            zz = this.zipFile.getInputStream(entry);
            record = PBufFile.Record.parseFrom((InputStream)zz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ob;
        }
        if (record == null) {
            return ob;
        }
        if (record.hasName()) {
            return record.getName();
        }
        if (record.hasF1D()) {
            PBufFile.Record.F1D f1d = record.getF1D();
            F1D p = new F1D(f1d.getName(), f1d.getDefinition(), f1d.getMin(), f1d.getMax());
            return p;
        }
        if (record.hasF2D()) {
            PBufFile.Record.F2D f2d = record.getF2D();
            F2D p = new F2D(f2d.getName(), f2d.getDefinition(), f2d.getMinX(), f2d.getMaxX(), f2d.getMinY(), f2d.getMaxY());
            return p;
        }
        if (record.hasFND()) {
            PBufFile.Record.FND fnd = record.getFND();
            FND p = new FND(fnd.getName(), fnd.getDefinition(), fnd.getVars());
            return p;
        }
        if (record.hasFPR()) {
            PBufFile.Record.FPR f1d = record.getFPR();
            F1D p = new F1D(f1d.getName(), f1d.getDefinition(), (double)f1d.getDivU(), (double)f1d.getDivV());
            return p;
        }
        if (record.hasP0I()) {
            PBufFile.Record.P0I p0i = record.getP0I();
            P0I p = new P0I(p0i.getName());
            for (int i = 0; i < p0i.getValueCount(); ++i) {
                p.add((int)p0i.getValue(i));
            }
            return p;
        }
        if (record.hasP0D()) {
            PBufFile.Record.P0D p0d = record.getP0D();
            P0D p = new P0D(p0d.getName());
            for (int i = 0; i < p0d.getValueCount(); ++i) {
                p.add(p0d.getValue(i));
            }
            return p;
        }
        if (record.hasPND()) {
            PBufFile.Record.PND pnd = record.getPND();
            PND p = new PND(pnd.getName());
            P0D pp = new P0D("row");
            int nn = 0;
            for (int i = 0; i < pnd.getValueCount(); ++i) {
                pp.add(pnd.getValue(i));
                if (++nn != pnd.getDimension()) continue;
                p.add(pp);
                nn = 0;
                pp.clear();
            }
            return p;
        }
        if (record.hasPNI()) {
            PBufFile.Record.PNI pnd = record.getPNI();
            PNI p = new PNI(pnd.getName());
            P0I pp = new P0I("row");
            int nn = 0;
            for (int i = 0; i < pnd.getValueCount(); ++i) {
                pp.add(pnd.getValue(i));
                if (++nn != pnd.getDimension()) continue;
                p.add(pp);
                nn = 0;
                pp.clear();
            }
            return p;
        }
        if (record.hasPXY()) {
            PBufFile.Record.PXY p1d = record.getPXY();
            P1D p = new P1D(p1d.getName());
            for (int i = 0; i < p1d.getXCount(); ++i) {
                p.add(p1d.getX(i), p1d.getY(i));
            }
            return p;
        }
        if (record.hasPXYZ()) {
            PBufFile.Record.PXYZ p1d = record.getPXYZ();
            P1D p = new P1D(p1d.getName());
            for (int i = 0; i < p1d.getXCount(); ++i) {
                p.add(p1d.getX(i), p1d.getY(i), p1d.getZ(i));
            }
            return p;
        }
        if (record.hasP1D()) {
            PBufFile.Record.P1D p1d = record.getP1D();
            P1D p = new P1D(p1d.getName());
            for (int i = 0; i < p1d.getXCount(); ++i) {
                p.add(p1d.getX(i), p1d.getY(i), p1d.getXleft(i), p1d.getXright(i), p1d.getYupper(i), p1d.getYlower(i), p1d.getXsysleft(i), p1d.getXsysright(i), p1d.getYsysupper(i), p1d.getYsyslower(i));
            }
            return p;
        }
        if (record.hasH1D()) {
            int i;
            PBufFile.Record.H1D h = record.getH1D();
            int ibins = h.getBins() + 2;
            double[] edges = new double[ibins - 1];
            double[] heights = new double[ibins];
            double[] errors = new double[ibins];
            double[] means = new double[ibins];
            double[] rms = new double[ibins];
            int[] entries = new int[ibins];
            H1D h1d = null;
            if (h.getIsFixedBins()) {
                h1d = new H1D(h.getName(), h.getBins(), h.getMin(), h.getMax());
            } else {
                for (i = 0; i < h.getBins() + 1; ++i) {
                    edges[i] = h.getEdges(i);
                }
                h1d = new H1D(h.getName(), edges);
            }
            heights[0] = h.getUnderflow();
            heights[ibins - 1] = h.getOverflow();
            h1d.setBins(h.getBins());
            h1d.setMin(h.getMin());
            h1d.setMax(h.getMax());
            h1d.setMeanAndRms(h.getMean(), h.getRms());
            for (i = 0; i < ibins - 1; ++i) {
                heights[i + 1] = h.getHeights(i);
                errors[i + 1] = h.getErrors(i);
                entries[i + 1] = h.getEntries(i);
                means[i + 1] = h.getMeans(i);
                rms[i + 1] = h.getRmses(i);
            }
            h1d.setContents(heights, errors, entries, means, rms);
            return h1d;
        }
        if (record.hasH2D()) {
            PBufFile.Record.H2D h = record.getH2D();
            int binsx = (int)h.getSummary(0);
            int minx = (int)h.getSummary(1);
            int maxx = (int)h.getSummary(2);
            int binsy = (int)h.getSummary(3);
            int miny = (int)h.getSummary(4);
            int maxy = (int)h.getSummary(5);
            H2D h2 = new H2D(h.getName(), binsx, minx, maxx, binsy, miny, maxy);
            h2.setNEntries(h.getNentries());
            h2.setMeanX(h.getSummary(6));
            h2.setRmsX(h.getSummary(7));
            h2.setMeanY(h.getSummary(8));
            h2.setRmsY(h.getSummary(9));
            int ibinsX = binsx + 2;
            int ibinsY = binsy + 2;
            double[][] newHeights = new double[ibinsX][ibinsY];
            double[][] newErrors = new double[ibinsX][ibinsY];
            double[][] newMeansX = new double[ibinsX][ibinsY];
            double[][] newRmssX = new double[ibinsX][ibinsY];
            double[][] newMeansY = new double[ibinsX][ibinsY];
            double[][] newRmssY = new double[ibinsX][ibinsY];
            int[][] newEntries = new int[ibinsX][ibinsY];
            int k = 0;
            for (int j1 = 0; j1 < ibinsX - 1; ++j1) {
                for (int j2 = 0; j2 < ibinsY - 1; ++j2) {
                    newHeights[j1 + 1][j2 + 1] = h.getHeights(k);
                    newErrors[j1 + 1][j2 + 1] = h.getErrors(k);
                    newEntries[j1 + 1][j2 + 1] = h.getEntries(k);
                    newMeansX[j1 + 1][j2 + 1] = h.getMeansX(k);
                    newRmssX[j1 + 1][j2 + 1] = h.getRmsesX(k);
                    newMeansY[j1 + 1][j2 + 1] = h.getMeansY(k);
                    newRmssY[j1 + 1][j2 + 1] = h.getRmsesY(k);
                    ++k;
                }
            }
            h2.setContents(newHeights, newErrors, newEntries, newMeansX, newMeansY, newRmssX, newRmssY);
            return h2;
        }
        return ob;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.iif != null) {
                this.iif.close();
                this.zin.close();
                this.zipFile.close();
                this.iif = null;
                this.zin = null;
                this.zipFile = null;
            }
            if (this.oof != null) {
                this.zout.finish();
                this.zout.close();
                this.oof.flush();
                this.oof.close();
                this.oof = null;
            }
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    private void ErrorMessage(String a) {
        Util.ErrorMessage((String)a);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    class FileEntry
    implements Comparable<FileEntry> {
        private String name;
        private long id;
        private long compression_size;
        private long serialized_size;

        public FileEntry(String name, long id, long compression_size, long serialized_size) {
            this.name = name;
            this.id = id;
            this.compression_size = compression_size;
            this.serialized_size = serialized_size;
        }

        public String getName() {
            return this.name;
        }

        public long getID() {
            return this.id;
        }

        public long getCompressedSize() {
            return this.compression_size;
        }

        public long getSerializedSize() {
            return this.serialized_size;
        }

        @Override
        public int compareTo(FileEntry e) {
            int a = 0;
            a = e.getID() < this.getID() ? 1 : -1;
            return a;
        }
    }
}

