/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import com.csam.dif.DIFCellExistsException;
import com.csam.dif.DIFDataPairParsingException;
import com.csam.dif.DIFKeywordException;
import com.csam.dif.DIFNumberPairInfoException;
import com.csam.dif.DIFRowExistsException;
import com.csam.dif.DIFSheet;
import com.csam.dif.DIFStringFormatException;
import hep.aida.IAxis;
import hep.aida.ref.histogram.Histogram1D;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import jhplot.H1D;
import jhplot.P0D;
import jhplot.P0I;
import jhplot.P1D;
import jhplot.PND;
import jhplot.PNI;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class HFileDIF {
    private OutputStream outStream;
    private InputStream inStream;
    private final int version = 1;
    private int nev = 0;
    private DIFSheet sheet;
    private String file;

    public HFileDIF(String file, String option) {
        this.file = file.trim();
        this.nev = 0;
        this.sheet = null;
        if (option.equalsIgnoreCase("w")) {
            try {
                new File(file).delete();
                this.outStream = new FileOutputStream(this.file);
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        } else if (option.equalsIgnoreCase("r")) {
            if (file.startsWith("http") || file.startsWith("ftp")) {
                URL url = null;
                try {
                    url = new URL(this.file);
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                try {
                    URLConnection urlConn = url.openConnection();
                    urlConn.setDoInput(true);
                    urlConn.setUseCaches(false);
                    this.inStream = new DataInputStream(urlConn.getInputStream());
                }
                catch (MalformedURLException e) {
                    System.err.println(e.toString());
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
            } else {
                try {
                    this.inStream = new FileInputStream(new File(this.file));
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
            }
        } else {
            Util.ErrorMessage((String)"Wrong option!. Only \"r\" or \"w\"  is allowed");
        }
    }

    public HFileDIF(String file) {
        this(file, "r");
    }

    public boolean write(double[] p) {
        ++this.nev;
        boolean tmp = true;
        DIFSheet sheet = new DIFSheet();
        sheet.setTitle("double[]");
        sheet.setVersion(1);
        try {
            sheet.createRow(0);
            for (int j = 0; j < p.length; ++j) {
                try {
                    sheet.getRow(0).createCell(j).setCellValue(p[j]);
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(int[] p) {
        ++this.nev;
        boolean tmp = true;
        DIFSheet sheet = new DIFSheet();
        sheet.setTitle("double[]");
        sheet.setVersion(1);
        try {
            sheet.createRow(0);
            for (int j = 0; j < p.length; ++j) {
                try {
                    sheet.getRow(0).createCell(j).setCellValue(p[j]);
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(String[] p) {
        ++this.nev;
        boolean tmp = true;
        DIFSheet sheet = new DIFSheet();
        sheet.setTitle("double[]");
        sheet.setVersion(1);
        try {
            sheet.createRow(0);
            for (int j = 0; j < p.length; ++j) {
                try {
                    sheet.getRow(0).createCell(j).setCellValue(p[j]);
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(P0I p) {
        ++this.nev;
        boolean tmp = true;
        DIFSheet sheet = new DIFSheet();
        sheet.setTitle(p.getTitle());
        sheet.setVersion(1);
        try {
            sheet.createRow(0);
            for (int j = 0; j < p.size(); ++j) {
                try {
                    sheet.getRow(0).createCell(j).setCellValue(p.get(j));
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(P0D p) {
        ++this.nev;
        boolean tmp = true;
        this.sheet = new DIFSheet();
        this.sheet.setTitle(p.getTitle());
        this.sheet.setVersion(1);
        try {
            this.sheet.createRow(0);
            for (int j = 0; j < p.size(); ++j) {
                try {
                    this.sheet.getRow(0).createCell(j).setCellValue(p.get(j));
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            this.sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(PND p) {
        ++this.nev;
        boolean tmp = true;
        this.sheet = new DIFSheet();
        this.sheet.setTitle(p.getTitle());
        this.sheet.setVersion(1);
        try {
            for (int j = 0; j < p.size(); ++j) {
                this.sheet.createRow(j);
                try {
                    double[] tt = p.get(j);
                    int dimension = tt.length;
                    for (int i = 0; i < dimension; ++i) {
                        this.sheet.getRow(j).createCell(i).setCellValue(tt[i]);
                    }
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            this.sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(PNI p) {
        ++this.nev;
        boolean tmp = true;
        this.sheet = new DIFSheet();
        this.sheet.setTitle(p.getTitle());
        this.sheet.setVersion(1);
        try {
            for (int j = 0; j < p.size(); ++j) {
                this.sheet.createRow(j);
                try {
                    int[] tt = p.get(j);
                    int dimension = tt.length;
                    for (int i = 0; i < dimension; ++i) {
                        this.sheet.getRow(j).createCell(i).setCellValue(tt[i]);
                    }
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            this.sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(H1D p) {
        ++this.nev;
        boolean tmp = true;
        this.sheet = new DIFSheet();
        this.sheet.setTitle(p.getTitle());
        this.sheet.setVersion(1);
        Histogram1D h1 = p.get();
        IAxis axis = h1.axis();
        int bins = axis.bins();
        try {
            for (int j = 0; j < bins; ++j) {
                this.sheet.createRow(j);
                try {
                    this.sheet.getRow(j).createCell(0).setCellValue(axis.binLowerEdge(j));
                    this.sheet.getRow(j).createCell(1).setCellValue(axis.binUpperEdge(j));
                    this.sheet.getRow(j).createCell(2).setCellValue(h1.binHeight(j));
                    this.sheet.getRow(j).createCell(3).setCellValue(h1.binError(j));
                    continue;
                }
                catch (DIFCellExistsException e) {
                    System.err.println(e.toString());
                    tmp = false;
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            this.sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public boolean write(P1D p) {
        ++this.nev;
        boolean tmp = true;
        int dimen = p.getDimension();
        this.sheet = new DIFSheet();
        this.sheet.setTitle(p.getTitle());
        this.sheet.setVersion(1);
        try {
            for (int i = 0; i < p.size(); ++i) {
                this.sheet.createRow(i);
                try {
                    if (dimen == 2) {
                        this.sheet.getRow(i).createCell(0).setCellValue(p.getX(i));
                        this.sheet.getRow(i).createCell(1).setCellValue(p.getY(i));
                        continue;
                    }
                    if (dimen == 3) {
                        this.sheet.getRow(i).createCell(0).setCellValue(p.getX(i));
                        this.sheet.getRow(i).createCell(1).setCellValue(p.getY(i));
                        this.sheet.getRow(i).createCell(2).setCellValue(p.getYupper(i));
                        continue;
                    }
                    if (dimen == 4) {
                        this.sheet.getRow(i).createCell(0).setCellValue(p.getX(i));
                        this.sheet.getRow(i).createCell(1).setCellValue(p.getY(i));
                        this.sheet.getRow(i).createCell(2).setCellValue(p.getYupper(i));
                        this.sheet.getRow(i).createCell(3).setCellValue(p.getYlower(i));
                        continue;
                    }
                    if (dimen == 6) {
                        this.sheet.getRow(i).createCell(0).setCellValue(p.getX(i));
                        this.sheet.getRow(i).createCell(1).setCellValue(p.getY(i));
                        this.sheet.getRow(i).createCell(2).setCellValue(p.getYupper(i));
                        this.sheet.getRow(i).createCell(3).setCellValue(p.getYlower(i));
                        this.sheet.getRow(i).createCell(4).setCellValue(p.getXleft(i));
                        this.sheet.getRow(i).createCell(5).setCellValue(p.getXright(i));
                        continue;
                    }
                    if (dimen != 10) continue;
                    this.sheet.getRow(i).createCell(0).setCellValue(p.getX(i));
                    this.sheet.getRow(i).createCell(1).setCellValue(p.getY(i));
                    this.sheet.getRow(i).createCell(2).setCellValue(p.getYupper(i));
                    this.sheet.getRow(i).createCell(3).setCellValue(p.getYlower(i));
                    this.sheet.getRow(i).createCell(4).setCellValue(p.getXleft(i));
                    this.sheet.getRow(i).createCell(5).setCellValue(p.getXright(i));
                    this.sheet.getRow(i).createCell(6).setCellValue(p.getYupperSys(i));
                    this.sheet.getRow(i).createCell(7).setCellValue(p.getYlowerSys(i));
                    this.sheet.getRow(i).createCell(8).setCellValue(p.getXleftSys(i));
                    this.sheet.getRow(i).createCell(8).setCellValue(p.getXrightSys(i));
                    continue;
                }
                catch (DIFCellExistsException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (DIFRowExistsException e) {
            System.err.println(e.toString());
            tmp = false;
        }
        try {
            this.outStream = new FileOutputStream(this.file);
            this.sheet.write(this.outStream);
            this.outStream.close();
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
        return tmp;
    }

    public DIFSheet read() {
        try {
            this.sheet = new DIFSheet(this.inStream);
        }
        catch (DIFKeywordException e) {
            e.printStackTrace();
        }
        catch (DIFDataPairParsingException e) {
            e.printStackTrace();
        }
        catch (DIFNumberPairInfoException e) {
            e.printStackTrace();
        }
        catch (DIFStringFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.sheet;
    }

    public boolean close() {
        boolean success = true;
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
        }
        catch (IOException e) {
            success = false;
            System.err.println(e.toString());
        }
        System.gc();
        return success;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

