/*
 * Decompiled with CFR 0.152.
 */
package jhplot.io;

import hep.aida.IAnalysisFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jhplot.gui.HelpBrowser;
import jhplot.utils.Util;

public class FileAida {
    private IAnalysisFactory af = null;
    private ITree itree = null;

    public FileAida(String file) {
        this.load(file, true);
    }

    public FileAida(String file, boolean readOnly) {
        this.load(file, readOnly);
    }

    public FileAida() {
    }

    public void load(String file, boolean readOnly) {
        try {
            File f = new File(file);
            this.af = IAnalysisFactory.create();
            this.itree = this.af.createTreeFactory().create(f.getAbsolutePath(), "xml", readOnly);
        }
        catch (IOException e) {
            Util.ErrorMessage((String)"Error in openning file");
        }
    }

    public void load(File f, boolean readOnly) {
        try {
            this.af = IAnalysisFactory.create();
            this.itree = this.af.createTreeFactory().create(f.getAbsolutePath(), "xml", readOnly);
        }
        catch (IOException e) {
            Util.ErrorMessage((String)"Error in openning file");
        }
    }

    public Object get(String skey) {
        IManagedObject ob = this.itree.find(skey);
        return ob;
    }

    public String[] listObjectNames() {
        return this.itree.listObjectNames();
    }

    public ArrayList<String> getAllNames(String a) {
        ArrayList<String> ar = new ArrayList<String>();
        String[] s = this.itree.listObjectNames();
        for (int i = 0; i < this.itree.listObjectNames(a).length; ++i) {
            ar.add(s[i]);
        }
        return ar;
    }

    public ArrayList<String> getAllNames() {
        ArrayList<String> ar = new ArrayList<String>();
        String[] s = this.itree.listObjectNames();
        for (int i = 0; i < this.itree.listObjectNames().length; ++i) {
            ar.add(s[i]);
        }
        return ar;
    }

    public ArrayList<String> getAllTypes() {
        ArrayList<String> ar = new ArrayList<String>();
        String[] s = this.itree.listObjectTypes();
        for (int i = 0; i < this.itree.listObjectTypes().length; ++i) {
            ar.add(s[i]);
        }
        return ar;
    }

    public ArrayList<String> getAllTypes(String a) {
        ArrayList<String> ar = new ArrayList<String>();
        String[] s = this.itree.listObjectTypes();
        for (int i = 0; i < this.itree.listObjectTypes(a).length; ++i) {
            ar.add(s[i]);
        }
        return ar;
    }

    public void cd(String dir) {
        this.itree.cd(dir);
    }

    public String pwd() {
        return this.itree.pwd();
    }

    public void close() throws IOException {
        this.itree.close();
    }

    public ArrayList<IManagedObject> getAll() {
        ArrayList<IManagedObject> ar = new ArrayList<IManagedObject>();
        String[] s = this.itree.listObjectNames();
        for (int i = 0; i < this.itree.listObjectNames().length; ++i) {
            ar.add(this.itree.find(s[i]));
        }
        return ar;
    }

    public ITree getITree() {
        return this.itree;
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

