/*
 * Decompiled with CFR 0.152.
 */
package jhplot.bsom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import jhplot.bsom.Bsom;
import jhplot.bsom.DrawArea;
import jhplot.bsom.UserData;

public class BsomDrawArea
extends DrawArea {
    private static final long serialVersionUID = 1L;
    Vector<Double> buf;
    public boolean draw_new_data;
    Graphics datagraphics;
    Image datascreen;

    BsomDrawArea(Bsom demo, int xd, int yd, double scale) {
        super(demo, xd, yd, scale);
    }

    @Override
    void initData() {
        this.n_data = this.buf.size() / 2;
        this.X = new UserData(this.n_data, this.scale, 0, this.xd, this.yd, this.buf);
    }

    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.draw_new_data = true;
        }
        if (this.draw_new_data) {
            this.datascreen = this.createImage(d.width, d.height);
            this.datagraphics = this.datascreen.getGraphics();
            this.datagraphics.setColor(this.getBackground());
            this.datagraphics.fillRect(0, 0, d.width, d.height);
            this.datagraphics.setColor(Color.black);
            this.X.draw(this.datagraphics);
            this.draw_new_data = false;
        }
        if (!this.density_mode) {
            this.offgraphics.drawImage(this.datascreen, 0, 0, null);
        } else {
            g.drawString("Now, density is calculated.", 0, 10);
            this.drawDensity(this.offgraphics);
            this.offgraphics.setColor(Color.red);
            UserData UX = (UserData)this.X;
            double s = UX.dscale * UX.dscale;
            this.offgraphics.drawString("a=" + this.alpha * s, 0, 10);
            this.offgraphics.drawString("b=" + this.beta * s, 0, 20);
            this.offgraphics.setColor(Color.green);
            this.X.draw(this.offgraphics);
        }
        this.offgraphics.setColor(Color.blue);
        this.W.draw(this.offgraphics);
        this.W.drawCurve(this.offgraphics);
        this.paint(g);
    }
}

