/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import carmetal.construction.Construction;
import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.window.MainWindow;
import carmetal.eric.JGlobalPreferences;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import java.awt.Dimension;
import java.io.File;

public class HZirkel {
    private static final long serialVersionUID = 1L;
    public static final long Version = 110L;
    public static boolean IsApplet = false;
    private ZirkelFrame zframe;
    private MainWindow mw;

    public HZirkel() {
        this(600, 500);
    }

    public HZirkel(int Xsize, int Ysize) {
        Global.DetectDesktopSize();
        String USER_HOME = System.getProperty("user.home");
        String PREFS_FILENAME = USER_HOME + File.separator + ".jehep" + File.separator + "carmetal_config.txt";
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            PREFS_FILENAME = USER_HOME + File.separator + "jehep" + File.separator + "carmetal_config.txt";
        }
        Global.loadProperties((String)PREFS_FILENAME);
        Global.initBundles();
        Global.setParameter((String)"jsdumb", (boolean)Global.getParameter((String)"jsdumb", (boolean)true));
        Global.initProperties();
        JGlobalPreferences.initPreferences();
        JPropertiesBar.CreatePopertiesBar();
        this.mw = new MainWindow();
        JZirkelCanvas.getCurrentJZF().setPreferredSize(new Dimension(Xsize, Ysize));
        PaletteManager.init();
        JZirkelCanvas.ActualiseMacroPanel();
    }

    public ZirkelCanvas getCanvas() {
        return JZirkelCanvas.getCurrentJZF().getZC();
    }

    public void draw(ConstructionObject obj) {
        this.add(obj);
        JZirkelCanvas.repaintZC();
    }

    public Construction getConstruction() {
        return this.getCanvas().getConstruction();
    }

    public void add(ConstructionObject obj) {
        this.getCanvas().addObject(obj);
    }

    public void update() {
        JZirkelCanvas.repaintZC();
        JZirkelCanvas.getCurrentJZF().getReplay().newHistory();
    }

    public void close() {
        JZirkelCanvas.closeCurrent();
    }

    public void exit() {
        this.mw.setVisible(true);
        this.mw.dispose();
    }

    public void clear() {
        this.zframe.ZC.clear();
        JZirkelCanvas.repaintZC();
    }

    public void setAxis(boolean axis) {
        this.getCanvas().setAxis_show(axis);
        JZirkelCanvas.repaintZC();
    }

    public void export(String file) {
        int i = file.lastIndexOf(46);
        String ext = "eps";
        if (i > 0 && i < file.length() - 1) {
            ext = file.substring(i + 1).toLowerCase();
        }
        if (ext.equalsIgnoreCase("eps")) {
            FileTools.saveeps((String)file);
        }
        if (ext.equalsIgnoreCase("png")) {
            FileTools.savepng((String)file);
        }
        if (ext.equalsIgnoreCase("svg")) {
            FileTools.saveSVG((String)file);
        }
    }
}

