/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jhplot.JHPlot;
import jhplot.P2D;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.ExportVGraphics;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.render.ps.EPSTranscoder;
import org.freehep.graphicsbase.util.export.ExportFileType;
import visad.AxisScale;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.Irregular3DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ThingReference;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;

public class HVisAd
extends JFrame {
    private static final long serialVersionUID = 1L;
    private DisplayImpl display;
    private DisplayRenderer render;
    private boolean is3D = true;
    private int xsize = 600;
    private int ysize = 600;
    private GraphicsModeControl dispGMC;
    private MouseBehavior mouseBehavior;
    private ProjectionControl proj;
    private ScalarMap rX;
    private ScalarMap rY;
    private ScalarMap rZ;
    private RealType xx;
    private RealType yy;
    private RealType zz;
    private Color background = Color.blue;
    private Color foreground = Color.gray;

    public HVisAd(String title, int xsize, int ysize, boolean is3D) {
        double[] t1;
        double scale;
        double[] tstart;
        KeyboardBehaviorJ2D key;
        DisplayRendererJ2D render;
        this.is3D = is3D;
        this.xsize = xsize;
        this.ysize = ysize;
        if (is3D) {
            try {
                this.display = new DisplayImplJ3D(title);
                this.display.getGraphicsModeControl().setPointSize(4.0f);
                render = (DisplayRendererJ3D)this.display.getDisplayRenderer();
                key = new KeyboardBehaviorJ3D((DisplayRendererJ3D)render);
                render.addKeyboardBehavior((KeyboardBehaviorJ3D)key);
                this.dispGMC = this.display.getGraphicsModeControl();
                this.dispGMC.setScaleEnable(true);
                render.setBackgroundColor(this.background);
                render.setCursorColor(Color.red);
                render.setForegroundColor(this.foreground);
                render.setBoxOn(false);
                this.proj = render.getDisplay().getProjectionControl();
                this.mouseBehavior = render.getMouseBehavior();
                tstart = this.proj.getMatrix();
                scale = 0.9;
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
                t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
                this.proj.setMatrix(t1);
                this.render = render;
            }
            catch (RemoteException | VisADException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.display = new DisplayImplJ2D(title);
                render = (DisplayRendererJ2D)this.display.getDisplayRenderer();
                key = new KeyboardBehaviorJ2D(render);
                render.addKeyboardBehavior(key);
                this.dispGMC = this.display.getGraphicsModeControl();
                this.dispGMC.setScaleEnable(true);
                render.setBackgroundColor(this.background);
                render.setCursorColor(Color.red);
                render.setForegroundColor(this.foreground);
                render.setBoxOn(false);
                this.proj = render.getDisplay().getProjectionControl();
                tstart = this.proj.getMatrix();
                this.mouseBehavior = render.getMouseBehavior();
                scale = 0.9;
                t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
                t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
                this.proj.setMatrix(t1);
                this.render = render;
            }
            catch (RemoteException | VisADException e) {
                e.printStackTrace();
            }
        }
        this.setTitle(title);
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenu help2 = new JMenu("Help");
        JMenuItem item1 = new JMenuItem("Export");
        item1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HVisAd.this.exportDialog();
            }
        });
        JMenuItem item2 = new JMenuItem("Close");
        item2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HVisAd.this.close();
            }
        });
        JMenuItem item3 = new JMenuItem("Help");
        item3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HVisAd.this.help();
            }
        });
        menu.add(item1);
        menu.add(item2);
        help2.add(item3);
        bar.add(menu);
        bar.add(help2);
        this.setJMenuBar(bar);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.display.getComponent());
        this.setSize(xsize, ysize);
    }

    public HVisAd(String title, int xsize, int ysize) {
        this(title, xsize, ysize, true);
    }

    public HVisAd(String title, boolean is3D) {
        this(title, 600, 600, is3D);
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public void setScaling(double scale) {
        this.proj = this.render.getDisplay().getProjectionControl();
        this.mouseBehavior = this.render.getMouseBehavior();
        double[] tstart = this.proj.getMatrix();
        double[] t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
        t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
        try {
            this.proj.setMatrix(t1);
        }
        catch (RemoteException | VisADException e) {
            System.err.println(e.toString());
        }
    }

    public double getScaling() {
        this.proj = this.render.getDisplay().getProjectionControl();
        double[] tstart = this.proj.getMatrix();
        return tstart[2];
    }

    public void setRotation(double rotX, double rotY, double rotZ) {
        this.proj = this.render.getDisplay().getProjectionControl();
        this.mouseBehavior = this.render.getMouseBehavior();
        double[] tstart = this.proj.getMatrix();
        double[] t1 = this.mouseBehavior.make_matrix(rotX, rotY, rotZ, 1.0, 0.0, 0.0, 0.0);
        t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
        try {
            this.proj.setMatrix(t1);
        }
        catch (RemoteException | VisADException e) {
            System.err.println(e.toString());
        }
    }

    public void setTranslation(double X, double Y, double Z) {
        this.proj = this.render.getDisplay().getProjectionControl();
        this.mouseBehavior = this.render.getMouseBehavior();
        double[] tstart = this.proj.getMatrix();
        double[] t1 = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, X, Y, Z);
        t1 = this.mouseBehavior.multiply_matrix(t1, tstart);
        try {
            this.proj.setMatrix(t1);
        }
        catch (RemoteException | VisADException e) {
            System.err.println(e.toString());
        }
    }

    public double[] getRotation() {
        this.proj = this.render.getDisplay().getProjectionControl();
        this.mouseBehavior = this.render.getMouseBehavior();
        double[] tstart = this.proj.getMatrix();
        double[] rotA = new double[]{tstart[0], tstart[1], tstart[2]};
        return rotA;
    }

    public double[] getTranslation() {
        this.proj = this.render.getDisplay().getProjectionControl();
        this.mouseBehavior = this.render.getMouseBehavior();
        double[] tstart = this.proj.getMatrix();
        double[] rotA = new double[]{tstart[4], tstart[5], tstart[6]};
        return rotA;
    }

    public ProjectionControl getProjection() {
        return this.proj;
    }

    public MouseBehavior getMouse() {
        return this.mouseBehavior;
    }

    public GraphicsModeControl getControl() {
        return this.dispGMC;
    }

    public DisplayRenderer getRender() {
        return this.display.getDisplayRenderer();
    }

    public HVisAd() {
        this("VisAd", 600, 600, true);
    }

    public HVisAd(String title) {
        this(title, 600, 600, true);
    }

    public void clear() {
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void draw(P2D p) {
        int nn = p.size();
        float[][] ntuple = new float[3][nn];
        for (int i = 0; i < nn; ++i) {
            ntuple[0][i] = (float)p.getX(i);
            ntuple[1][i] = (float)p.getY(i);
            ntuple[2][i] = (float)p.getZ(i);
        }
        this.draw(ntuple, p.getTitle());
    }

    public void draw(float[][] ntuple) {
        this.draw(ntuple, "default");
    }

    public void draw(float[][] ntuple, String title) {
        try {
            RealTupleType domain_tuple = new RealTupleType(this.xx, this.yy, this.zz);
            Irregular3DSet domain_set = new Irregular3DSet((MathType)domain_tuple, ntuple);
            DataReferenceImpl data_ref = new DataReferenceImpl(title);
            data_ref.setData((Data)domain_set);
            this.display.addReference((ThingReference)data_ref);
            this.display.addMap(this.rX);
            this.display.addMap(this.rY);
            this.display.addMap(this.rZ);
        }
        catch (RemoteException | VisADException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<AxisScale> setAxes(String nameX, double minX, double maxX, String nameY, double minY, double maxY, String nameZ, double minZ, double maxZ) {
        this.xx = RealType.getRealType((String)"x", null, null);
        this.yy = RealType.getRealType((String)"y", null, null);
        this.zz = RealType.getRealType((String)"z", null, null);
        float[] col = new float[]{0.1f, 0.1f, 0.1f};
        Font ff = new Font("Arial", 0, 16);
        try {
            this.rX = new ScalarMap((ScalarType)this.xx, Display.XAxis);
            this.rY = new ScalarMap((ScalarType)this.yy, Display.YAxis);
            this.rZ = new ScalarMap((ScalarType)this.zz, Display.ZAxis);
            this.rX.setScaleColor(col);
            this.rY.setScaleColor(col);
            this.rZ.setScaleColor(col);
            try {
                if (maxX > minX) {
                    this.rX.setRange(minX, maxX);
                }
                if (maxY > minY) {
                    this.rY.setRange(minY, maxY);
                }
                if (maxZ > minZ) {
                    this.rZ.setRange(minZ, maxZ);
                }
                AxisScale axisX = this.rX.getAxisScale();
                axisX.setFont(ff);
                axisX.setLabelSize(16);
                axisX.setSnapToBox(true);
                axisX.setColor(this.foreground);
                AxisScale axisY = this.rY.getAxisScale();
                axisY.setFont(ff);
                axisY.setLabelSize(16);
                axisY.setSnapToBox(true);
                axisY.setColor(this.foreground);
                AxisScale axisZ = this.rZ.getAxisScale();
                axisZ.setFont(ff);
                axisZ.setLabelSize(16);
                axisZ.setSnapToBox(true);
                axisZ.setColor(this.foreground);
                ArrayList<AxisScale> xyz = new ArrayList<AxisScale>();
                xyz.add(axisX);
                xyz.add(axisY);
                xyz.add(axisZ);
                return xyz;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void visible(boolean vs) {
        if (!vs) {
            this.setVisible(false);
        } else {
            this.setSize(this.xsize, this.ysize);
            this.setVisible(true);
        }
    }

    public void update() {
        this.display.reDisplayAll();
        this.validate();
    }

    public void visible() {
        this.visible(true);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    public void export(String filename) {
        int calculatedWidth = this.xsize;
        int calculatedHeight = this.ysize;
        if (calculatedWidth <= 0) {
            calculatedWidth = 600;
        }
        if (calculatedHeight <= 0) {
            calculatedHeight = 400;
        }
        this.export(filename, calculatedWidth, calculatedHeight);
    }

    public void export(String filename, int width, int height) {
        String[] ext;
        File f = new File(filename);
        ExportFileType t = null;
        int dot = filename.lastIndexOf(46);
        String base = dot == -1 ? filename : filename.substring(0, dot);
        String fext = dot == -1 ? "" : filename.substring(dot + 1);
        fext = fext.trim();
        List list = ExportFileType.getExportFileTypes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !fext.equalsIgnoreCase((ext = (t = (ExportFileType)iterator.next()).getExtensions())[0]) && !ext[0].equalsIgnoreCase("svg") && !fext.equalsIgnoreCase(ext[0])) {
            t = null;
        }
        String rootKey = "";
        String SAVE_AS_TYPE = rootKey + ".SaveAsType";
        String SAVE_AS_FILE = rootKey + ".SaveAsFile";
        Properties props = new Properties();
        String a = t.getDescription();
        props.put(SAVE_AS_FILE, filename);
        props.put(SAVE_AS_TYPE, a);
        String metadata = "(C) DataMelt (https://datamelt.org/). S.Chekanov";
        String fname = filename;
        String filetype = "pdf";
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            filetype = fname.substring(i + 1);
        }
        Component cp = this.display.getComponent();
        try {
            if (filetype.equalsIgnoreCase("png")) {
                DisplayRenderer ren = this.display.getDisplayRenderer();
                BufferedImage b = ren.getImage();
                ImageIO.write((RenderedImage)b, "png", new File(fname));
            } else if (filetype.equalsIgnoreCase("jpg") || filetype.equalsIgnoreCase("jpeg")) {
                DisplayRenderer ren = this.display.getDisplayRenderer();
                BufferedImage b = ren.getImage();
                ImageIO.write((RenderedImage)b, "jpg", new File(fname));
            } else if (filetype.equalsIgnoreCase("eps")) {
                ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
                t.exportToFile((OutputStream)bytes2, cp, cp, props, "(C) DataMelt (https://datamelt.org/). S.Chekanov");
                bytes2.flush();
                byte[] bb = bytes2.toByteArray();
                bytes2.close();
                if (bb == null) {
                    return;
                }
                if (bb.length < 1) {
                    return;
                }
                TranscoderInput input = new TranscoderInput((InputStream)new ByteArrayInputStream(bb));
                FileOutputStream os = new FileOutputStream(filename);
                EPSTranscoder trans = new EPSTranscoder();
                TranscoderOutput output = new TranscoderOutput((OutputStream)os);
                trans.transcode(input, output);
                os.flush();
                os.close();
            } else if (filetype.equalsIgnoreCase("ps")) {
                JOptionPane.showMessageDialog(this, "PS format not supported");
            } else if (filetype.equalsIgnoreCase("pdf")) {
                JOptionPane.showMessageDialog(this, "PDF format not supported");
            } else if (filetype.equalsIgnoreCase("svg")) {
                JOptionPane.showMessageDialog(this, "SVG format not supported");
            }
        }
        catch (IOException | TranscoderException e) {
            e.printStackTrace();
        }
    }

    protected void exportImage() {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Portable Network Graphics (*.png)", "png"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JPEG Raster Images (*.jpg, *.jpeg)", "jpg", "jpeg"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        final File sFile = new File("dmelt.png");
        fileChooser.setSelectedFile(sFile);
        fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o instanceof FileNameExtensionFilter) {
                    FileNameExtensionFilter filter = (FileNameExtensionFilter)o;
                    String ex = filter.getExtensions()[0];
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile == null) {
                        selectedFile = sFile;
                    }
                    String path = selectedFile.getName();
                    path = path.substring(0, path.lastIndexOf("."));
                    fileChooser.setSelectedFile(new File(path + "." + ex));
                }
            }
        });
        if (fileChooser.showDialog(this, "Save As") == 0) {
            int res;
            final File scriptFile = fileChooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            JHPlot.showStatusBarText(mess);
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HVisAd.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    private void exportDialog() {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setFileSelectionMode(0);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Portable Network Graphics (*.png)", "png"));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JPEG Raster Images (*.jpg, *.jpeg)", "jpg", "jpeg"));
        fileChooser.setAcceptAllFileFilterUsed(true);
        final File sFile = new File("dmelt.png");
        fileChooser.setSelectedFile(sFile);
        fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o instanceof FileNameExtensionFilter) {
                    FileNameExtensionFilter filter = (FileNameExtensionFilter)o;
                    String ex = filter.getExtensions()[0];
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile == null) {
                        selectedFile = sFile;
                    }
                    String path = selectedFile.getName();
                    path = path.substring(0, path.lastIndexOf("."));
                    fileChooser.setSelectedFile(new File(path + "." + ex));
                }
            }
        });
        if (fileChooser.showDialog(this, "Export to ") == 0) {
            int res;
            final File scriptFile = ExportVGraphics.getSelectedFileWithExtension(fileChooser);
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(this, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HVisAd.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    public void help() {
        String shelp = "Help on 2D display of HVisAd";
        if (this.is3D) {
            shelp = "Help on 3D display of HVisAd";
        }
        String st = "<html><h2>" + shelp + "</h2>Central mouse button: Show coordinates<p>Arrow keys: rotate up, down, left, right <p>Zoom in: Shift + Up arrow <p>Zoom out: Shift + Down arrow <p>Rotate: Shift + Left arrow (Right arrow) <p>Translate: Ctrl + Arrow keys - translate up, down, left, right <p>Reset: Ctrl + R key - reset to original projection <html>";
        JOptionPane.showMessageDialog(this, st);
    }
}

