/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAxis;
import hep.aida.IProfile1D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Profile1D;
import hep.aida.ref.histogram.VariableAxis;
import hep.io.root.interfaces.TAxis;
import hep.io.root.interfaces.TProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import jhplot.H1D;
import jhplot.HTable;
import jhplot.P0D;
import jhplot.gui.HelpBrowser;
import jhplot.utils.SHisto;
import root.Converter;

public class HProf1D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Profile1D h1;
    private IAxis axis;
    private double min;
    private double max;
    private int bins;
    private double[] edges;
    private String title;

    public HProf1D() {
        this.title = "NOT SET";
    }

    public HProf1D(String title, int bins, double min, double max) {
        this.title = title;
        this.bins = bins;
        this.min = min;
        this.max = max;
        this.axis = new FixedAxis(this.bins, this.min, this.max);
        this.h1 = new Profile1D(this.title, this.title, this.axis);
    }

    public HProf1D(String title, double[] edges) {
        this.edges = edges;
        this.title = title;
        this.bins = edges.length - 1;
        this.min = edges[0];
        this.max = edges[edges.length - 1];
        this.axis = new VariableAxis(edges);
        this.h1 = new Profile1D(this.title, this.title, this.axis);
    }

    public HProf1D(String title, IAxis axis) {
        this.title = title;
        this.axis = axis;
        this.min = axis.lowerEdge();
        this.max = axis.upperEdge();
        this.bins = axis.bins();
        this.h1 = new Profile1D(this.title, this.title, axis);
    }

    public HProf1D(Profile1D h1) {
        this.h1 = h1;
        this.title = h1.title();
        this.axis = h1.axis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
    }

    public HProf1D(IProfile1D h1) {
        this.h1 = (Profile1D)h1;
        this.title = h1.title();
        this.axis = h1.axis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
    }

    public HProf1D(String title, HProf1D h1d) {
        this.title = title;
        this.axis = h1d.getAxis();
        this.min = this.axis.lowerEdge();
        this.max = this.axis.upperEdge();
        this.bins = this.axis.bins();
        this.h1 = h1d.get();
    }

    public void print() {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        IAxis axis = this.h1.axis();
        System.out.println("");
        System.out.println("# DataMelt: output from H1D: " + this.title);
        System.out.println("# DataMelt: created at " + today);
        System.out.println("# x,  y,  error(upper),  error(lower)");
        System.out.println("#");
        for (int i = 0; i < axis.bins(); ++i) {
            String x = dfb.format(this.h1.binMean(i));
            String y = dfb.format(this.h1.binHeight(i));
            String y1 = dfb.format(this.h1.binError(i));
            String y2 = dfb.format(this.h1.binError(i));
            System.out.println(x + "    " + y + "    " + y1 + "    " + y2);
        }
    }

    public void fillP0D(P0D p0d, P0D p1d) {
        for (int i = 0; i < p0d.size(); ++i) {
            this.h1.fill(p0d.get(i), p1d.get(i));
        }
    }

    public IAxis getAxis() {
        return this.axis;
    }

    public double binCenter(int index) {
        return this.axis.binCenter(index);
    }

    public double[] binCenters() {
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binCenter(i);
        }
        return tmp;
    }

    public double binLowerEdge(int index) {
        return this.axis.binLowerEdge(index);
    }

    public double[] binLowerEdges() {
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binLowerEdge(i);
        }
        return tmp;
    }

    public double binUpperEdge(int index) {
        return this.axis.binUpperEdge(index);
    }

    public double[] binUpperEdges() {
        double[] tmp = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            tmp[i] = this.axis.binUpperEdge(i);
        }
        return tmp;
    }

    public void toTable() {
        new HTable(this.getH1D(this.title));
    }

    public void toFile(String name) {
        DecimalFormat dfb = new DecimalFormat("##.#####E00");
        Date dat = new Date();
        String today = String.valueOf(dat);
        IAxis axis = this.h1.axis();
        try {
            FileOutputStream f1 = new FileOutputStream(new File(name));
            PrintStream tx = new PrintStream(f1);
            tx.println("# DataMelt: output from H1D " + this.title);
            tx.println("# DataMelt: created at " + today);
            tx.println("# x,  y,  error(upper),  error(lower)");
            tx.println("#");
            for (int i = 0; i < axis.bins(); ++i) {
                String x = dfb.format(this.h1.binMean(i));
                String y = dfb.format(this.h1.binHeight(i));
                String y1 = dfb.format(this.h1.binError(i));
                String y2 = dfb.format(this.h1.binError(i));
                tx.println(x + "    " + y + "    " + y1 + "    " + y2);
            }
            f1.close();
        }
        catch (IOException e) {
            this.ErrorMessage("Error in the output file");
            e.printStackTrace();
        }
    }

    public HProf1D(TProfile h1t) {
        this.title = h1t.getTitle();
        this.setTitle(this.title);
        TAxis axis = h1t.getXaxis();
        this.min = axis.getXmin();
        this.max = axis.getXmax();
        this.h1 = Converter.convert(h1t, this.title);
    }

    public void setContents(double[] values, double[] errors) {
        this.h1.setContents(values, errors, null, null, null);
    }

    public void setContents(double[] heights, double[] errors, int[] entries, double[] means, double[] rmss) {
        this.h1.setContents(heights, errors, entries, means, rmss);
    }

    public void setMeanAndRms(double mean, double rms) {
        this.h1.setMean(mean);
        this.h1.setRms(rms);
    }

    public void setNEntries(int entries) {
        this.h1.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.h1.setValidEntries(entries);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public Profile1D get() {
        return this.h1;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.min = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public int getBins() {
        return this.bins;
    }

    public double getBinSize() {
        return (this.max - this.min) / (double)this.bins;
    }

    public void shift(double d) {
        int i;
        int ibins = this.h1.axis().bins() + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i);
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i) + d;
            newRmss[i + 1] = this.h1.binRms(i);
        }
        if (this.axis.isFixedBinning()) {
            this.axis = new FixedAxis(this.bins, this.min + d, this.max + d);
        } else {
            for (i = 0; i < this.edges.length; ++i) {
                this.edges[i] = this.edges[i] + d;
                this.axis = new VariableAxis(this.edges);
            }
        }
        double m = this.h1.mean() + d;
        double r = this.h1.rms();
        this.h1 = new Profile1D(this.title, this.title, this.axis);
        this.h1.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        this.setMeanAndRms(m, r);
    }

    public boolean isFixedBinning() {
        return this.axis.isFixedBinning();
    }

    public void fill(double x, double y) {
        this.h1.fill(x, y);
    }

    public void fill(double x, double y, double weight) {
        this.h1.fill(x, y, weight);
    }

    public void fill(double[] x, double[] y) {
        if (x.length != y.length) {
            System.out.println("Wrong length for arrays!");
        } else {
            for (int i = 0; i < x.length; ++i) {
                this.h1.fill(x[i], y[i]);
            }
        }
    }

    public void fill(double[] x, double[] y, double[] weight) {
        if (x.length != y.length) {
            System.out.println("Wrong length for arrays!");
        } else {
            for (int i = 0; i < x.length; ++i) {
                this.h1.fill(x[i], y[i], weight[i]);
            }
        }
    }

    public double mean() {
        return this.h1.mean();
    }

    public double rms() {
        return this.h1.rms();
    }

    public int allEntries() {
        return this.h1.allEntries();
    }

    public int extraEntries() {
        return this.h1.extraEntries();
    }

    public int entries() {
        return this.h1.entries();
    }

    public int getUnderflow() {
        return this.h1.binEntries(-2);
    }

    public double getUnderflowHeight() {
        return this.h1.binHeight(-2);
    }

    public double getOverflowlowHeight() {
        return this.h1.binHeight(-1);
    }

    public int getOverflow() {
        return this.h1.binEntries(-1);
    }

    public void fillInvBinSizeWeight(double value) {
        int binNum = this.h1.axis().coordToIndex(value);
        this.h1.fill(value, 1.0 / this.h1.axis().binWidth(binNum));
    }

    public void scale(String title, double scaleFactor) {
        this.title = title;
        this.h1.scale(scaleFactor);
    }

    public void scale(double scaleFactor) {
        this.h1.scale(scaleFactor);
    }

    public HProf1D operSmooth(boolean isWeighted, int k) {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        double[] ee = this.binErrors();
        sh.setBins(hh);
        sh = sh.getSmoothed(isWeighted, k);
        double[] hh1 = new double[this.bins + 2];
        double[] ee1 = new double[this.bins + 2];
        hh1[0] = this.getUnderflowHeight();
        hh1[this.bins - 1] = this.getOverflowlowHeight();
        for (int i = 1; i < this.bins + 1; ++i) {
            hh1[i] = sh.getBinsFirstBand(i - 1);
            ee1[i] = ee[i - 1];
        }
        this.h1.setContents(hh1, ee1, null, null, null);
        return this;
    }

    public HProf1D operSmoothGauss(double standardDeviation) {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        double[] ee = this.binErrors();
        sh.setBins(hh);
        sh = sh.getGaussianSmoothed(standardDeviation);
        double[] hh1 = new double[this.bins + 2];
        double[] ee1 = new double[this.bins + 2];
        hh1[0] = this.getUnderflowHeight();
        hh1[this.bins - 1] = this.getOverflowlowHeight();
        for (int i = 1; i < this.bins + 1; ++i) {
            hh1[i] = sh.getBinsFirstBand(i - 1);
            ee1[i] = ee[i - 1];
        }
        this.h1.setContents(hh1, ee1, null, null, null);
        return this;
    }

    public double getEntropy() {
        SHisto sh = new SHisto(this.bins, this.min, this.max, 1);
        double[] hh = this.binHeights();
        sh.setBins(hh);
        double[] s = sh.getEntropy();
        return s[0];
    }

    public HProf1D copy() {
        return this.copy(this.title);
    }

    public HProf1D copy(String newtitle) {
        int ibins = this.bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i);
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        HProf1D hnew = new HProf1D(newtitle, this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        hnew.setNEntries(this.entries());
        hnew.setMeanAndRms(this.mean(), this.rms());
        return hnew;
    }

    public H1D getH1D() {
        return this.getH1D(this.title);
    }

    public H1D getH1D(String newtitle) {
        return this.getH1D(newtitle, "mean");
    }

    public H1D getH1D(String newtitle, String option) {
        int ibins = this.bins + 2;
        double[] newHeights = new double[ibins];
        double[] newErrors = new double[ibins];
        double[] newMeans = new double[ibins];
        double[] newRmss = new double[ibins];
        int[] newEntries = new int[ibins];
        newHeights[0] = this.getUnderflowHeight();
        newHeights[ibins - 1] = this.getOverflowlowHeight();
        for (int i = 0; i < ibins - 1; ++i) {
            newHeights[i + 1] = this.h1.binHeight(i);
            newErrors[i + 1] = this.h1.binError(i);
            if (option == "s" || option == "S") {
                newErrors[i + 1] = this.h1.binRms(i);
            }
            newEntries[i + 1] = this.h1.binEntries(i);
            newMeans[i + 1] = this.h1.binMean(i);
            newRmss[i + 1] = this.h1.binRms(i);
        }
        H1D hnew = new H1D(newtitle, this.axis);
        hnew.setContents(newHeights, newErrors, newEntries, newMeans, newRmss);
        hnew.setMeanAndRms(this.h1.mean(), this.h1.rms());
        hnew.setNEntries(this.entries());
        hnew.setMeanAndRms(this.mean(), this.rms());
        return hnew;
    }

    public int binEntries(int index) {
        return this.h1.binEntries(index);
    }

    public int[] binEntries() {
        int[] hh = new int[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binEntries(i);
        }
        return hh;
    }

    public double binError(int index) {
        return this.h1.binError(index);
    }

    public double binHeight(int index) {
        return this.h1.binHeight(index);
    }

    public double[] binHeights() {
        double[] hh = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binHeight(i);
        }
        return hh;
    }

    public double[] binErrors() {
        double[] hh = new double[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            hh[i] = this.h1.binError(i);
        }
        return hh;
    }

    public double binMean(int index) {
        return this.h1.binMean(index);
    }

    public double binRms(int index) {
        return this.h1.binRms(index);
    }

    public double maxBinHeight() {
        return this.h1.maxBinHeight();
    }

    public double minBinHeight() {
        return this.h1.minBinHeight();
    }

    public double sumAllBinHeights() {
        return this.h1.sumAllBinHeights();
    }

    public double[][] getValues(int mode) {
        int i;
        double[][] nums = new double[3][];
        for (i = 0; i < 3; ++i) {
            nums[i] = new double[this.bins];
        }
        for (i = 0; i < this.bins; ++i) {
            nums[0][i] = this.h1.binMean(i);
            if (mode == 1) {
                nums[0][i] = this.binCenter(i);
            }
            nums[1][i] = this.h1.binHeight(i);
            nums[2][i] = this.h1.binError(i);
        }
        return nums;
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }
}

