/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import hep.aida.IAnalysisFactory;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Histogram1D;
import japlot.Global;
import japlot.jaxodraw.JaxoDraw;
import japlot.jaxodraw.JaxoGraph;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import jhplot.F1D;
import jhplot.FND;
import jhplot.H1D;
import jhplot.H2D;
import jhplot.JHPlot;
import jhplot.P1D;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.ConvertSVG;
import jhplot.jadraw.JaAxes;
import jhplot.jadraw.JaBox;
import jhplot.jadraw.JaKey;
import jhplot.jadraw.JaLine;
import jhplot.jadraw.JaObject;
import jhplot.jadraw.JaText;
import jhplot.jadraw.JaTextBox;
import jplot.DataArray;
import jplot.Translate;

public class HPlotJa
extends JComponent {
    public static final int LabelX = 1;
    public static final int LabelY = 2;
    public static final int Title = 3;
    public static final int StatBox = 4;
    public static final int Exponent = 5;
    public static final int Key = 6;
    protected static int isOpen = 0;
    private JaText gTitle;
    private static final long serialVersionUID = 1L;
    private static ResourceBundle language;
    private final int X = 0;
    private final int Y = 1;
    private double MarginLeft = 0.1;
    private double MarginRight = 0.1;
    private double MarginTop = 0.1;
    private double MarginBottom = 0.1;
    private double MarginX = 0.12;
    private double MarginY = 0.12;
    private DecimalFormat dfb = new DecimalFormat("##.###E00");
    protected JaAxes[][] ja;
    private static String inputFile;
    private JaText[][] labelX;
    private JaText[][] labelY;
    private JaTextBox[][] statbox;
    private boolean[][] showStatBox;
    private ArrayList<JaObject> initList = null;
    private JaxoMainPanel feyn;
    private IAnalysisFactory m_IAnalysisFactory = null;
    private IHistogramFactory m_IHistogramFactory = null;
    private ITree m_ITree = null;
    private IFitFactory m_IFitFactory = null;
    private IFunctionFactory m_IFunctionFactory = null;
    public static final String VERSION_NUMBER = "1.0";
    public static final String VERSION = "japlot.jaxodraw-1.0";
    public static final String WEB_SITE = "http://jaxodraw.sourceforge.net";
    public static final String USER_NAME;
    public static final String USER_HOME;
    public static final String OS_NAME;
    public static final String OS_ARCH;
    public static final String OS_VERSION;
    public static final String JAVA_VERSION;
    public static final String JAVA_RUNTIME_VERSION;
    public static final String JAVA_HOME;
    public static final String JAVA_CLASSPATH;
    public static String PREFS_FILENAME;
    private static String curDIR;
    private int N1final;
    private int N2final;
    private int N1;
    private int N2;
    private int xsize = 800;
    private int ysize = 650;
    private double keyspace;
    private boolean isSet = false;
    private final Font fontLabel = new Font("Arial", 1, 18);
    private static double[][] lastKeyLocation;

    public HPlotJa(String title, int xsize, int ysize, int n1, int n2, boolean setgraph) {
        this.xsize = xsize;
        this.ysize = ysize;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int Sheight = screenSize.height;
        int Swidth = screenSize.width;
        if (Swidth < this.xsize || Sheight < this.ysize) {
            this.xsize = (int)(0.5 * (double)Swidth);
            this.ysize = (int)(0.5 * (double)Sheight);
        }
        this.isSet = setgraph;
        PREFS_FILENAME = USER_HOME + File.separator + ".dmelt" + File.separator + "japlot.pref";
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows") > -1 || OS.indexOf("nt") > -1) {
            PREFS_FILENAME = USER_HOME + File.separator + "dmelt" + File.separator + "japlot.pref";
        }
        this.N1 = 0;
        this.N2 = 0;
        if (n1 == 0 || n2 == 0) {
            n1 = 1;
            n2 = 1;
        }
        language = ResourceBundle.getBundle(JaxoPrefs.getPref((int)4));
        HPlotJa.getUserDir();
        HPlotJa.getPreferences();
        JaxoPrefs.setIntPref((int)100, (int)xsize);
        JaxoPrefs.setIntPref((int)101, (int)ysize);
        Global.init((int)xsize, (int)ysize);
        this.initList = new ArrayList();
        this.feyn = new JaxoMainPanel(this);
        if (setgraph) {
            this.setGraph(n1, n2);
        }
        this.feyn.init(inputFile, new JaxoGraph(this.initList));
        this.feyn.setTitle(title);
        this.feyn.pack();
        if (!JaxoPrefs.getBooleanPref((int)304)) {
            this.feyn.gridOn(false);
        }
        JHPlot.readInfo();
    }

    public void setAxesFrame(int n1, int n2) {
        this.initList.clear();
        this.setGraph(n1, n2);
        if (!JaxoPrefs.getBooleanPref((int)304)) {
            this.feyn.gridOn(false);
        }
    }

    public void buildPads(int n1, int n2) {
        this.clearAllData();
        this.clearAll();
        this.setAxesFrame(n1, n2);
        this.update();
    }

    public HPlotJa(String title, int xsize, int ysize, int n1, int n2) {
        this(title, xsize, ysize, n1, n2, true);
    }

    public void cd(int cols, int rows) {
        this.N1 = cols - 1;
        this.N2 = rows - 1;
        if (cols > this.N1final || rows > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
    }

    public int getCdX() {
        return this.N1;
    }

    public int getNtotX() {
        return this.N1final;
    }

    public int getNtotY() {
        return this.N2final;
    }

    public int getCdY() {
        return this.N2;
    }

    public HPlotJa(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HPlotJa() {
        this("HPlotJa", 600, 400, 1, 1, true);
    }

    public HPlotJa(String title) {
        this(title, 600, 400, 1, 1);
    }

    private void setGraph(int N1f, int N2f) {
        this.N1final = N1f;
        this.N2final = N2f;
        this.isSet = true;
        this.ja = new JaAxes[this.N1final][this.N2final];
        this.labelX = new JaText[this.N1final][this.N2final];
        this.labelY = new JaText[this.N1final][this.N2final];
        this.statbox = new JaTextBox[this.N1final][this.N2final];
        this.showStatBox = new boolean[this.N1final][this.N2final];
        lastKeyLocation = new double[this.N1final][this.N2final];
        String[] stats = new String[]{"UNDEFINED"};
        double x1 = this.MarginLeft + this.MarginRight;
        double y1 = this.MarginTop + this.MarginBottom;
        double cwidth = (1.0 - x1 - this.MarginX * (double)(this.N1final - 1)) / (double)this.N1final;
        double chight = (1.0 - y1 - this.MarginY * (double)(this.N2final - 1)) / (double)this.N2final;
        if (this.N1final == 1) {
            cwidth = 1.0 - x1;
        }
        if (this.N2final == 1) {
            chight = 1.0 - y1;
        }
        double y = this.MarginTop;
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            double x = this.MarginLeft;
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.ja[i1][i2] = new JaAxes(i1, i2);
                this.ja[i1][i2].setLocation(x, y, "NDC");
                this.ja[i1][i2].setRelWH(cwidth, chight, "NDC");
                this.ja[i1][i2].setColor(Color.black);
                this.ja[i1][i2].setFillColor(Color.white);
                this.ja[i1][i2].setStroke(2.0f);
                HPlotJa.lastKeyLocation[i1][i2] = 0.0;
                this.labelX[i1][i2] = new JaText();
                this.labelX[i1][i2].setPadX(i1);
                this.labelX[i1][i2].setPadY(i2);
                this.labelX[i1][i2].setType(1);
                this.labelX[i1][i2].setFont(this.fontLabel);
                this.labelX[i1][i2].setColor(Color.black);
                this.setLabelX("X", i1, i2);
                this.showStatBox[i1][i2] = true;
                this.statbox[i1][i2] = new JaTextBox();
                this.statbox[i1][i2].setPadX(i1);
                this.statbox[i1][i2].setPadY(i2);
                this.statbox[i1][i2].setType(4);
                this.statbox[i1][i2].setFont(new Font("Dialog", 2, 10));
                this.statbox[i1][i2].setColor(Color.black);
                this.setStatBox(stats, i1, i2);
                this.labelY[i1][i2] = new JaText();
                this.labelY[i1][i2].setPadX(i1);
                this.labelY[i1][i2].setPadY(i2);
                this.labelY[i1][i2].setType(2);
                this.labelY[i1][i2].setFont(this.fontLabel);
                this.labelY[i1][i2].setColor(Color.black);
                this.setLabelY("Y", i1, i2);
                this.initList.add((JaObject)this.ja[i1][i2]);
                this.initList.add((JaObject)this.labelX[i1][i2]);
                this.initList.add((JaObject)this.labelY[i1][i2]);
                this.initList.add((JaObject)this.statbox[i1][i2]);
                x += cwidth + this.MarginX;
            }
            y += chight + this.MarginY;
        }
    }

    public JaAxes getJaAxes() {
        return this.ja[this.N1][this.N2];
    }

    public void setContour(boolean contour) {
        this.ja[this.N1][this.N2].setContour(contour);
    }

    public void setContourBar(boolean bar) {
        this.ja[this.N1][this.N2].setContourBar(bar);
    }

    public void setContourLevels(int levels) {
        this.ja[this.N1][this.N2].setContourLevels(levels);
    }

    public int getContourLevels() {
        return this.ja[this.N1][this.N2].getContourLevels();
    }

    public boolean isContourBar() {
        return this.ja[this.N1][this.N2].isContourBar();
    }

    public void setContourBins(int nX, int nY) {
        this.ja[this.N1][this.N2].setContourBins(nX, nY);
    }

    public boolean isContour() {
        return this.ja[this.N1][this.N2].isContour();
    }

    public int getContourBinsX() {
        return this.ja[this.N1][this.N2].getContourBinX();
    }

    public int getContourBinsY() {
        return this.ja[this.N1][this.N2].getContourBinY();
    }

    private void findLocation(JaObject ob) {
        if (ob == null) {
            return;
        }
        if (ob.isUser()) {
            double x = ob.getXuser();
            double y = ob.getYuser();
            double w = ob.getRelWuser();
            double h = ob.getRelHuser();
            int x1 = this.ja[this.N1][this.N2].toX(x);
            int y1 = this.ja[this.N1][this.N2].toY(y);
            int x2 = this.ja[this.N1][this.N2].toX(w);
            int y2 = this.ja[this.N1][this.N2].toY(h);
            if (ob instanceof JaLine) {
                ((JaLine)ob).setLocationXY(x1, y1, x2, y2);
            } else if (ob instanceof JaBox) {
                ((JaBox)ob).setLocationXY(x1, y1, x2, y2);
            } else {
                ob.setX(x1);
                ob.setY(y1);
                ob.setRelw(x2);
                ob.setRelh(y2);
            }
        } else {
            ob.updateCoor();
        }
    }

    public void add(JaObject ob) {
        if (ob == null) {
            return;
        }
        this.findLocation(ob);
        this.feyn.getGraph().addObject(ob);
        this.feyn.getGraph().setSaved(true);
    }

    public void addToBack(JaObject ob) {
        if (ob == null) {
            return;
        }
        this.findLocation(ob);
        this.feyn.getGraph().background(ob);
        this.feyn.getGraph().setSaved(true);
    }

    public void addToFront(JaObject ob) {
        if (ob == null) {
            return;
        }
        this.findLocation(ob);
        this.feyn.getGraph().foreground(ob);
        this.feyn.getGraph().setSaved(true);
    }

    public void clearAll() {
        this.feyn.getGraph().clearAll();
    }

    public void clearAllData() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clearData(i1 + 1, i2 + 1);
            }
        }
    }

    public void clearData(int padx, int pady) {
        JaObject jaxoOb;
        int i;
        if (!this.isSet) {
            return;
        }
        int n1 = padx - 1;
        int n2 = pady - 1;
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        this.ja[n1][n2].clear();
        HPlotJa.lastKeyLocation[n1][n2] = 0.0;
        if (this.feyn == null) {
            return;
        }
        JaxoGraph jg = this.feyn.getGraph();
        if (jg == null) {
            return;
        }
        Vector<JaObject> ListForRemove = new Vector<JaObject>();
        for (i = 0; i < jg.listSize(); ++i) {
            JaTextBox text;
            JaKey jk;
            jaxoOb = jg.listElementAt(i);
            if (jaxoOb instanceof JaKey && (jk = (JaKey)jaxoOb).getPadX() == n1 && jk.getPadY() == n2) {
                ListForRemove.addElement(jaxoOb);
            }
            if (jaxoOb instanceof JaTextBox && (text = (JaTextBox)jaxoOb).getType() == 4 && text.getPadX() == n1 && text.getPadY() == n2) {
                ListForRemove.addElement(jaxoOb);
            }
            if (jaxoOb instanceof JaText && ((text = (JaText)jaxoOb).getType() == 1 || text.getType() == 2) && text.getPadX() == n1 && text.getPadY() == n2) {
                ListForRemove.addElement(jaxoOb);
            }
            if (!(jaxoOb instanceof JaText) || (text = (JaText)jaxoOb).getType() != 5 || text.getPadX() != n1 || text.getPadY() != n2) continue;
            ListForRemove.addElement(jaxoOb);
        }
        for (i = 0; i < ListForRemove.size(); ++i) {
            jaxoOb = (JaObject)ListForRemove.elementAt(i);
            jg.delete(jaxoOb);
        }
        ListForRemove.clear();
        ListForRemove = null;
        if (this.ja[n1][n2].isContour()) {
            this.ja[n1][n2].setContour(false);
        }
        this.setRangeX(0.0, 1.0, padx, pady);
        this.setRangeY(0.0, 1.0, padx, pady);
    }

    public void setPad(double xpos, double ypos, double width, double height) {
        this.ja[this.N1][this.N2].setLocation(xpos, ypos, "NDC");
        this.ja[this.N1][this.N2].setRelWH(width, height, "NDC");
        this.setLabelX(this.labelX[this.N1][this.N2].getText(), this.N1, this.N1);
        this.setLabelY(this.labelY[this.N1][this.N2].getText(), this.N2, this.N2);
        this.MarginLeft = xpos;
        this.MarginRight = 1.0 - width - xpos;
        this.MarginTop = ypos;
        this.MarginBottom = 1.0 - height - ypos;
        this.update();
    }

    public double getPadPositionX() {
        return this.ja[this.N1][this.N2].getXndc();
    }

    public double getPadPositionY() {
        return this.ja[this.N1][this.N2].getYndc();
    }

    public double getPadWidth() {
        return this.ja[this.N1][this.N2].getRelWndc();
    }

    public double getPadHeight() {
        return this.ja[this.N1][this.N2].getRelHndc();
    }

    public void setPad(int padx, int pady, double xpos, double ypos, double width, double height) {
        int i1 = padx - 1;
        int i2 = pady - 1;
        this.ja[i1][i2].setLocation(xpos, ypos, "NDC");
        this.ja[i1][i2].setRelWH(width, height, "NDC");
        this.setLabelX(this.labelX[i1][i2].getText(), i1, i2);
        this.setLabelY(this.labelY[i1][i2].getText(), i1, i2);
        this.MarginLeft = xpos;
        this.MarginRight = 1.0 - width - xpos;
        this.MarginTop = ypos;
        this.MarginBottom = 1.0 - height - ypos;
        this.update();
    }

    public void setPad(int padx, int pady, double xpos, double ypos) {
        int i1 = padx - 1;
        int i2 = pady - 1;
        this.ja[i1][i2].setLocation(xpos, ypos, "NDC");
        this.setLabelX(this.labelX[i1][i2].getText(), i1, i2);
        this.setLabelY(this.labelY[i1][i2].getText(), i1, i2);
        double width = this.ja[i1][i2].getRelw();
        double height = this.ja[i1][i2].getRelh();
        this.MarginLeft = xpos;
        this.MarginRight = 1.0 - width - xpos;
        this.MarginTop = ypos;
        this.MarginBottom = 1.0 - height - ypos;
        this.update();
    }

    public void removeObject(int type, int padx, int pady) {
        JaObject jaxoOb;
        int i;
        int n1 = padx - 1;
        int n2 = pady - 1;
        JaxoGraph jg = this.feyn.getGraph();
        Vector<JaObject> ListForRemove = new Vector<JaObject>();
        for (i = 0; i < jg.listSize(); ++i) {
            JaTextBox text;
            JaKey jk;
            jaxoOb = jg.listElementAt(i);
            if (jaxoOb instanceof JaKey && (jk = (JaKey)jaxoOb).getPadX() == n1 && jk.getPadY() == n2 && jk.getType() == type) {
                ListForRemove.addElement(jaxoOb);
            }
            if (jaxoOb instanceof JaTextBox && (text = (JaTextBox)jaxoOb).getType() == 4 && text.getPadX() == n1 && text.getPadY() == n2) {
                ListForRemove.addElement(jaxoOb);
            }
            if (jaxoOb instanceof JaText && ((text = (JaText)jaxoOb).getType() == 1 || text.getType() == 2) && text.getPadX() == n1 && text.getPadY() == n2) {
                ListForRemove.addElement(jaxoOb);
            }
            if (!(jaxoOb instanceof JaText) || (text = (JaText)jaxoOb).getType() != 5 || text.getPadX() != n1 || text.getPadY() != n2) continue;
            ListForRemove.addElement(jaxoOb);
        }
        for (i = 0; i < ListForRemove.size(); ++i) {
            jaxoOb = (JaObject)ListForRemove.elementAt(i);
            jg.delete(jaxoOb);
        }
        ListForRemove.clear();
        ListForRemove = null;
    }

    public ArrayList getArrayList() {
        JaxoGraph jg = this.feyn.getGraph();
        return jg.getObjectList();
    }

    public void clearData() {
        this.clearData(this.N1 + 1, this.N2 + 1);
    }

    public void update() {
        this.showExponentX();
        this.showExponentY();
        this.feyn.update();
        this.feyn.getGraph().setSaved(true);
    }

    public void close() {
        isOpen = 0;
        this.feyn.shutdown();
        this.ja = null;
        this.labelX = null;
        this.labelY = null;
        this.statbox = null;
    }

    protected int isOpen() {
        return isOpen;
    }

    public void setLocationAtCenter(JaText text) {
        FontMetrics fm = this.getFontMetrics(text.getFont());
        String stext = Translate.shrink(text.getText());
        int width = fm.stringWidth(stext);
        int height = fm.getHeight();
        double gx = Global.toX((int)width);
        double gy = Global.toY((int)height);
        text.setLocation(0.5 - 0.5 * gx, 0.5 * this.MarginTop + 0.4 * gy, "NDC");
    }

    public void setAxisAll(boolean show) {
        this.ja[this.N1][this.N2].setShow(0, show);
        this.ja[this.N1][this.N2].setShowMirror(0, show);
        this.ja[this.N1][this.N2].setShow(1, show);
        this.ja[this.N1][this.N2].setShowMirror(1, show);
    }

    public void removeAxes() {
        this.setAxisAll(false);
        this.removeObject(6, this.N1 + 1, this.N2 + 1);
        this.removeObject(1, this.N1 + 1, this.N2 + 1);
        this.removeObject(2, this.N1 + 1, this.N2 + 1);
        this.removeObject(1, this.N1 + 1, this.N2 + 1);
        this.removeObject(4, this.N1 + 1, this.N2 + 1);
        this.removeObject(5, this.N1 + 1, this.N2 + 1);
        this.ja[this.N1][this.N2].setTicksLabels(0, false);
        this.ja[this.N1][this.N2].setTicksLabels(1, false);
    }

    public void setTicksLabels(int axis, boolean set) {
        if (axis == 0) {
            this.ja[this.N1][this.N2].setTicksLabels(0, set);
        }
        if (axis == 1) {
            this.ja[this.N1][this.N2].setTicksLabels(1, set);
        }
    }

    public void setShowMirror(int axis, boolean set) {
        this.ja[this.N1][this.N2].setShowMirror(axis, set);
    }

    public void showAxis(int axis) {
        this.ja[this.N1][this.N2].setShow(axis, true);
        this.ja[this.N1][this.N2].setTicksLabels(axis, true);
    }

    public void setGridAll(int axis, boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.ja[i1][i2].setShowGrid(axis, b);
            }
        }
    }

    public void setLabelX(String label, int n1, int n2) {
        this.labelX[n1][n2].setText(label);
        FontMetrics fm = this.getFontMetrics(this.fontLabel);
        String stext = Translate.shrink(label);
        int width = fm.stringWidth(stext);
        int height = fm.getHeight();
        double gx = Global.toX((int)width);
        double gy = Global.toY((int)height);
        double labelYshift = 0.05;
        double x = this.ja[n1][n2].getXndc();
        double y = this.ja[n1][n2].getYndc();
        double cwidth = this.ja[n1][n2].getRelWndc();
        double chight = this.ja[n1][n2].getRelHndc();
        double dy = this.ja[n1][n2].getLabelSpace(1);
        this.labelX[n1][n2].setLocation(x + cwidth - gx, y + chight + dy + 0.5 * gy + labelYshift, "NDC");
    }

    public void setLabel(int axis, double x, double y, String text, Font f, Color c, String howToSet) {
        if (axis == 0) {
            this.labelX[this.N1][this.N2].setText(text);
            this.labelX[this.N1][this.N2].setLocation(x, y, howToSet);
            this.labelX[this.N1][this.N2].setColor(c);
            this.labelX[this.N1][this.N2].setFont(f);
        }
        if (axis == 1) {
            this.labelY[this.N1][this.N2].setText(text);
            this.labelY[this.N1][this.N2].setLocation(x, y, howToSet);
            this.labelY[this.N1][this.N2].setColor(c);
            this.labelY[this.N1][this.N2].setFont(f);
        }
    }

    public void setLabel(int axis, double x, double y, String text, Font f, Color c) {
        this.setLabel(axis, x, y, text, f, c, "NDC");
    }

    public void setLabel(int axis, double x, double y, String text, Font f) {
        this.setLabel(axis, x, y, text, f, Color.black, "NDC");
    }

    public void setLabel(int axis, double x, double y, String text) {
        this.setLabel(axis, x, y, text, this.fontLabel, Color.black, "NDC");
    }

    public JaText getLabel(int axis) {
        if (axis == 0) {
            return this.labelX[this.N1][this.N2];
        }
        if (axis == 1) {
            return this.labelY[this.N1][this.N2];
        }
        return null;
    }

    public void setLabelShift(int axis, double shiftX, double shiftY) {
        if (axis == 0) {
            double x = this.labelX[this.N1][this.N2].getXndc();
            double y = this.labelX[this.N1][this.N2].getYndc();
            double new_x = x + shiftX;
            double new_y = y - shiftY;
            if (new_y < 0.0 || new_y > 1.0) {
                this.ErrorMessage("The shift in Y is too much! (outside 0-1 range in NDC)");
                return;
            }
            if (new_x < 0.0 || new_x > 1.0) {
                this.ErrorMessage("This shiftin X is too much! (outside 0-1 range in NDC)");
                return;
            }
            this.labelX[this.N1][this.N2].setLocation(new_x, new_y, "NDC");
        } else if (axis == 1) {
            double x = this.labelY[this.N1][this.N2].getXndc();
            double y = this.labelY[this.N1][this.N2].getYndc();
            double new_x = x - shiftX;
            double new_y = y + shiftY;
            if (new_y < 0.0 || new_y > 1.0) {
                this.ErrorMessage("The shift in Y is too much! (outside 0-1 range in NDC)");
                return;
            }
            if (new_x < 0.0 || new_x > 1.0) {
                this.ErrorMessage("This shiftin X is too much! (outside 0-1 range in NDC)");
                return;
            }
            this.labelY[this.N1][this.N2].setLocation(new_x, new_y, "NDC");
        } else {
            this.ErrorMessage("Wrong axis! Should be 0 (X) or 1 (Y)");
            return;
        }
    }

    public void setStatBox(String[] label, int n1, int n2) {
        this.statbox[n1][n2].setMultiText(label);
        double x = this.ja[n1][n2].getXndc();
        double y = this.ja[n1][n2].getYndc();
        double cwidth = this.ja[n1][n2].getRelWndc();
        double chight = this.ja[n1][n2].getRelHndc();
        float a = this.ja[n1][n2].getStroke();
        double gy = Global.toY((int)((int)a + 1));
        double gx = Global.toX((int)((int)a + 1));
        double xw = this.statbox[n1][n2].getRelWndc();
        double xh = this.statbox[n1][n2].getRelHndc();
        this.statbox[n1][n2].setRotAngle(0);
        this.statbox[n1][n2].setLocation(x + cwidth - xw - gx, y + gy - 0.5 * xh, "NDC");
    }

    public void setLabelY(String label, int n1, int n2) {
        this.labelY[n1][n2].setText(label);
        FontMetrics fm = this.getFontMetrics(this.fontLabel);
        String stext = Translate.shrink(label);
        int width = fm.stringWidth(stext);
        int height = fm.getHeight();
        double gx = Global.toX((int)width);
        double gy = Global.toY((int)height);
        double x = this.ja[n1][n2].getXndc();
        double y = this.ja[n1][n2].getYndc();
        double dx = this.ja[n1][n2].getLabelSpace(0);
        this.labelY[n1][n2].setRotAngle(-90);
        double xpos = x - dx - gy;
        this.labelY[n1][n2].setLocation(xpos, y + gx, "NDC");
    }

    public static void getPreferences() {
        File prefFile = new File(PREFS_FILENAME);
        if (prefFile.exists()) {
            JaxoPrefs.importPrefs((String)PREFS_FILENAME);
        }
    }

    public int getSizeX() {
        return this.feyn.getSizeX();
    }

    public int getSizeY() {
        return this.feyn.getSizeY();
    }

    private static String getCommandLineArgs(String[] args) {
        inputFile = "";
        int nofJax = 0;
        if (args.length > 0) {
            if (args[0].startsWith("--")) {
                if (args[0].equals("--version")) {
                    System.out.println(VERSION);
                } else if (args[0].equals("--info")) {
                    HPlotJa.info();
                } else if (args[0].equals("--help")) {
                    HPlotJa.help();
                } else {
                    System.out.println(language.getString("Unknown_option:") + args[0]);
                }
                System.exit(0);
            } else {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].endsWith(".xml")) {
                        System.out.println(language.getString("Reading_file") + args[i]);
                        inputFile = args[i];
                        if (nofJax > 0) {
                            System.out.println(language.getString("Warning:_You_can_only_read_one_input_file!"));
                        }
                        ++nofJax;
                        continue;
                    }
                    if (args[i].equals("-verbose")) {
                        JaxoPrefs.setVerbose((boolean)true);
                        continue;
                    }
                    if (args[i].equals("-quiet")) {
                        JaxoPrefs.setVerbose((boolean)false);
                        continue;
                    }
                    System.out.println(language.getString("Unknown_option:") + args[i]);
                }
            }
        }
        return inputFile;
    }

    public static String getCurDir() {
        return curDIR;
    }

    public static void setCurDir(String newDir) {
        curDIR = newDir;
    }

    private static void getUserDir() {
        try {
            curDIR = System.getProperty("user.dir");
        }
        catch (SecurityException aSecurityException) {
            JOptionPane.showMessageDialog(null, language.getString("SecurityException:_Cannot_get_system_properties!"));
            System.err.println(aSecurityException);
        }
    }

    private static void help() {
        System.out.println(language.getString("Start_the_program_with:") + language.getString("jaxodraw_[options]") + language.getString("and_check_the_User_Guide_in_the_Help_menu.") + language.getString("Command_line_options:") + language.getString("--version__prints_out_the_version_number_of_JaxoDraw") + language.getString("--help_____prints_out_this_help") + language.getString("--info_____prints_out_some_information_about_your_system") + language.getString("_-verbose__turns_on_verbose_error_messaging_(default_in_the_current_version)") + language.getString("_-quiet____turns_off_verbose_error_messaging"));
    }

    private static void info() {
        System.out.println(language.getString("OS_name:") + OS_NAME + "\n" + language.getString("OS_architecture:") + OS_ARCH + "\n" + language.getString("OS_version:") + OS_VERSION + "\n" + language.getString("Java_version:") + JAVA_VERSION + "\n" + language.getString("Java_runtime_version:") + JAVA_RUNTIME_VERSION + "\n" + language.getString("Java_home_directory:") + JAVA_HOME + "\n" + language.getString("Java_class_path:") + JAVA_CLASSPATH);
    }

    public void setRangeX(double min, double max) {
        this.setRangeX(min, max, this.N1 + 1, this.N2 + 1);
    }

    public void setRangeY(double min, double max) {
        this.setRangeY(min, max, this.N1 + 1, this.N2 + 1);
    }

    public void setRange(double minX, double maxX, double minY, double maxY) {
        this.setRangeX(minX, maxX, this.N1 + 1, this.N2 + 1);
        this.setRangeY(minY, maxY, this.N1 + 1, this.N2 + 1);
    }

    public void setRangeX(double min, double max, int padx, int pady) {
        int n1 = padx - 1;
        int n2 = pady - 1;
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        this.ja[n1][n2].setRange(0, min, max);
    }

    private void showExponentY() {
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                if (this.ja[i1][i2].isLogScale(1)) {
                    return;
                }
                String exp = this.ja[i1][i2].axisExponent(1);
                if (exp.equals("0")) {
                    return;
                }
                JaText expJ = new JaText();
                expJ.setText("x10^{" + exp + "}");
                expJ.setFont(this.ja[i1][i2].getLabelFont());
                expJ.setColor(this.ja[i2][i2].getLabelColor());
                expJ.setType(5);
                expJ.setPadX(i1);
                expJ.setPadY(i2);
                double x = this.ja[i1][i2].getXndc();
                double y = this.ja[i1][i2].getYndc();
                FontMetrics fm = this.getFontMetrics(this.ja[i1][i2].getLabelFont());
                double cc = 0.4 * (double)Global.toY((int)fm.getHeight());
                expJ.setLocation(x, y - cc, "NDC");
                this.add((JaObject)expJ);
            }
        }
    }

    private void showExponentX() {
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                if (this.ja[i1][i2].isLogScale(0)) {
                    return;
                }
                String exp = this.ja[i1][i2].axisExponent(0);
                if (exp.equals("0")) {
                    return;
                }
                JaText expJ = new JaText();
                expJ.setText("x10^{" + exp + "}");
                expJ.setFont(this.ja[i1][i2].getLabelFont());
                expJ.setColor(this.ja[i1][i2].getLabelColor());
                expJ.setType(5);
                expJ.setPadX(i1);
                expJ.setPadY(i2);
                FontMetrics fm = this.getFontMetrics(this.ja[i1][i2].getLabelFont());
                double cc = Global.toX((int)fm.stringWidth("0"));
                double x = this.ja[i1][i2].getXndc();
                double y = this.ja[i1][i2].getYndc();
                double cwidth = this.ja[i1][i2].getRelWndc();
                double chight = this.ja[i1][i2].getRelHndc();
                expJ.setLocation(x + cwidth + cc, y + chight, "NDC");
                this.add((JaObject)expJ);
            }
        }
    }

    public void setRangeY(double min, double max, int padx, int pady) {
        int n1 = padx - 1;
        int n2 = pady - 1;
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        this.ja[n1][n2].setRange(1, min, max);
    }

    public void setLogScale(int axis, boolean b) {
        this.ja[this.N1][this.N2].setLogScale(axis, b);
    }

    public void setTicFont(Font font) {
        this.ja[this.N1][this.N2].setLabelFont(font);
    }

    public void showEditor() {
        this.feyn.showEditorbar(true);
    }

    public void showEditor(boolean show) {
        this.feyn.showEditorbar(show);
    }

    public void export(String file) {
        this.feyn.export(file);
    }

    public void convertSVG(String source, String target) {
        ConvertSVG.SVGTo(source, target);
    }

    public void convertSVG(String source, String target, boolean isRemove) {
        ConvertSVG.SVGTo(source, target, isRemove);
    }

    public JaAxes getPad() {
        return this.ja[this.N1][this.N2];
    }

    public double getKeyTextSpace() {
        return this.keyspace;
    }

    public void setKeyTextSpace(double space) {
        this.keyspace = space;
    }

    public JaAxes getPad(int n1, int n2) {
        return this.ja[n1 - 1][n2 - 1];
    }

    public void setMarginBottom(double marginBottom) {
        double x = this.ja[this.N1][this.N2].getXndc();
        double y = this.ja[this.N1][this.N2].getYndc();
        double cwidth = this.ja[this.N1][this.N2].getRelWndc();
        double cheight = this.ja[this.N1][this.N2].getRelHndc();
        if (1.0 - marginBottom < 0.0 || 1.0 - marginBottom > 1.0) {
            this.ErrorMessage("setMarginBottom: Position is not in NDC (values must be 0-1)");
            return;
        }
        this.ja[this.N1][this.N2].setLocation(x, 1.0 - cheight - marginBottom, "NDC");
        this.ja[this.N1][this.N2].setRelWH(cwidth, cheight, "NDC");
        this.MarginBottom = marginBottom;
    }

    public double getMarginBottom() {
        return this.MarginBottom;
    }

    public void setMarginLeft(double marginLeft) {
        double x = this.ja[this.N1][this.N2].getXndc();
        double y = this.ja[this.N1][this.N2].getYndc();
        double cwidth = this.ja[this.N1][this.N2].getRelWndc();
        double cheight = this.ja[this.N1][this.N2].getRelHndc();
        if (marginLeft < 0.0 || marginLeft > 1.0) {
            this.ErrorMessage("setMarginLeft: Position is not in NDC (values must be 0-1)");
            return;
        }
        this.ja[this.N1][this.N2].setLocation(marginLeft, y, "NDC");
        this.ja[this.N1][this.N2].setRelWH(cwidth, cheight, "NDC");
        this.MarginLeft = marginLeft;
    }

    public double getMarginLeft() {
        return this.MarginLeft;
    }

    public void setMarginRight(double marginRight) {
        double x = this.ja[this.N1][this.N2].getXndc();
        double y = this.ja[this.N1][this.N2].getYndc();
        double cwidth = this.ja[this.N1][this.N2].getRelWndc();
        double cheight = this.ja[this.N1][this.N2].getRelHndc();
        if (1.0 - marginRight < 0.0) {
            this.ErrorMessage("setMarginRight: Position is not in NDC");
            return;
        }
        this.ja[this.N1][this.N2].setLocation(1.0 - cwidth - marginRight, y, "NDC");
        this.ja[this.N1][this.N2].setRelWH(cwidth, cheight, "NDC");
        this.MarginRight = marginRight;
    }

    public double getMarginRight() {
        return this.MarginRight;
    }

    public void setAntiAlias(boolean setit) {
        this.feyn.antialiasOn(setit);
    }

    public void setLegendFont(Font font) {
        for (int i = 0; i < this.feyn.getGraph().listSize(); ++i) {
            JaObject jaxoOb = this.feyn.getGraph().listElementAt(i);
            if (!(jaxoOb instanceof JaKey)) continue;
            ((JaKey)jaxoOb).setFont(font);
        }
    }

    public ArrayList<JaKey> getLegends() {
        ArrayList<JaKey> s = new ArrayList<JaKey>();
        for (int i = 0; i < this.feyn.getGraph().listSize(); ++i) {
            JaObject jaxoOb = this.feyn.getGraph().listElementAt(i);
            if (!(jaxoOb instanceof JaKey)) continue;
            s.add((JaKey)jaxoOb);
        }
        return s;
    }

    public void setLegends(ArrayList<JaKey> legends) {
        int i;
        for (i = 0; i < this.feyn.getGraph().listSize(); ++i) {
            JaObject jaxoOb = this.feyn.getGraph().listElementAt(i);
            if (!(jaxoOb instanceof JaKey)) continue;
            this.feyn.getGraph().delete(jaxoOb);
        }
        for (i = 0; i < legends.size(); ++i) {
            this.feyn.getGraph().addObject((JaObject)legends.get(i));
        }
    }

    public void setLegendAll(boolean isSet) {
        if (!isSet) {
            for (int i = 0; i < this.feyn.getGraph().listSize(); ++i) {
                JaObject jaxoOb = this.feyn.getGraph().listElementAt(i);
                if (!(jaxoOb instanceof JaKey)) continue;
                this.feyn.getGraph().delete(jaxoOb);
            }
        }
    }

    public void setLegendFont(String name) {
        this.setLegendFont(Font.decode(name));
    }

    public void setPadLocation(double x, double y) {
        if (x < 0.0 || x > 1.0) {
            this.ErrorMessage("setPadLocation: Position is not in NDC (0-1)");
            return;
        }
        if (y < 0.0 || y > 1.0) {
            this.ErrorMessage("setPadLocation: Position is not in NDC (0-1)");
            return;
        }
        this.ja[this.N1][this.N2].setLocation(x, y, "NDC");
    }

    public void setPadSize(double width, double height) {
        if (width < 0.0 || width > 1.0) {
            this.ErrorMessage("setPadSize: Position is not in NDC");
            return;
        }
        if (height < 0.0 || height > 1.0) {
            this.ErrorMessage("setPadSize: Position is not in NDC");
            return;
        }
        this.ja[this.N1][this.N2].setRelWH(width, height, "NDC");
    }

    public void setMarginTop(double marginTop) {
        double x = this.ja[this.N1][this.N2].getXndc();
        double y = this.ja[this.N1][this.N2].getYndc();
        double cwidth = this.ja[this.N1][this.N2].getRelWndc();
        double cheight = this.ja[this.N1][this.N2].getRelHndc();
        if (this.MarginTop < 0.0 || this.MarginTop > 1.0) {
            this.ErrorMessage("setMarginTop: Position is not in NDC");
            return;
        }
        this.ja[this.N1][this.N2].setLocation(x, this.MarginTop, "NDC");
        this.ja[this.N1][this.N2].setRelWH(cwidth, cheight, "NDC");
        this.MarginTop = marginTop;
    }

    public double getMarginTop() {
        return this.MarginTop;
    }

    public void setMarginX(double marginX) {
        this.MarginX = marginX;
    }

    public double getMarginX() {
        return this.MarginX;
    }

    public void setMarginY(double marginY) {
        this.MarginY = marginY;
    }

    public double getMarginY() {
        return this.MarginY;
    }

    public JaText[][] getLabelsAll(int axis) {
        if (axis == 0) {
            return this.labelX;
        }
        if (axis == 1) {
            return this.labelY;
        }
        return null;
    }

    public void draw(H1D h1, int padx, int pady) {
        this.setContour(false);
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        if (h1.getLabelX() != null && h1.getLabelX().length() > 0) {
            this.setNameX(h1.getLabelX());
        }
        if (h1.getLabelY() != null && h1.getLabelY().length() > 0) {
            this.setNameY(h1.getLabelY());
        }
        h1.setType(101);
        Histogram1D h = h1.get();
        IAxis ax = h.axis();
        int Bin = ax.bins();
        DataArray data1 = new DataArray(0, 1, Bin, h1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            double dd = ax.binCenter(i);
            double hh = h1.binHeight(i);
            double errX1 = dd - ax.binLowerEdge(i);
            double errX2 = ax.binUpperEdge(i) - dd;
            double errY = h.binError(i);
            data1.addPoint(dd, hh, errX1, errX2, errY, errY);
        }
        data1.setDimension(6);
        data1.setLinePars(h1.getDrawOption());
        data1.setName(h1.getTitle());
        data1.setType(101);
        this.ja[padx - 1][pady - 1].addData(data1, 101);
        this.addKey(data1, padx, pady);
        this.ja[padx - 1][pady - 1].setStatistics(this.getStatistics(h1));
        this.addStatBox(padx, pady);
    }

    public void showKey(boolean show) {
        this.ja[this.N1][this.N2].setShowKey(show);
    }

    public void addKey(DataArray data, int padx, int pady) {
        int n1 = padx - 1;
        int n2 = pady - 1;
        if (!this.ja[n1][n2].isShowKey()) {
            return;
        }
        double x = this.ja[n1][n2].getXndc();
        double y = this.ja[n1][n2].getYndc();
        double cwidth = this.ja[n1][n2].getRelWndc();
        double chight = this.ja[n1][n2].getRelHndc();
        JaKey newText = new JaKey();
        newText.setText(data.getName());
        newText.setPadX(n1);
        newText.setPadY(n2);
        newText.setType(6);
        Font fon = new Font("Dialog", 1, 16);
        if (this.N1final > 1) {
            fon = new Font("Dialog", 1, 12);
        }
        if (this.N1final > 2) {
            fon = new Font("Dialog", 1, 10);
        }
        if (this.N1final > 3) {
            fon = new Font("Dialog", 1, 9);
        }
        newText.setFont(fon);
        FontMetrics fm = this.getFontMetrics(newText.getFont());
        int height = fm.getHeight();
        double gy = Global.toY((int)height);
        HPlotJa.lastKeyLocation[n1][n2] = lastKeyLocation[n1][n2] == 0.0 ? 0.1 * chight : lastKeyLocation[n1][n2] + gy + this.keyspace;
        double ypos = y + lastKeyLocation[n1][n2];
        newText.setLocation(x + 0.1 * cwidth, ypos, "NDC");
        newText.setRotAngle(0);
        newText.setColor(Color.black);
        newText.setKeyColor(data.getColor());
        if (data.fill()) {
            newText.setKeyColor(data.getFillColor());
        }
        newText.setKey(HPlotJa.getSymbol(data));
        newText.setPenWidth(data.getPenWidth());
        this.add((JaObject)newText);
    }

    public void setShowStatBox(boolean showStatBox) {
        this.showStatBox[this.N1][this.N2] = showStatBox;
    }

    public boolean isShowStatBox() {
        return this.showStatBox[this.N1][this.N2];
    }

    public void addStatBox(int padx, int pady) {
        if (!this.showStatBox[padx - 1][pady - 1]) {
            return;
        }
        int n1 = padx - 1;
        int n2 = pady - 1;
        String[] stat = this.ja[n1][n2].getStatistics();
        this.setStatBox(stat, n1, n2);
        this.showStatBox[n1][n2] = false;
    }

    public static int getSymbol(DataArray d) {
        int symbol = d.getSymbol();
        if (d.drawLine()) {
            symbol = 20;
        }
        if (d.getGraphStyle() == 1 && !d.fill()) {
            symbol = 21;
        }
        if (d.getGraphStyle() == 1 && d.fill()) {
            symbol = 22;
        }
        return symbol;
    }

    public void draw(H2D h2, int padx, int pady) {
        this.setContour(true);
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        this.setContour(true);
        this.ja[padx - 1][pady - 1].addData(h2, 201);
    }

    public void setGTitle(JaText gTitle) {
        this.gTitle = gTitle;
        this.gTitle.setType(3);
        this.setLocationAtCenter(this.gTitle);
        this.add((JaObject)this.gTitle);
    }

    public void setGTitle(String sname, Font f, Color c) {
        this.gTitle = new JaText();
        this.gTitle.setText(sname);
        this.gTitle.setFont(f);
        this.gTitle.setColor(c);
        this.gTitle.setType(3);
        this.setLocationAtCenter(this.gTitle);
        this.add((JaObject)this.gTitle);
    }

    public void setGTitle(String sname, Font f) {
        this.setGTitle(sname, f, Color.black);
    }

    public void setGTitle(String sname) {
        this.setGTitle(sname, new Font("Arial", 1, 18), Color.black);
    }

    public void setGTitle(String sname, Color color) {
        this.setGTitle(sname, new Font("Arial", 1, 18), color);
    }

    public JaText getGTitle() {
        return this.gTitle;
    }

    public void setNameX(String s, Font f, Color c) {
        this.labelX[this.N1][this.N2].setText(s);
        this.labelX[this.N1][this.N2].setFont(f);
        this.labelX[this.N1][this.N2].setColor(c);
        this.setLabelX(s, this.N1, this.N2);
        if (this.feyn == null) {
            return;
        }
        JaxoGraph jg = this.feyn.getGraph();
        if (jg == null) {
            return;
        }
        jg.delete((JaObject)this.labelX[this.N1][this.N2]);
        this.add((JaObject)this.labelX[this.N1][this.N2]);
    }

    public void setNameX(String s) {
        this.setNameX(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setNameX(String s, Font f) {
        this.setNameX(s, f, Color.black);
    }

    public void setNameY(String s, Font f, Color c) {
        this.labelY[this.N1][this.N2].setText(s);
        this.labelY[this.N1][this.N2].setFont(f);
        this.labelY[this.N1][this.N2].setColor(c);
        this.setLabelY(s, this.N1, this.N2);
        if (this.feyn == null) {
            return;
        }
        JaxoGraph jg = this.feyn.getGraph();
        if (jg == null) {
            return;
        }
        jg.delete((JaObject)this.labelY[this.N1][this.N2]);
        this.add((JaObject)this.labelY[this.N1][this.N2]);
    }

    public void setNameY(String s) {
        this.setNameY(s, new Font("Arial", 1, 16), Color.black);
    }

    public void setBoxFillColor(Color c) {
        this.ja[this.N1][this.N2].setBackgroundColor(c);
    }

    public Color getBoxFillColor() {
        return this.ja[this.N1][this.N2].getBackgroundColor();
    }

    public Color getBoxColor() {
        return this.ja[this.N1][this.N2].getFillColor();
    }

    public void setBoxColor(Color c) {
        this.ja[this.N1][this.N2].setFillColor(c);
    }

    public void setNameY(String s, Font f) {
        this.setNameY(s, f, Color.black);
    }

    public void draw(JaObject jo) {
        this.add(jo);
        this.feyn.getGraph().setSaved(true);
    }

    public void draw(P1D p1d) {
        this.draw(p1d, this.N1 + 1, this.N2 + 1);
    }

    public void draw(H2D h2d) {
        this.draw(h2d, this.N1 + 1, this.N2 + 1);
    }

    public String[] getStatistics(H1D h1) {
        double mean = h1.mean();
        double rms = h1.rms();
        String name = "<H1D>";
        String sentries = "Entries =" + Integer.toString(h1.entries());
        String smean = "Mean  =" + this.dfb.format(mean);
        String srms = "RMS =" + this.dfb.format(rms);
        String extra = "Under/Overflow =" + Integer.toString(h1.extraEntries());
        String[] s = new String[]{name, sentries, smean, srms, extra};
        return s;
    }

    public String[] getStatistics(P1D h1) {
        String name = "<P1D> ";
        String sentries = "Entries =" + Integer.toString(h1.size());
        String smeanX = "Mean X =" + this.dfb.format(h1.meanX());
        String smeanY = "Mean Y =" + this.dfb.format(h1.meanY());
        String minX = "MinX  =" + this.dfb.format(h1.getMin(0));
        String minY = "MinY  =" + this.dfb.format(h1.getMin(1));
        String maxX = "MaxX  =" + this.dfb.format(h1.getMax(0));
        String maxY = "MaxY  =" + this.dfb.format(h1.getMax(1));
        String[] s = new String[]{name, sentries, smeanX, smeanY, minX, minY, maxX, maxY};
        return s;
    }

    public void draw(H1D h1) {
        this.draw(h1, this.N1 + 1, this.N2 + 1);
    }

    public void draw(F1D[] f) {
        this.setContour(false);
        for (int i = 0; i < f.length; ++i) {
            this.draw(f[i]);
        }
    }

    public void draw(Cloud1D c1d) {
        this.draw(new H1D(c1d, 100));
    }

    public void draw(Cloud2D c2d) {
        this.draw(new P1D(c2d));
    }

    public void draw(Histogram1D h1d) {
        this.setContour(false);
        H1D h1 = new H1D(h1d);
        this.draw(h1);
    }

    public int fit(H1D h1, String predefFunc, String method) {
        if (this.m_IFunctionFactory == null || this.m_IAnalysisFactory == null) {
            this.m_IAnalysisFactory = IAnalysisFactory.create();
            this.m_ITree = this.m_IAnalysisFactory.createTreeFactory().create();
            this.m_IHistogramFactory = this.m_IAnalysisFactory.createHistogramFactory(this.m_ITree);
            this.m_IFitFactory = this.m_IAnalysisFactory.createFitFactory();
            this.m_IFunctionFactory = this.m_IAnalysisFactory.createFunctionFactory(this.m_ITree);
        }
        IFunction fitfunc = this.m_IFunctionFactory.createFunctionByName("Gaussian", "G");
        IFitter fitter = this.m_IFitFactory.createFitter("chi2", "jminuit");
        IFitResult result = fitter.fit((IBaseHistogram)h1.get(), fitfunc);
        IFunction fresult = result.fittedFunction();
        double[] fPars = result.fittedParameters();
        double[] fParErrs = result.errors();
        String[] fParNames = result.fittedParameterNames();
        for (int i = 0; i < fresult.numberOfParameters(); ++i) {
            System.out.println(fParNames[i] + " : " + fPars[i] + " +- " + fParErrs[i]);
        }
        return result.fitStatus();
    }

    public void factories() {
        this.m_IAnalysisFactory = IAnalysisFactory.create();
        this.m_ITree = this.m_IAnalysisFactory.createTreeFactory().create();
        this.m_IHistogramFactory = this.m_IAnalysisFactory.createHistogramFactory(this.m_ITree);
        this.m_IFitFactory = this.m_IAnalysisFactory.createFitFactory();
        this.m_IFunctionFactory = this.m_IAnalysisFactory.createFunctionFactory(this.m_ITree);
    }

    public IAnalysisFactory analF() {
        return this.m_IAnalysisFactory;
    }

    public ITree treeF() {
        return this.m_ITree;
    }

    public IFitFactory fitF() {
        return this.m_IFitFactory;
    }

    public IFunctionFactory funcF() {
        return this.m_IFunctionFactory;
    }

    public IHistogramFactory histF() {
        return this.m_IHistogramFactory;
    }

    public void draw(DataArray inputDA, String title) {
        this.ja[this.N1][this.N2].addData(inputDA, 0);
        this.addKey(inputDA, this.N1 + 1, this.N2 + 1);
    }

    public void draw(F1D f1, int padx, int pady) {
        this.setContour(false);
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        f1.setType(102);
        if (f1.getMin() == f1.getMax()) {
            double x1 = this.ja[this.N1][this.N2].getMin(0);
            double x2 = this.ja[this.N1][this.N2].getMax(0);
            f1.eval(x1, x2, f1.getPoints());
        } else {
            f1.eval(f1.getMin(), f1.getMax(), f1.getPoints());
        }
        int Bin = f1.getPoints();
        f1.setGraphStyle(0);
        f1.setDrawSymbol(false);
        f1.setDrawLine(true);
        DataArray data1 = new DataArray(0, 1, Bin, f1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            data1.addPoint(f1.getX(i), f1.getY(i));
        }
        data1.setDimension(2);
        data1.setType(102);
        data1.setName(f1.getTitle());
        this.ja[padx - 1][pady - 1].addData(data1, 102);
        this.addKey(data1, padx, pady);
    }

    public void draw(FND f1, int padx, int pady) {
        if (f1.getLabelX() != null && f1.getLabelX().length() > 0) {
            this.setNameX(f1.getLabelX());
        }
        if (f1.getLabelY() != null && f1.getLabelY().length() > 0) {
            this.setNameY(f1.getLabelY());
        }
        this.setContour(false);
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        if (!f1.isEvaluated()) {
            this.ErrorMessage("The function is not avaluated yet!");
            return;
        }
        f1.setType(102);
        int Bin = f1.getPoints();
        f1.setGraphStyle(0);
        f1.setDrawSymbol(false);
        f1.setDrawLine(true);
        DataArray data1 = new DataArray(0, 1, Bin, f1.getDrawOption());
        for (int i = 0; i < Bin; ++i) {
            data1.addPoint(f1.getX(i), f1.getY(i));
        }
        data1.setDimension(2);
        data1.setType(102);
        data1.setName(f1.getTitle() + "; " + f1.getFixedVars());
        this.ja[padx - 1][pady - 1].addData(data1, 102);
        this.addKey(data1, padx, pady);
    }

    public void draw(F1D f1) {
        this.draw(f1, this.N1 + 1, this.N2 + 1);
    }

    public void draw(FND f1) {
        this.draw(f1, this.N1 + 1, this.N2 + 1);
    }

    public void draw(P1D p1d, int padx, int pady) {
        if (padx > this.N1final || pady > this.N2final) {
            this.ErrorMessage("Wrong number of canvas in cd() method\n  ");
            this.N1 = 0;
            this.N2 = 0;
            return;
        }
        if (p1d.getLabelX() != null && p1d.getLabelX().length() > 0) {
            this.setNameX(p1d.getLabelX());
        }
        if (p1d.getLabelY() != null && p1d.getLabelY().length() > 0) {
            this.setNameY(p1d.getLabelY());
        }
        p1d.setType(103);
        p1d.setGraphStyle(0);
        DataArray tmp = p1d.getDataArray();
        tmp.setDimension(p1d.dimension());
        tmp.setLinePars(p1d.getDrawOption());
        tmp.setName(p1d.getTitle());
        if (!this.ja[padx - 1][pady - 1].isContour()) {
            this.ja[padx - 1][pady - 1].addData(tmp, 103);
            tmp.setType(103);
            this.addKey(tmp, padx, pady);
            this.getStatistics(p1d);
            this.ja[padx - 1][pady - 1].setStatistics(this.getStatistics(p1d));
        }
        if (this.ja[padx - 1][pady - 1].isContour()) {
            tmp.setType(2);
            this.ja[padx - 1][pady - 1].addData(tmp, 2);
        }
        this.addStatBox(padx, pady);
    }

    public void draw(P1D[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.draw(d[i]);
        }
    }

    public Vector<DataArray> getData() {
        return this.ja[this.N1][this.N2].getData();
    }

    public void setAutoRange(int axis, boolean b) {
        this.ja[this.N1][this.N2].setAutoRange(axis, b);
    }

    public void setAutoRangeAll(int axis, boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.ja[i1][i2].setAutoRange(axis, b);
            }
        }
    }

    public void setAutoRange(boolean b) {
        this.ja[this.N1][this.N2].setAutoRange(0, b);
        this.ja[this.N1][this.N2].setAutoRange(1, b);
    }

    public void setAutoRangeAll(boolean b) {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.ja[i1][i2].setAutoRange(0, b);
                this.ja[i1][i2].setAutoRange(1, b);
            }
        }
    }

    public void setAutoRange() {
        this.ja[this.N1][this.N2].setAutoRange(0, true);
        this.ja[this.N1][this.N2].setAutoRange(1, true);
    }

    public void setAutoRangeAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.ja[i1][i2].setAutoRange(0, true);
                this.ja[i1][i2].setAutoRange(1, true);
            }
        }
    }

    public void visible(boolean vs) {
        this.feyn.setVisible(vs);
        if (!vs) {
            this.feyn.validate();
        }
    }

    public void visible() {
        this.feyn.setVisible(true);
    }

    public void visible(int posX, int posY) {
        this.feyn.setLocation(posX, posY);
        this.feyn.setVisible(true);
    }

    private void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    public static void main(String[] args) {
        String inputFile = HPlotJa.getCommandLineArgs(args);
        JaxoDraw jd = new JaxoDraw(inputFile);
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    static {
        inputFile = null;
        USER_NAME = System.getProperty("user.name");
        USER_HOME = System.getProperty("user.home");
        OS_NAME = System.getProperty("os.name");
        OS_ARCH = System.getProperty("os.arch");
        OS_VERSION = System.getProperty("os.version");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
        JAVA_HOME = System.getProperty("java.home");
        JAVA_CLASSPATH = System.getProperty("java.class.path");
        PREFS_FILENAME = USER_HOME + File.separator + ".jaPlotrc";
        curDIR = "";
    }
}

