/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import hep.aida.IAxis;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jhplot.F1D;
import jhplot.H1D;
import jhplot.JHPlot;
import jhplot.P1D;
import jhplot.gui.CommonGUI;
import jhplot.gui.GHFrame;
import jhplot.gui.HelpBrowser;
import jhplot.io.images.Export;
import jhplot.io.images.ImageType;
import jplot.LinePars;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYIntervalSeries;
import org.jfree.data.xy.XYIntervalSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;

public class HChart
extends GHFrame {
    private static final long serialVersionUID = 1L;
    public static int IndexPlot = 0;
    private ChartPanel[][] cp;
    private JFreeChart[][] chart;
    private DefaultPieDataset[][] cdatPie;
    private DefaultPieDataset[][] cdatPie3D;
    private XYSeriesCollection[][] cdatPolar;
    private DefaultCategoryDataset[][] cdatBar;
    private DefaultCategoryDataset[][] cdatBar3D;
    private DefaultCategoryDataset[][] cdatLine;
    private DefaultCategoryDataset[][] cdatArea;
    private ArrayList<AbstractRenderer>[][] rdat;
    private int[][] indexdat;
    private Map<Integer, String>[][] type;
    private ValueAxis[][] xAxis;
    private ValueAxis[][] yAxis;
    private XYPlot[][] xyplot;
    private float linestroke = 4.0f;
    public boolean set;
    private boolean antiAlias;
    private String[][] title;
    private String[][] titleX;
    private String[][] titleY;
    private int Bins = 10;
    private double Min = 0.0;
    private double Max = 0.0;
    private String sname = "";
    private final Color DEFAULT_BG_COLOR = Color.white;
    private Thread1 m_Close;
    private Font labelFont;
    private Font tickFont;
    private Color labelColor;
    private Color tickColor;
    private boolean[] isLog;
    private float axisPenwidth;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;

    public HChart(String title, int xsize, int ysize, int n1, int n2, boolean set) {
        super(title, xsize, ysize, n1, n2, set, 1);
        this.cdatPie = new DefaultPieDataset[this.N1final][this.N2final];
        this.cdatPie3D = new DefaultPieDataset[this.N1final][this.N2final];
        this.cdatBar = new DefaultCategoryDataset[this.N1final][this.N2final];
        this.cdatBar3D = new DefaultCategoryDataset[this.N1final][this.N2final];
        this.cdatLine = new DefaultCategoryDataset[this.N1final][this.N2final];
        this.cdatArea = new DefaultCategoryDataset[this.N1final][this.N2final];
        this.cdatPolar = new XYSeriesCollection[this.N1final][this.N2final];
        this.isLog = new boolean[2];
        this.isLog[0] = false;
        this.isLog[1] = false;
        this.xAxis = new NumberAxis[this.N1final][this.N2final];
        this.yAxis = new NumberAxis[this.N1final][this.N2final];
        this.xyplot = new XYPlot[this.N1final][this.N2final];
        this.type = new HashMap[this.N1final][this.N2final];
        this.indexdat = new int[this.N1final][this.N2final];
        this.rdat = new ArrayList[this.N1final][this.N2final];
        this.axisPenwidth = 3.0f;
        XYBarRenderer defaultrender = new XYBarRenderer(0.2);
        this.tickFont = new Font("Arial", 1, 14);
        this.labelFont = new Font("Arial", 1, 16);
        this.labelColor = Color.BLACK;
        this.tickColor = Color.BLACK;
        this.chart = new JFreeChart[this.N1final][this.N2final];
        this.cp = new ChartPanel[this.N1final][this.N2final];
        this.antiAlias = true;
        this.title = new String[this.N1final][this.N2final];
        this.titleX = new String[this.N1final][this.N2final];
        this.titleY = new String[this.N1final][this.N2final];
        for (int i2 = 0; i2 < this.N2final; ++i2) {
            for (int i1 = 0; i1 < this.N1final; ++i1) {
                this.title[i1][i2] = title;
                this.titleX[i1][i2] = "X";
                this.titleY[i1][i2] = "Y";
                this.rdat[i1][i2] = new ArrayList();
                this.xAxis[i1][i2] = new NumberAxis(this.titleX[i1][i2]);
                this.xAxis[i1][i2].setTickLabelPaint((Paint)this.tickColor);
                this.xAxis[i1][i2].setTickLabelFont(this.tickFont);
                this.xAxis[i1][i2].setLabelPaint((Paint)this.labelColor);
                this.xAxis[i1][i2].setLabelFont(this.labelFont);
                this.xAxis[i1][i2].setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                this.xAxis[i1][i2].setAxisLinePaint((Paint)Color.black);
                this.type[i1][i2] = new HashMap<Integer, String>();
                this.indexdat[i1][i2] = 0;
                this.yAxis[i1][i2] = new NumberAxis(this.titleX[i1][i2]);
                this.yAxis[i1][i2].setTickLabelPaint((Paint)this.tickColor);
                this.yAxis[i1][i2].setTickLabelFont(this.tickFont);
                this.yAxis[i1][i2].setLabelPaint((Paint)this.labelColor);
                this.yAxis[i1][i2].setLabelFont(this.labelFont);
                this.yAxis[i1][i2].setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                this.yAxis[i1][i2].setAxisLinePaint((Paint)Color.black);
                this.xyplot[i1][i2] = new XYPlot(null, this.xAxis[i1][i2], this.yAxis[i1][i2], (XYItemRenderer)defaultrender);
                this.xyplot[i1][i2].setOutlinePaint((Paint)Color.black);
                this.xyplot[i1][i2].setOutlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                this.xyplot[i1][i2].setOutlineVisible(true);
                this.xyplot[i1][i2].setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
                this.xyplot[i1][i2].setOrientation(this.orientation);
                this.chart[i1][i2] = new JFreeChart(this.title[i1][i2], JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.xyplot[i1][i2], true);
                this.chart[i1][i2].setAntiAlias(this.antiAlias);
                this.chart[i1][i2].setBorderPaint((Paint)this.DEFAULT_BG_COLOR);
                this.chart[i1][i2].setBackgroundPaint((Paint)this.DEFAULT_BG_COLOR);
                this.chart[i1][i2].setBorderVisible(false);
                this.cp[i1][i2] = new ChartPanel(this.chart[i1][i2]);
                this.cp[i1][i2].setBackground(this.DEFAULT_BG_COLOR);
                this.cp[i1][i2].setLayout((LayoutManager)new BorderLayout());
                this.cp[i1][i2].setDomainZoomable(true);
                this.cp[i1][i2].setRangeZoomable(true);
                if (!set) continue;
                this.mainPanel.add((Component)this.cp[i1][i2]);
            }
        }
        this.setTheme("LEGACY_THEME");
    }

    public void resizePad(double widthScale, double heightScale) {
        Dimension dim = this.cp[N1][N2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.cp[N1][N2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[N1][N2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[N1][N2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void resizePad(int n1, int n2, double widthScale, double heightScale) {
        Dimension dim = this.cp[n1][n2].getSize();
        double h = dim.getHeight();
        double w = dim.getWidth();
        this.cp[n1][n2].setPreferredSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[n1][n2].setMinimumSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
        this.cp[n1][n2].setSize(new Dimension((int)(w * widthScale), (int)(h * heightScale)));
    }

    public void setPlotVertical() {
        this.orientation = PlotOrientation.VERTICAL;
    }

    public void setPlotHorizontal() {
        this.orientation = PlotOrientation.HORIZONTAL;
    }

    public PlotOrientation getPlotOrientation() {
        return this.orientation;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
        this.xAxis[N1][N2].setLabelPaint((Paint)labelColor);
        this.yAxis[N1][N2].setLabelPaint((Paint)labelColor);
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
        this.xAxis[N1][N2].setLabelFont(this.labelFont);
        this.yAxis[N1][N2].setLabelFont(this.labelFont);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setTickColor(int axis, Color tickColor) {
        this.tickColor = tickColor;
        this.xAxis[N1][N2].setTickLabelPaint((Paint)tickColor);
        this.yAxis[N1][N2].setTickLabelPaint((Paint)tickColor);
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickFont(Font tickFont) {
        this.tickFont = tickFont;
        this.xAxis[N1][N2].setTickLabelFont(tickFont);
        this.yAxis[N1][N2].setTickLabelFont(tickFont);
    }

    public Font getTickFont() {
        return this.tickFont;
    }

    @Override
    protected void refreshFrame() {
    }

    @Override
    protected void openWriteDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    @Override
    protected void openReadDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for HGraph");
    }

    public void visible(boolean vs) {
        this.mainFrame.setVisible(vs);
    }

    public void visible() {
        this.mainFrame.setVisible(true);
    }

    public void visible(int posX, int posY) {
        this.mainFrame.setLocation(posX, posY);
        this.mainFrame.setVisible(true);
    }

    public void setTheme(String s) {
        if (s.equals("LEGACY_THEME")) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
            this.applyThemeToChart();
        } else if (s.equals("JFREE_THEME")) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createJFreeTheme());
            this.applyThemeToChart();
        } else if (s.equals("DARKNESS_THEME")) {
            ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createDarknessTheme());
            this.applyThemeToChart();
        }
    }

    private void applyThemeToChart() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                if (this.chart[i1][i2] == null) continue;
                ChartUtilities.applyCurrentTheme((JFreeChart)this.chart[i1][i2]);
            }
        }
    }

    public void destroy() {
        this.mainFrame.setVisible(false);
        this.close();
    }

    public void setFontAxisX(Font f, Color c) {
        XYPlot plot = this.chart[N1][N2].getXYPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickLabelPaint((Paint)c);
        rangeAxis.setTickLabelFont(f);
        rangeAxis.setLabelPaint((Paint)c);
        this.update();
    }

    public void setFontAxisY(Font f, Color c) {
        XYPlot plot = this.chart[N1][N2].getXYPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelPaint((Paint)c);
        domainAxis.setTickLabelFont(f);
        domainAxis.setLabelPaint((Paint)c);
        this.update();
    }

    public void setChartArea() {
        this.cdatArea[HChart.N1][HChart.N2] = new DefaultCategoryDataset();
    }

    public void setChartBar() {
        this.cdatBar[HChart.N1][HChart.N2] = new DefaultCategoryDataset();
    }

    public void setChartBar3D() {
        this.cdatBar3D[HChart.N1][HChart.N2] = new DefaultCategoryDataset();
    }

    public void setChartLine() {
        this.setChartLine(4.0);
    }

    public void setChartLine(double stroke) {
        this.linestroke = (float)stroke;
        this.cdatLine[HChart.N1][HChart.N2] = new DefaultCategoryDataset();
    }

    public void setChartPie() {
        this.cdatPie[HChart.N1][HChart.N2] = new DefaultPieDataset();
    }

    public void setChartPie3D() {
        this.cdatPie3D[HChart.N1][HChart.N2] = new DefaultPieDataset();
    }

    public void setChartPolar() {
        this.cdatPolar[HChart.N1][HChart.N2] = new XYSeriesCollection();
    }

    public void clearPlot() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                if (this.chart[i1][i2] == null) continue;
                this.chart[i1][i2].setTitle("");
                this.chart[i1][i2].setBackgroundPaint((Paint)this.DEFAULT_BG_COLOR);
            }
        }
    }

    public void clearData() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
            }
        }
    }

    public HChart(String title, int xs, int ys) {
        this(title, xs, ys, 1, 1, true);
    }

    public HChart(String title, int xs, int ys, boolean set) {
        this(title, xs, ys, 1, 1, set);
    }

    public HChart(String title, int xs, int ys, int n1, int n2) {
        this(title, xs, ys, n1, n2, true);
    }

    public HChart(String title) {
        this(title, 600, 400, 1, 1, true);
    }

    public HChart() {
        this("Default", 600, 400, 1, 1, true);
    }

    public void clear() {
        this.clear(N1, N2);
    }

    public void clear(int i1, int i2) {
        this.setGTitle("");
        System.gc();
    }

    public void clearAll() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.clear(i1, i2);
            }
        }
        System.gc();
    }

    public void update() {
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.update(i1, i2);
            }
        }
        System.gc();
    }

    public void setName(String title) {
        this.title[HChart.N1][HChart.N2] = title;
    }

    public void setNameX(String s) {
        this.titleX[HChart.N1][HChart.N2] = s;
        ValueAxis xx = this.xyplot[N1][N2].getDomainAxis();
        xx.setLabel(s);
    }

    public void setNameY(String s) {
        this.titleY[HChart.N1][HChart.N2] = s;
        ValueAxis yy = this.xyplot[N1][N2].getRangeAxis();
        yy.setLabel(s);
    }

    public void setLogScale(int axis, boolean b) {
        this.isLog[axis] = b;
        if (!this.isLog[0]) {
            this.xAxis[HChart.N1][HChart.N2] = new NumberAxis(this.titleX[N1][N2]);
        }
        if (this.isLog[0]) {
            this.xAxis[HChart.N1][HChart.N2] = new LogarithmicAxis(this.titleX[N1][N2]);
        }
        if (!this.isLog[1]) {
            this.yAxis[HChart.N1][HChart.N2] = new NumberAxis(this.titleY[N1][N2]);
        }
        if (this.isLog[1]) {
            this.yAxis[HChart.N1][HChart.N2] = new LogarithmicAxis(this.titleY[N1][N2]);
        }
    }

    public void setAxis(int axis, ValueAxis a) {
        if (axis == 0) {
            this.xAxis[HChart.N1][HChart.N2] = a;
        }
        if (axis == 1) {
            this.yAxis[HChart.N1][HChart.N2] = a;
        }
    }

    public ValueAxis getAxis(int axis) {
        if (axis == 0) {
            return this.xAxis[N1][N2];
        }
        if (axis == 1) {
            return this.yAxis[N1][N2];
        }
        return this.xAxis[N1][N2];
    }

    public void setFontLegent(Font f) {
        LegendTitle lt = this.chart[N1][N2].getLegend();
        lt.setItemFont(f);
        lt.setNotify(true);
    }

    public void setFontTitle(Font f) {
        TextTitle lt = this.chart[N1][N2].getTitle();
    }

    public void draw(double[] x, double[] y) {
        XYSeriesCollection c = new XYSeriesCollection();
        XYSeries SerData = new XYSeries((Comparable)((Object)"XY data"));
        for (int i = 0; i < x.length; ++i) {
            SerData.add(x[i], y[i]);
        }
        c.addSeries(SerData);
        this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "array");
        this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
        this.xyplot[N1][N2].setRenderer(this.indexdat[N1][N2], (XYItemRenderer)new StandardXYItemRenderer());
        this.rdat[N1][N2].add((AbstractRenderer)new StandardXYItemRenderer());
        int[] nArray = this.indexdat[N1];
        int n = N2;
        nArray[n] = nArray[n] + 1;
        this.update(N1, N2);
    }

    public void draw(F1D f1) {
        this.add(f1);
        this.update(N1, N2);
    }

    public void draw(H1D f1) {
        this.add(f1);
        this.update(N1, N2);
    }

    public void add(F1D f1) {
        int Bin = f1.getPoints();
        if (f1.getMin() == f1.getMax()) {
            f1.eval(this.Min, this.Max, Bin);
        } else {
            f1.eval(f1.getMin(), f1.getMax(), Bin);
        }
        XYSeriesCollection c = new XYSeriesCollection();
        XYSeries SerData = new XYSeries((Comparable)((Object)f1.getName()));
        for (int i = 0; i < Bin; ++i) {
            SerData.add(f1.getX(i), f1.getY(i));
        }
        c.addSeries(SerData);
        this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setDrawSeriesLineAsPath(true);
        LinePars lpp = f1.getDrawOption();
        float width = lpp.getPenWidth();
        int style = f1.getLineStyle();
        float dash = lpp.getDashLength();
        renderer.setSeriesStroke(0, this.getStrokes(style, width, dash));
        renderer.setSeriesPaint(0, (Paint)f1.getColor());
        this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "f");
        this.rdat[N1][N2].add((AbstractRenderer)renderer);
        int[] nArray = this.indexdat[N1];
        int n = N2;
        nArray[n] = nArray[n] + 1;
    }

    public void add(H1D h1) {
        IAxis axis = h1.get().axis();
        XYIntervalSeriesCollection c = new XYIntervalSeriesCollection();
        XYIntervalSeries SerData = new XYIntervalSeries((Comparable)((Object)h1.getTitle()));
        int ibins = axis.bins();
        for (int i = 0; i < ibins; ++i) {
            SerData.add(h1.binMean(i), axis.binLowerEdge(i), axis.binUpperEdge(i), h1.binHeight(i), 0.0, h1.binHeight(i));
        }
        c.addSeries(SerData);
        this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
        XYBarRenderer render = new XYBarRenderer();
        LinePars lpp = h1.getDrawOption();
        Color cfill = lpp.getFillColor();
        float width = lpp.getPenWidth();
        int style = h1.getLineStyle();
        float dash = lpp.getDashLength();
        StandardXYBarPainter paint = new StandardXYBarPainter();
        render.setBarPainter((XYBarPainter)paint);
        render.setDrawBarOutline(true);
        render.setShadowVisible(false);
        render.setBaseStroke(this.getStrokes(style, width, dash));
        render.setBasePaint((Paint)cfill);
        render.setBaseOutlinePaint((Paint)h1.getColor());
        render.setBaseOutlineStroke(this.getStrokes(style, width, dash));
        render.setSeriesStroke(0, this.getStrokes(style, width, dash));
        render.setSeriesPaint(0, (Paint)cfill);
        render.setSeriesOutlinePaint(0, (Paint)h1.getColor());
        if (h1.isFilled()) {
            render.setSeriesFillPaint(0, (Paint)cfill);
        }
        this.rdat[N1][N2].add((AbstractRenderer)render);
        this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "h");
        int[] nArray = this.indexdat[N1];
        int n = N2;
        nArray[n] = nArray[n] + 1;
    }

    public void draw(ArrayList<Double> x, ArrayList<Double> y) {
    }

    public void setLegendPosition(RectangleEdge e) {
        LegendTitle legend = this.chart[N1][N2].getLegend();
        legend.setPosition(e);
    }

    public void setLegend(boolean b) {
        if (!b) {
            this.chart[N1][N2].removeLegend();
        }
    }

    public void add(P1D d) {
        if (this.cdatPolar[N1][N2] != null) {
            XYSeries SerData = new XYSeries((Comparable)((Object)d.getTitle()));
            for (int i = 0; i < d.size(); ++i) {
                SerData.add(d.getX(i), d.getY(i));
            }
            this.cdatPolar[N1][N2].addSeries(SerData);
            return;
        }
        LinePars lpp = d.getDrawOption();
        float width = lpp.getPenWidth();
        int style = d.getLineStyle();
        float dash = lpp.getDashLength();
        int symbol = lpp.getSymbol();
        Shape shape = this.getShape(symbol, lpp.getSymbolSize());
        if (d.dimension() > 5) {
            XYIntervalSeriesCollection c = new XYIntervalSeriesCollection();
            XYIntervalSeries SerData = new XYIntervalSeries((Comparable)((Object)d.getTitle()));
            for (int i = 0; i < d.size(); ++i) {
                SerData.add(d.getX(i), d.getX(i) - d.getXleft(i), d.getX(i) + d.getXright(i), d.getY(i), d.getY(i) - d.getYlower(i), d.getY(i) + d.getYupper(i));
            }
            c.addSeries(SerData);
            this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
            XYErrorRenderer xyerrorrenderer = new XYErrorRenderer();
            xyerrorrenderer.setSeriesStroke(0, this.getStrokes(style, width, dash));
            xyerrorrenderer.setSeriesPaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesOutlinePaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesFillPaint(0, (Paint)lpp.getFillColor());
            xyerrorrenderer.setSeriesShape(0, shape);
            if (symbol > 0 && symbol < 4) {
                xyerrorrenderer.setSeriesShapesFilled(0, false);
            }
            if (symbol > 3) {
                xyerrorrenderer.setSeriesShapesFilled(0, true);
            }
            this.rdat[N1][N2].add((AbstractRenderer)xyerrorrenderer);
            this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "pe");
            int[] nArray = this.indexdat[N1];
            int n = N2;
            nArray[n] = nArray[n] + 1;
        } else if (d.dimension() == 4) {
            XYIntervalSeriesCollection c = new XYIntervalSeriesCollection();
            XYIntervalSeries SerData = new XYIntervalSeries((Comparable)((Object)d.getTitle()));
            for (int i = 0; i < d.size(); ++i) {
                SerData.add(d.getX(i), d.getX(i), d.getX(i), d.getY(i), d.getY(i) - d.getYlower(i), d.getY(i) + d.getYupper(i));
            }
            c.addSeries(SerData);
            this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
            XYErrorRenderer xyerrorrenderer = new XYErrorRenderer();
            xyerrorrenderer.setSeriesStroke(0, this.getStrokes(style, width, dash));
            xyerrorrenderer.setSeriesPaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesOutlinePaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesFillPaint(0, (Paint)lpp.getFillColor());
            xyerrorrenderer.setSeriesShape(0, shape);
            if (symbol > 0 && symbol < 4) {
                xyerrorrenderer.setSeriesShapesFilled(0, false);
            }
            if (symbol > 3) {
                xyerrorrenderer.setSeriesShapesFilled(0, true);
            }
            this.rdat[N1][N2].add((AbstractRenderer)xyerrorrenderer);
            this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "pe");
            int[] nArray = this.indexdat[N1];
            int n = N2;
            nArray[n] = nArray[n] + 1;
        } else if (d.dimension() == 3) {
            XYIntervalSeriesCollection c = new XYIntervalSeriesCollection();
            XYIntervalSeries SerData = new XYIntervalSeries((Comparable)((Object)d.getTitle()));
            for (int i = 0; i < d.size(); ++i) {
                SerData.add(d.getX(i), d.getX(i), d.getX(i), d.getY(i), d.getY(i) - d.getYupper(i), d.getY(i) + d.getYupper(i));
            }
            c.addSeries(SerData);
            this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
            XYErrorRenderer xyerrorrenderer = new XYErrorRenderer();
            xyerrorrenderer.setSeriesStroke(0, this.getStrokes(style, width, dash));
            xyerrorrenderer.setSeriesPaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesOutlinePaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesFillPaint(0, (Paint)lpp.getFillColor());
            xyerrorrenderer.setSeriesShape(0, shape);
            if (symbol > 0 && symbol < 4) {
                xyerrorrenderer.setSeriesShapesFilled(0, false);
            }
            if (symbol > 3) {
                xyerrorrenderer.setSeriesShapesFilled(0, true);
            }
            this.rdat[N1][N2].add((AbstractRenderer)xyerrorrenderer);
            this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "pe");
            int[] nArray = this.indexdat[N1];
            int n = N2;
            nArray[n] = nArray[n] + 1;
        } else {
            XYSeriesCollection c = new XYSeriesCollection();
            XYSeries SerData = new XYSeries((Comparable)((Object)d.getTitle()));
            for (int i = 0; i < d.size(); ++i) {
                SerData.add(d.getX(i), d.getY(i));
            }
            c.addSeries(SerData);
            this.xyplot[N1][N2].setDataset(this.indexdat[N1][N2], (XYDataset)c);
            XYLineAndShapeRenderer xyerrorrenderer = new XYLineAndShapeRenderer(false, true);
            xyerrorrenderer.setSeriesStroke(0, this.getStrokes(style, width, dash));
            xyerrorrenderer.setSeriesPaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesOutlinePaint(0, (Paint)d.getColor());
            xyerrorrenderer.setSeriesFillPaint(0, (Paint)lpp.getFillColor());
            xyerrorrenderer.setSeriesShape(0, shape);
            if (symbol > 0 && symbol < 4) {
                xyerrorrenderer.setSeriesShapesFilled(0, false);
            }
            if (symbol > 3) {
                xyerrorrenderer.setSeriesShapesFilled(0, true);
            }
            this.rdat[N1][N2].add((AbstractRenderer)xyerrorrenderer);
            this.type[N1][N2].put(new Integer(this.indexdat[N1][N2]), "p");
            int[] nArray = this.indexdat[N1];
            int n = N2;
            nArray[n] = nArray[n] + 1;
        }
    }

    public void valuePie(String name, double value) {
        if (this.cdatPie[N1][N2] != null) {
            this.cdatPie[N1][N2].setValue((Comparable)((Object)name), value);
        }
    }

    @Override
    public void clearFrame() {
        this.clearAll();
    }

    public void valuePie3D(String name, double value) {
        if (this.cdatPie3D[N1][N2] != null) {
            this.cdatPie3D[N1][N2].setValue((Comparable)((Object)name), value);
        }
    }

    public void valueBar(double value, String series, String category) {
        if (this.cdatBar[N1][N2] != null) {
            this.cdatBar[N1][N2].addValue(value, (Comparable)((Object)category), (Comparable)((Object)series));
        }
    }

    public void valueArea(double value, String series, String category) {
        if (this.cdatArea[N1][N2] != null) {
            this.cdatArea[N1][N2].addValue(value, (Comparable)((Object)category), (Comparable)((Object)series));
        }
    }

    public void setRange(int axis, double min, double max) {
        if (axis == 0) {
            this.xyplot[N1][N2].getDomainAxis().setRange(min, max);
        }
        if (axis == 1) {
            this.xyplot[N1][N2].getRangeAxis().setRange(min, max);
        }
    }

    public void setAutoRange(boolean b) {
        this.xyplot[N1][N2].getDomainAxis().setAutoRange(b);
        this.xyplot[N1][N2].getRangeAxis().setAutoRange(b);
    }

    public void setAutoRange() {
        this.setAutoRange(true);
    }

    public void setAntiAlias(boolean setit) {
        this.antiAlias = setit;
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setGrid(boolean b) {
        this.xyplot[N1][N2].setDomainGridlinesVisible(b);
        this.xyplot[N1][N2].setRangeGridlinesVisible(b);
    }

    public void setGrid(int axis, boolean b) {
        if (axis == 1) {
            this.xyplot[N1][N2].setDomainGridlinesVisible(b);
        }
        if (axis == 0) {
            this.xyplot[N1][N2].setRangeGridlinesVisible(b);
        }
    }

    public void setGridColor(Color c) {
        this.xyplot[N1][N2].setDomainGridlinePaint((Paint)c);
        this.xyplot[N1][N2].setRangeGridlinePaint((Paint)c);
    }

    public void setGridPenWidth(double width) {
        this.xyplot[N1][N2].setDomainGridlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
        this.xyplot[N1][N2].setRangeGridlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
    }

    public void setGridPenWidth(int axis, double width) {
        if (axis == 1) {
            this.xyplot[N1][N2].setDomainGridlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
        }
        if (axis == 0) {
            this.xyplot[N1][N2].setRangeGridlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
        }
    }

    public void setBackgColor(Color color) {
        this.xyplot[N1][N2].setBackgroundPaint((Paint)color);
    }

    public void valueLine(double value, String series, String category) {
        if (this.cdatLine[N1][N2] != null) {
            this.cdatLine[N1][N2].addValue(value, (Comparable)((Object)category), (Comparable)((Object)series));
        }
    }

    public void valueBar3D(double value, String series, String category) {
        if (this.cdatBar3D[N1][N2] != null) {
            this.cdatBar3D[N1][N2].addValue(value, (Comparable)((Object)category), (Comparable)((Object)series));
        }
    }

    public void update(int N1, int N2) {
        if (this.cdatPie[N1][N2] != null || this.cdatPie3D[N1][N2] != null || this.cdatBar[N1][N2] != null || this.cdatBar3D[N1][N2] != null || this.cdatLine[N1][N2] != null || this.cdatArea[N1][N2] != null || this.cdatPolar[N1][N2] != null) {
            if (this.cdatPie[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createPieChart((String)this.title[N1][N2], (PieDataset)this.cdatPie[N1][N2], (boolean)true, (boolean)true, (boolean)true);
            } else if (this.cdatPie3D[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createPieChart3D((String)this.title[N1][N2], (PieDataset)this.cdatPie3D[N1][N2], (boolean)true, (boolean)true, (boolean)true);
                PiePlot3D pieplot3d = (PiePlot3D)this.chart[N1][N2].getPlot();
                pieplot3d.setBackgroundPaint((Paint)this.DEFAULT_BG_COLOR);
            } else if (this.cdatBar[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createBarChart((String)this.title[N1][N2], (String)this.titleX[N1][N2], (String)this.titleY[N1][N2], (CategoryDataset)this.cdatBar[N1][N2], (PlotOrientation)this.orientation, (boolean)true, (boolean)true, (boolean)true);
                CategoryPlot lineplot = (CategoryPlot)this.chart[N1][N2].getPlot();
                CategoryAxis yy = lineplot.getDomainAxis();
                yy.setTickLabelPaint((Paint)this.tickColor);
                yy.setTickLabelFont(this.tickFont);
                yy.setLabelPaint((Paint)this.labelColor);
                yy.setLabelFont(this.labelFont);
                yy.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                yy.setAxisLinePaint((Paint)Color.black);
                ValueAxis xx = lineplot.getRangeAxis();
                xx.setTickLabelPaint((Paint)this.tickColor);
                xx.setTickLabelFont(this.tickFont);
                xx.setLabelPaint((Paint)this.labelColor);
                xx.setLabelFont(this.labelFont);
                xx.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                xx.setAxisLinePaint((Paint)Color.black);
            } else if (this.cdatBar3D[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createBarChart3D((String)this.title[N1][N2], (String)this.titleX[N1][N2], (String)this.titleY[N1][N2], (CategoryDataset)this.cdatBar3D[N1][N2], (PlotOrientation)this.orientation, (boolean)true, (boolean)true, (boolean)true);
            } else if (this.cdatLine[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createLineChart((String)this.title[N1][N2], (String)this.titleX[N1][N2], (String)this.titleY[N1][N2], (CategoryDataset)this.cdatLine[N1][N2], (PlotOrientation)this.orientation, (boolean)true, (boolean)true, (boolean)true);
                CategoryPlot lineplot = (CategoryPlot)this.chart[N1][N2].getPlot();
                lineplot.setOutlineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                CategoryAxis yy = lineplot.getDomainAxis();
                yy.setTickLabelPaint((Paint)this.tickColor);
                yy.setTickLabelFont(this.tickFont);
                yy.setLabelPaint((Paint)this.labelColor);
                yy.setLabelFont(this.labelFont);
                yy.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                yy.setAxisLinePaint((Paint)Color.black);
                ValueAxis xx = lineplot.getRangeAxis();
                xx.setTickLabelPaint((Paint)this.tickColor);
                xx.setTickLabelFont(this.tickFont);
                xx.setLabelPaint((Paint)this.labelColor);
                xx.setLabelFont(this.labelFont);
                xx.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                xx.setAxisLinePaint((Paint)Color.black);
                LineAndShapeRenderer renderer = (LineAndShapeRenderer)lineplot.getRenderer();
                renderer.setBaseStroke((Stroke)new BasicStroke(this.linestroke));
                for (int m = 0; m < this.cdatLine[N1][N2].getColumnCount() + 1; ++m) {
                    renderer.setSeriesStroke(m, (Stroke)new BasicStroke(this.linestroke));
                }
            } else if (this.cdatPolar[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createPolarChart((String)this.title[N1][N2], (XYDataset)this.cdatPolar[N1][N2], (boolean)true, (boolean)true, (boolean)true);
                PolarPlot lineplot = (PolarPlot)this.chart[N1][N2].getPlot();
                ValueAxis yy = lineplot.getAxis();
                yy.setTickLabelPaint((Paint)this.tickColor);
                yy.setTickLabelFont(this.tickFont);
                yy.setLabelPaint((Paint)this.labelColor);
                yy.setLabelFont(this.labelFont);
                yy.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                yy.setAxisLinePaint((Paint)Color.black);
            } else if (this.cdatArea[N1][N2] != null) {
                this.chart[N1][N2] = ChartFactory.createAreaChart((String)this.title[N1][N2], (String)this.titleX[N1][N2], (String)this.titleY[N1][N2], (CategoryDataset)this.cdatArea[N1][N2], (PlotOrientation)this.orientation, (boolean)true, (boolean)true, (boolean)true);
                CategoryPlot lineplot = (CategoryPlot)this.chart[N1][N2].getPlot();
                CategoryAxis yy = lineplot.getDomainAxis();
                yy.setTickLabelPaint((Paint)this.tickColor);
                yy.setTickLabelFont(this.tickFont);
                yy.setLabelPaint((Paint)this.labelColor);
                yy.setLabelFont(this.labelFont);
                yy.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                yy.setAxisLinePaint((Paint)Color.black);
                ValueAxis xx = lineplot.getRangeAxis();
                xx.setTickLabelPaint((Paint)this.tickColor);
                xx.setTickLabelFont(this.tickFont);
                xx.setLabelPaint((Paint)this.labelColor);
                xx.setLabelFont(this.labelFont);
                xx.setAxisLineStroke((Stroke)new BasicStroke(this.axisPenwidth));
                xx.setAxisLinePaint((Paint)Color.black);
            }
            this.chart[N1][N2].setAntiAlias(this.antiAlias);
            this.chart[N1][N2].setBorderPaint((Paint)this.DEFAULT_BG_COLOR);
            this.chart[N1][N2].setBackgroundPaint((Paint)this.DEFAULT_BG_COLOR);
            this.chart[N1][N2].setBorderVisible(false);
            this.cp[N1][N2].setChart(this.chart[N1][N2]);
            return;
        }
        for (int i = 0; i < this.indexdat[N1][N2]; ++i) {
            if (this.type[N1][N2].get(i) == "array") {
                this.xyplot[N1][N2].setRenderer(i, (XYItemRenderer)((StandardXYItemRenderer)this.rdat[N1][N2].get(i)));
                continue;
            }
            if (this.type[N1][N2].get(i) == "f") {
                this.xyplot[N1][N2].setRenderer(i, (XYItemRenderer)((XYLineAndShapeRenderer)this.rdat[N1][N2].get(i)));
                continue;
            }
            if (this.type[N1][N2].get(i) == "h") {
                this.xyplot[N1][N2].setRenderer(i, (XYItemRenderer)((XYBarRenderer)this.rdat[N1][N2].get(i)));
                continue;
            }
            if (this.type[N1][N2].get(i) == "p") {
                this.xyplot[N1][N2].setRenderer(i, (XYItemRenderer)((XYLineAndShapeRenderer)this.rdat[N1][N2].get(i)));
                continue;
            }
            if (this.type[N1][N2].get(i) != "pe") continue;
            this.xyplot[N1][N2].setRenderer(i, (XYItemRenderer)((XYErrorRenderer)this.rdat[N1][N2].get(i)));
        }
        this.chart[N1][N2] = new JFreeChart(this.title[N1][N2], JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.xyplot[N1][N2], true);
        this.chart[N1][N2].setAntiAlias(this.antiAlias);
        this.chart[N1][N2].setBorderPaint((Paint)this.DEFAULT_BG_COLOR);
        this.chart[N1][N2].setBackgroundPaint((Paint)this.DEFAULT_BG_COLOR);
        this.chart[N1][N2].setBorderVisible(false);
        this.cp[N1][N2].setChart(this.chart[N1][N2]);
    }

    public JFreeChart getChart() {
        return this.chart[N1][N2];
    }

    public Axis getAxisX() {
        return this.xAxis[N1][N2];
    }

    public Axis getAxisY() {
        return this.yAxis[N1][N2];
    }

    public XYPlot getPlot() {
        return this.xyplot[N1][N2];
    }

    public ChartPanel getChartPanel() {
        return this.cp[N1][N2];
    }

    public void close() {
        this.mainFrame.setVisible(false);
        this.m_Close = new Thread1("Closing softly");
        if (!this.m_Close.Alive()) {
            this.m_Close.Start();
        }
    }

    public void quit() {
        this.doNotShowFrame();
        this.clearAll();
        this.clearData();
        for (int i1 = 0; i1 < this.N1final; ++i1) {
            for (int i2 = 0; i2 < this.N2final; ++i2) {
                this.title[i1][i2] = null;
                this.titleX[i1][i2] = null;
                this.titleY[i1][i2] = null;
                this.chart[i1][i2] = null;
                this.cp[i1][i2] = null;
            }
        }
        this.chart = null;
        this.cp = null;
        this.removeFrame();
    }

    public void doc() {
        String a = this.getClass().getName();
        a = a.replace(".", "/") + ".html";
        new HelpBrowser("https://datamelt.org/api/doc.php/" + a);
    }

    @Override
    protected void quitFrame() {
        this.close();
    }

    @Override
    protected void showHelp() {
    }

    @Override
    protected void openReadDataDialog() {
        JOptionPane.showMessageDialog(this.getFrame(), "Not implemented for this canvas");
    }

    private Stroke getStrokes(int type, float width, float dash) {
        float[][] pattern = new float[][]{{dash}, {dash, dash}, {dash, dash, dash * 0.3f, dash}, {dash * 0.3f, dash * 2.0f}};
        if (type == 0) {
            return new BasicStroke(width, 0, 0, 10.0f);
        }
        if (type == 1) {
            return new BasicStroke(width, 0, 0, 10.0f, pattern[1], 0.0f);
        }
        if (type == 2) {
            return new BasicStroke(width, 0, 0, 10.0f, pattern[2], 0.0f);
        }
        if (type == 3) {
            return new BasicStroke(width, 1, 0, 10.0f, pattern[3], 0.0f);
        }
        return new BasicStroke(width, 0, 0, 10.0f);
    }

    private Shape getShape(int index, float size) {
        double x = -0.5 * (double)size;
        if (index == 0) {
            return new Ellipse2D.Double(x, x, size, size);
        }
        if (index == 1) {
            return new Rectangle2D.Double(x, x, size, size);
        }
        if (index == 2) {
            return ShapeUtilities.createDiamond((float)size);
        }
        if (index == 3) {
            return ShapeUtilities.createDownTriangle((float)size);
        }
        if (index == 4) {
            return new Ellipse2D.Double(x, x, size, size);
        }
        if (index == 5) {
            return new Rectangle2D.Double(x, x, size, size);
        }
        if (index == 6) {
            return ShapeUtilities.createDiamond((float)size);
        }
        if (index == 7) {
            return ShapeUtilities.createDownTriangle((float)size);
        }
        if (index == 7) {
            return ShapeUtilities.createRegularCross((float)0.0f, (float)size);
        }
        if (index == 8) {
            return ShapeUtilities.createDiagonalCross((float)0.0f, (float)size);
        }
        if (index == 9) {
            return ShapeUtilities.createDiagonalCross((float)0.0f, (float)size);
        }
        if (index == 10) {
            return ShapeUtilities.createDiagonalCross((float)0.0f, (float)size);
        }
        if (index == 11) {
            new Ellipse2D.Double(0.5, 0.5, 1.0, 1.0);
        }
        if (index == 12) {
            return ShapeUtilities.createDiagonalCross((float)0.0f, (float)size);
        }
        return new Ellipse2D.Double(x, x, size, size);
    }

    public void drawToGraphics2D(Graphics2D g, int width, int height) {
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        int cols = this.N1final;
        int rows = this.N2final;
        int boxWidth = width / cols;
        int boxHeight = height / rows;
        int currentChartIndex = 0;
        for (int i2 = 0; i2 < rows; ++i2) {
            for (int i1 = 0; i1 < cols; ++i1) {
                ++currentChartIndex;
                if (this.chart[i1][i2] == null) continue;
                int rowsUsed = 1;
                boolean colsUsed = true;
                int chartX = boxWidth * i1;
                int chartY = boxHeight * i2;
                int chartwidth = boxWidth;
                int chartheight = boxHeight;
                chartwidth = boxWidth * rowsUsed;
                chartheight = boxHeight;
                this.chart[i1][i2].plotChanged(new PlotChangeEvent(this.chart[i1][i2].getPlot()));
                ChartRenderingInfo info = new ChartRenderingInfo();
                this.chart[i1][i2].draw(g, (Rectangle2D)new java.awt.Rectangle(chartX -= (rowsUsed - 1) * boxWidth, chartY, chartwidth, chartheight), (Point2D)new Point(chartX, chartY), info);
            }
        }
    }

    @Override
    public void export(String filename) {
        int calculatedWidth = this.getSizeX();
        int calculatedHeight = this.getSizeY();
        if (calculatedWidth <= 0) {
            calculatedWidth = 600;
        }
        if (calculatedHeight <= 0) {
            calculatedHeight = 400;
        }
        this.export(filename, calculatedWidth, calculatedHeight);
    }

    @Override
    protected void exportImage() {
        JFrame jm;
        JFileChooser fileChooser;
        if (this.isBorderShown()) {
            this.showBorders(false);
        }
        if ((fileChooser = CommonGUI.openImageFileChooser(jm = this.getFrame())).showDialog(jm, "Save As") == 0) {
            int res;
            final File scriptFile = fileChooser.getSelectedFile();
            if (scriptFile == null) {
                return;
            }
            if (scriptFile.exists() && (res = JOptionPane.showConfirmDialog(jm, "The file exists. Do you want to overwrite the file?", "", 0)) == 1) {
                return;
            }
            String mess = "write image  file ..";
            JHPlot.showStatusBarText(mess);
            Thread t = new Thread(mess){

                @Override
                public void run() {
                    HChart.this.export(scriptFile.getAbsolutePath());
                }
            };
            t.start();
        }
    }

    public void export(String filename, int width, int height) {
        block21: {
            String fname = filename;
            String filetype = "pdf";
            int i = filename.lastIndexOf(46);
            if (i > 0) {
                filetype = fname.substring(i + 1);
            }
            try {
                if (filetype.equalsIgnoreCase("png")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "png", new File(fname));
                    break block21;
                }
                if (filetype.equalsIgnoreCase("jpg") || filetype.equalsIgnoreCase("jpeg")) {
                    BufferedImage b = new BufferedImage(width, height, 1);
                    Graphics2D g = b.createGraphics();
                    this.drawToGraphics2D(g, width, height);
                    g.dispose();
                    ImageIO.write((RenderedImage)b, "jpg", new File(fname));
                    break block21;
                }
                if (filetype.equalsIgnoreCase("ps")) {
                    try {
                        ImageType currentImageType = ImageType.PS;
                        java.awt.Rectangle r = new java.awt.Rectangle(0, 0, width, height);
                        Export.exportComponent(this.getCanvasPanel(), r, new File(filename), currentImageType);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (TranscoderException e) {
                        e.printStackTrace();
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("eps")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        EpsGraphics2D g = new EpsGraphics2D("HChart canvas", (OutputStream)outputStream, 0, 0, width, height);
                        this.drawToGraphics2D((Graphics2D)g, width, height);
                        g.flush();
                        g.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Problem writing eps");
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("pdf")) {
                    try {
                        FileOutputStream outputStream = new FileOutputStream(fname);
                        DefaultFontMapper mapper = new DefaultFontMapper();
                        Rectangle pagesize = new Rectangle((float)width, (float)height);
                        Document document = new Document(pagesize, 50.0f, 50.0f, 50.0f, 50.0f);
                        try {
                            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
                            document.open();
                            PdfContentByte cb = writer.getDirectContent();
                            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                            Graphics2D g = tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
                            this.drawToGraphics2D(g, width, height);
                            g.dispose();
                            cb.addTemplate(tp, 0.0f, 0.0f);
                        }
                        catch (DocumentException de) {
                            System.err.println(de.getMessage());
                        }
                        document.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Cannot find itext library, cannot create pdf.");
                    }
                    break block21;
                }
                if (filetype.equalsIgnoreCase("svg")) {
                    try {
                        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
                        org.w3c.dom.Document document = domImpl.createDocument(null, "svg", null);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                        svgGenerator.setSVGCanvasSize(new Dimension(width, height));
                        svgGenerator.getGeneratorContext().setPrecision(6);
                        this.drawToGraphics2D((Graphics2D)svgGenerator, width, height);
                        boolean useCSS = true;
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filename)), "UTF-8");
                        svgGenerator.stream((Writer)out, useCSS);
                        ((Writer)out).close();
                    }
                    catch (DOMException e) {
                        System.err.println("Problem writing to SVG");
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Missing Batik libraries?");
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class Thread1
    implements Runnable {
        private Thread t = null;
        private String mess;

        Thread1(String s1) {
            this.mess = s1;
        }

        public boolean Alive() {
            boolean tt = false;
            if (this.t != null && this.t.isAlive()) {
                tt = true;
            }
            return tt;
        }

        public boolean Joint() {
            boolean tt = false;
            try {
                this.t.join();
                return true;
            }
            catch (InterruptedException interruptedException) {
                return tt;
            }
        }

        public void Start() {
            this.t = new Thread((Runnable)this, this.mess);
            this.t.start();
        }

        public void Stop() {
            this.t = null;
        }

        @Override
        public void run() {
            HChart.this.quit();
        }
    }
}

