/*
 * Decompiled with CFR 0.152.
 */
package jhplot;

import java.net.URL;
import jhplot.H1D;
import jhplot.P1D;
import jhplot.bsom.Bsom;
import jhplot.gui.HelpBrowser;

public class HBsom {
    public Bsom bsom = new Bsom();
    private int units = 0;
    private double alpha = 0.0;
    private double beta = 0.0;

    public void setNPoints(int units) {
        this.units = units;
    }

    public void setData(P1D p1d) {
        this.bsom.loadData(p1d);
        if (this.units == 0) {
            this.units = p1d.size();
        }
        if (this.alpha == 0.0 && this.beta == 0.0) {
            this.bsom.initPar(5000.0, 100.0, this.units);
        } else {
            this.bsom.initPar(this.alpha, this.beta, this.units);
        }
    }

    public void setData(H1D h) {
        P1D p1d = new P1D(h);
        this.bsom.loadData(p1d);
        if (this.units == 0) {
            this.units = p1d.size();
        }
        if (this.alpha == 0.0 && this.beta == 0.0) {
            this.bsom.initPar(5000.0, 100.0, this.units);
        } else {
            this.bsom.initPar(this.alpha, this.beta, this.units);
        }
    }

    public void doc() {
        URL url = this.bsom.getClass().getResource("doc/readme.html");
        new HelpBrowser(url);
    }

    public void setAlphaBeta(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public P1D getResult() {
        return this.bsom.outputWeightP1D();
    }

    public void run() {
        this.bsom.learn();
        this.bsom.auto();
        this.bsom.startNoThread();
    }

    public void visible(boolean vis) {
        if (vis) {
            this.bsom.init(this.units);
            this.bsom.start();
            this.bsom.pack();
            this.bsom.setVisible(true);
        } else {
            this.bsom.setVisible(false);
        }
    }

    public void setDelta(double delta) {
        this.bsom.setDelta(delta);
    }

    public double getDelta() {
        return this.bsom.getDelta();
    }

    public int getNiterations() {
        return this.bsom.getNiterations();
    }

    public double getAlpha() {
        return this.bsom.getAlpha();
    }

    public double getBeta() {
        return this.bsom.getBeta();
    }

    public void visible() {
        this.visible(true);
    }
}

