/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Graph2D;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;

class Range
extends Frame {
    Graph2D g2d = null;
    private Label xminLabel = new Label("Xmin");
    private Label yminLabel = new Label("Ymin");
    private Label xmaxLabel = new Label("Xmax");
    private Label ymaxLabel = new Label("Ymax");
    private TextField xminText = new TextField(20);
    private TextField yminText = new TextField(20);
    private TextField xmaxText = new TextField(20);
    private TextField ymaxText = new TextField(20);
    private Button cancel = new Button("Cancel");
    private Button done = new Button("Done");

    public Range(Graph2D g) {
        this.g2d = g;
        this.setLayout(new GridLayout(5, 2, 5, 10));
        this.xminLabel.setAlignment(0);
        this.xmaxLabel.setAlignment(0);
        this.yminLabel.setAlignment(0);
        this.ymaxLabel.setAlignment(0);
        this.add("xminLabel", this.xminLabel);
        this.add("xminText", this.xminText);
        this.add("xmaxLabel", this.xmaxLabel);
        this.add("xmaxText", this.xmaxText);
        this.add("yminLabel", this.yminLabel);
        this.add("yminText", this.yminText);
        this.add("ymaxLabel", this.ymaxLabel);
        this.add("ymaxText", this.ymaxText);
        this.add("cancel", this.cancel);
        this.cancel.setBackground(Color.red);
        this.add("done", this.done);
        this.done.setBackground(Color.green);
        this.resize(250, 250);
        super.setTitle("Set Plot Range");
    }

    public Double getXmin() {
        try {
            return Double.valueOf(this.xminText.getText());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Double getXmax() {
        try {
            return Double.valueOf(this.xmaxText.getText());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Double getYmin() {
        try {
            return Double.valueOf(this.yminText.getText());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Double getYmax() {
        try {
            return Double.valueOf(this.ymaxText.getText());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void resize(int x, int y) {
        super.resize(x, y);
    }

    @Override
    public void requestFocus() {
        this.xminText.requestFocus();
    }

    @Override
    public boolean keyDown(Event e, int key) {
        if (e.target instanceof TextField && (key == 10 || e.key == 13)) {
            if (this.xminText.equals(e.target)) {
                this.xmaxText.requestFocus();
                return true;
            }
            if (this.xmaxText.equals(e.target)) {
                this.yminText.requestFocus();
                return true;
            }
            if (this.yminText.equals(e.target)) {
                this.ymaxText.requestFocus();
                return true;
            }
            if (this.ymaxText.equals(e.target)) {
                this.xminText.requestFocus();
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean action(Event e, Object a) {
        if (e.target instanceof Button) {
            if (this.done.equals(e.target) && this.g2d != null) {
                this.g2d.deliverEvent(new Event(this, 1001, this));
                this.hide();
                return true;
            }
            if (this.cancel.equals(e.target)) {
                this.hide();
                return true;
            }
        }
        return false;
    }
}

