/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.Graph2D;
import java.applet.Applet;
import java.io.InputStream;
import java.net.URL;

public class LoadData
extends Thread {
    public final int NUMERIC = 1;
    public final int OBJECT = 2;
    private Graph2D graph = null;
    private Applet applet = null;
    private URL file;
    private int Max = 250;
    private DataSet ds = null;
    private double[] array = null;
    private boolean finished = false;
    private boolean started = false;
    private int count = 0;
    private int dataType = 1;

    public LoadData() {
        this.finished = false;
        this.started = false;
    }

    public LoadData(DataSet d) {
        this.ds = d;
        this.finished = false;
        this.started = false;
    }

    public DataSet loadDataSet(URL file) {
        if (file == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = file;
        this.start();
        return this.ds;
    }

    public void loadArray(URL file) {
        if (file == null) {
            return;
        }
        this.file = file;
        this.start();
    }

    public DataSet loadDataSet(URL file, Object drawable) {
        if (file == null) {
            return null;
        }
        if (this.ds == null) {
            this.ds = new DataSet();
        }
        this.file = file;
        if (drawable != null) {
            if (drawable instanceof Applet) {
                this.applet = (Applet)drawable;
            } else if (drawable instanceof Graph2D) {
                this.graph = (Graph2D)drawable;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
        return this.ds;
    }

    public void loadArray(URL file, Object drawable) {
        if (file == null) {
            return;
        }
        this.file = file;
        if (drawable != null) {
            if (drawable instanceof Applet) {
                this.applet = (Applet)drawable;
            } else if (drawable instanceof Graph2D) {
                this.graph = (Graph2D)drawable;
                this.graph.attachDataSet(this.ds);
            }
        }
        this.start();
    }

    @Override
    public void run() {
        int datamax = 2 * this.Max;
        byte[] b = new byte[50];
        int nbytes = 0;
        double[] data = new double[datamax];
        int size = 0;
        InputStream is = null;
        boolean comment = false;
        this.setPriority(1);
        try {
            int c;
            is = this.file.openStream();
            this.started = true;
            this.count = 0;
            if (this.graph != null) {
                this.graph.startedloading();
            }
            block7: while ((c = is.read()) > -1) {
                switch (c) {
                    case 35: {
                        comment = true;
                        continue block7;
                    }
                    case 10: 
                    case 13: {
                        comment = false;
                    }
                    case 9: 
                    case 32: {
                        if (nbytes <= 0) continue block7;
                        String s = new String(b, 0, 0, nbytes);
                        data[size] = Double.valueOf(s);
                        if (++size >= datamax) {
                            this.append(data, size);
                            size = 0;
                            System.out.println("Loading Data! Points Loaded " + this.count);
                        }
                        nbytes = 0;
                        continue block7;
                    }
                }
                if (comment) continue;
                b[nbytes] = (byte)c;
                ++nbytes;
            }
            if (size > 1) {
                this.append(data, size);
            }
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            this.printmessage("Error loading data!");
            return;
        }
        this.started = false;
        this.finished = true;
        if (this.graph != null) {
            this.graph.finishedloading();
        }
        if (this.count == 0) {
            this.printmessage("Zero data loaded!");
            return;
        }
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public synchronized double[] getArray() {
        if (this.array == null || this.array.length == 0) {
            return null;
        }
        if (this.finished) {
            return this.array;
        }
        if (this.started) {
            double[] tmp = new double[this.array.length];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            return tmp;
        }
        return null;
    }

    public boolean started() {
        return this.started;
    }

    public boolean finished() {
        return this.finished;
    }

    public int length() {
        return this.count;
    }

    private synchronized void append(double[] data, int size) {
        if (size == 0) {
            return;
        }
        this.count += size;
        if (this.ds != null) {
            try {
                this.ds.append(data, size / 2);
            }
            catch (Exception e) {
                this.printmessage("Failed to append data to DataSet!");
            }
        } else if (this.array != null) {
            double[] tmp = new double[this.array.length + size];
            System.arraycopy(this.array, 0, tmp, 0, size);
            System.arraycopy(data, 0, tmp, this.array.length, size);
            this.array = tmp;
        } else {
            this.array = new double[size];
            System.arraycopy(data, 0, this.array, 0, size);
        }
    }

    private void printmessage(String s) {
        if (s == null) {
            return;
        }
        if (this.applet != null) {
            this.applet.showStatus(s);
        }
        System.out.println(s);
    }
}

