/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.DataSet;
import graph.Graph2D;
import graph.RTextLine;
import graph.SpecialFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;

public class Axis {
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    static final int NUMBER_OF_TICS = 4;
    public boolean drawgrid = false;
    public boolean drawzero = false;
    public Color gridcolor = null;
    public Color zerocolor = null;
    public boolean redraw = true;
    public boolean force_end_labels = false;
    public int major_tic_size = 10;
    public int minor_tic_size = 5;
    public int minor_tic_count = 1;
    public Color axiscolor;
    public double minimum;
    public double maximum;
    public Dimension data_window = new Dimension(0, 0);
    public Graph2D g2d = null;
    protected Point amin;
    protected Point amax;
    protected int orientation;
    protected int position;
    protected int width = 0;
    protected RTextLine title = new RTextLine();
    protected RTextLine label = new RTextLine("0");
    protected RTextLine exponent = new RTextLine();
    protected int max_label_width = 0;
    protected Vector dataset = new Vector();
    protected String[] label_string = null;
    protected float[] label_value = null;
    protected double label_start = 0.0;
    protected double label_step = 0.0;
    protected int label_exponent = 0;
    protected int label_count = 0;
    protected int guess_label_number = 4;
    protected boolean manualRange = false;

    public Axis() {
        this.orientation = 0;
        this.position = 5;
    }

    public Axis(int p) {
        this.setPosition(p);
        switch (this.position) {
            case 1: 
            case 2: {
                this.title.setRotation(90);
                break;
            }
            case 3: {
                this.title.setRotation(-90);
                break;
            }
            default: {
                this.title.setRotation(0);
            }
        }
    }

    public void setPosition(int p) {
        this.position = p;
        switch (this.position) {
            case 2: {
                this.orientation = 1;
                break;
            }
            case 3: {
                this.orientation = 1;
                break;
            }
            case 4: {
                this.orientation = 0;
                break;
            }
            case 5: {
                this.orientation = 0;
                break;
            }
            case 0: {
                this.orientation = 0;
                this.position = 5;
                break;
            }
            case 1: {
                this.orientation = 1;
                this.position = 2;
                break;
            }
            default: {
                this.orientation = 0;
                this.position = 5;
            }
        }
    }

    public void attachDataSet(DataSet d) {
        if (this.orientation == 0) {
            this.attachXdata(d);
        } else {
            this.attachYdata(d);
        }
    }

    public void detachDataSet(DataSet d) {
        boolean i = false;
        if (d == null) {
            return;
        }
        if (this.orientation == 0) {
            d.xaxis = null;
        } else {
            d.yaxis = null;
        }
        this.dataset.removeElement(d);
        if (!this.manualRange) {
            this.resetRange();
        }
    }

    public void detachAll() {
        if (this.dataset.isEmpty()) {
            return;
        }
        if (this.orientation == 0) {
            for (int i = 0; i < this.dataset.size(); ++i) {
                DataSet d = (DataSet)this.dataset.elementAt(i);
                d.xaxis = null;
            }
        } else {
            for (int i = 0; i < this.dataset.size(); ++i) {
                DataSet d = (DataSet)this.dataset.elementAt(i);
                d.yaxis = null;
            }
        }
        this.dataset.removeAllElements();
        this.minimum = 0.0;
        this.maximum = 0.0;
    }

    public double getDataMin() {
        double m;
        if (this.dataset.isEmpty()) {
            return 0.0;
        }
        DataSet d = (DataSet)this.dataset.firstElement();
        if (d == null) {
            return 0.0;
        }
        if (this.orientation == 0) {
            m = d.getXmin();
            Enumeration e = this.dataset.elements();
            while (e.hasMoreElements()) {
                d = (DataSet)e.nextElement();
                m = Math.min(d.getXmin(), m);
            }
        } else {
            m = d.getYmin();
            Enumeration e = this.dataset.elements();
            while (e.hasMoreElements()) {
                d = (DataSet)e.nextElement();
                m = Math.min(d.getYmin(), m);
            }
        }
        return m;
    }

    public double getDataMax() {
        double m;
        if (this.dataset.isEmpty()) {
            return 0.0;
        }
        DataSet d = (DataSet)this.dataset.firstElement();
        if (d == null) {
            return 0.0;
        }
        if (this.orientation == 0) {
            m = d.getXmax();
            Enumeration e = this.dataset.elements();
            while (e.hasMoreElements()) {
                d = (DataSet)e.nextElement();
                m = Math.max(d.getXmax(), m);
            }
        } else {
            m = d.getYmax();
            Enumeration e = this.dataset.elements();
            while (e.hasMoreElements()) {
                d = (DataSet)e.nextElement();
                m = Math.max(d.getYmax(), m);
            }
        }
        return m;
    }

    public int getInteger(double v) {
        if (this.orientation == 0) {
            double scale = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
            return this.amin.x + (int)((v - this.minimum) * scale);
        }
        double scale = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        return this.amin.y + (int)((this.maximum - v) * scale);
    }

    public double getDouble(int i) {
        if (this.orientation == 0) {
            double scale = (this.maximum - this.minimum) / (double)(this.amax.x - this.amin.x);
            return this.minimum + (double)(i - this.amin.x) * scale;
        }
        double scale = (this.maximum - this.minimum) / (double)(this.amax.y - this.amin.y);
        return this.maximum - (double)(i - this.amin.y) * scale;
    }

    public void resetRange() {
        this.minimum = this.getDataMin();
        this.maximum = this.getDataMax();
    }

    public int getAxisPos() {
        return this.position;
    }

    public boolean isVertical() {
        return this.orientation != 0;
    }

    public int getAxisWidth(VectorGraphics g) {
        this.width = 0;
        if (this.minimum == this.maximum) {
            return 0;
        }
        if (this.dataset.size() == 0) {
            return 0;
        }
        this.calculateGridLabels();
        this.exponent.setText(null);
        if (this.label_exponent != 0) {
            this.exponent.copyState(this.label);
            this.exponent.setText("x10^" + String.valueOf(this.label_exponent));
        }
        if (this.orientation == 0) {
            this.width = this.label.getRHeight(g) + this.label.getLeading((Graphics)g);
            this.width += Math.max(this.title.getRHeight(g), this.exponent.getRHeight(g));
        } else {
            for (int i = 0; i < this.label_string.length; ++i) {
                this.label.setText(" " + this.label_string[i]);
                this.width = Math.max(this.label.getRWidth(g), this.width);
            }
            this.max_label_width = this.width;
            this.width = 0;
            if (!this.title.isNull()) {
                this.width = Math.max(this.width, this.title.getRWidth(g) + this.title.charWidth((Graphics)g, ' '));
            }
            if (!this.exponent.isNull()) {
                this.width = Math.max(this.width, this.exponent.getRWidth(g) + this.exponent.charWidth((Graphics)g, ' '));
            }
            this.width += this.max_label_width;
        }
        return this.width;
    }

    public boolean positionAxis(int xmin, int xmax, int ymin, int ymax) {
        this.amin = null;
        this.amax = null;
        if (this.orientation == 0 && ymin != ymax) {
            return false;
        }
        if (this.orientation == 1 && xmin != xmax) {
            return false;
        }
        this.amin = new Point(xmin, ymin);
        this.amax = new Point(xmax, ymax);
        return true;
    }

    public void drawAxis(VectorGraphics g) {
        if (!this.redraw) {
            return;
        }
        if (this.minimum == this.maximum) {
            System.out.println("Axis: data minimum==maximum Trying to reset range!");
            this.resetRange();
            if (this.minimum == this.maximum) {
                System.out.println("Axis: Reseting Range failed!  Axis not drawn!");
                return;
            }
        }
        if (this.amin.equals(this.amax)) {
            return;
        }
        if (this.width == 0) {
            this.width = this.getAxisWidth(g);
        }
        VectorGraphics lg = g;
        if (this.force_end_labels) {
            this.minimum = this.label_start;
            this.maximum = this.minimum + (double)(this.label_count - 1) * this.label_step;
        }
        this.title.setDrawingComponent(this.g2d);
        this.label.setDrawingComponent(this.g2d);
        this.exponent.setDrawingComponent(this.g2d);
        if (this.orientation == 0) {
            this.drawHAxis(lg);
        } else {
            this.drawVAxis(lg);
        }
    }

    public void setTitleText(String s) {
        this.title.setText(s);
    }

    public void setTitleColor(Color c) {
        this.title.setColor(c);
    }

    public void setTitleFont(Font f) {
        this.title.setFont(f);
    }

    public void setTitleRotation(int a) {
        this.title.setRotation(a);
    }

    public void setLabelColor(Color c) {
        this.label.setColor(c);
    }

    public void setLabelFont(Font f) {
        this.label.setFont(f);
    }

    public void setExponentColor(Color c) {
        this.exponent.setColor(c);
    }

    public void setExponentFont(Font f) {
        this.exponent.setFont(f);
    }

    public void setManualRange(boolean b) {
        this.manualRange = b;
    }

    protected void drawHAxis(VectorGraphics g) {
        int x0;
        int y0;
        int i;
        double vmin = this.minimum * 1.001;
        double vmax = this.maximum * 1.001;
        double scale = (double)(this.amax.x - this.amin.x) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            g.setColor(this.axiscolor);
        }
        g.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        int direction = this.position == 4 ? 1 : -1;
        double minor_step = this.label_step / (double)(this.minor_tic_count + 1);
        double val = this.label_start;
        for (i = 0; i < this.label_count; ++i) {
            int y1;
            int x1;
            Color c;
            if (val >= vmin && val <= vmax) {
                y0 = this.amin.y;
                x0 = this.amin.x + (int)((val - this.minimum) * scale);
                if ((double)Math.abs(this.label_value[i]) <= 1.0E-4 && this.drawzero) {
                    c = g.getColor();
                    if (this.zerocolor != null) {
                        g.setColor(this.zerocolor);
                    }
                    g.drawLine(x0, y0, x0, y0 + this.data_window.height * direction);
                    g.setColor(c);
                } else if (this.drawgrid) {
                    c = g.getColor();
                    if (this.gridcolor != null) {
                        g.setColor(this.gridcolor);
                    }
                    g.drawLine(x0, y0, x0, y0 + this.data_window.height * direction);
                    g.setColor(c);
                }
                x1 = x0;
                y1 = y0 + this.major_tic_size * direction;
                g.drawLine(x0, y0, x1, y1);
            }
            double minor = val + minor_step;
            for (int j = 0; j < this.minor_tic_count; ++j) {
                if (minor >= vmin && minor <= vmax) {
                    y0 = this.amin.y;
                    x0 = this.amin.x + (int)((minor - this.minimum) * scale);
                    if (this.drawgrid) {
                        c = g.getColor();
                        if (this.gridcolor != null) {
                            g.setColor(this.gridcolor);
                        }
                        g.drawLine(x0, y0, x0, y0 + this.data_window.height * direction);
                        g.setColor(c);
                    }
                    x1 = x0;
                    y1 = y0 + this.minor_tic_size * direction;
                    g.drawLine(x0, y0, x1, y1);
                }
                minor += minor_step;
            }
            val += this.label_step;
        }
        int offset = this.position == 4 ? -this.label.getLeading((Graphics)g) - this.label.getDescent((Graphics)g) : this.label.getLeading((Graphics)g) + this.label.getAscent((Graphics)g);
        val = this.label_start;
        for (i = 0; i < this.label_count; ++i) {
            if (val >= vmin && val <= vmax) {
                y0 = this.amin.y + offset;
                x0 = this.amin.x + (int)((val - this.minimum) * scale);
                this.label.setText(this.label_string[i]);
                this.label.draw(g, x0, y0, 0);
            }
            val += this.label_step;
        }
        if (!this.exponent.isNull()) {
            y0 = this.position == 4 ? this.amin.y - this.label.getLeading((Graphics)g) - this.label.getDescent((Graphics)g) - this.exponent.getLeading((Graphics)g) - this.exponent.getDescent((Graphics)g) : this.amax.y + this.label.getLeading((Graphics)g) + this.label.getAscent((Graphics)g) + this.exponent.getLeading((Graphics)g) + this.exponent.getAscent((Graphics)g);
            x0 = this.amax.x;
            this.exponent.draw(g, x0, y0, 1);
        }
        if (!this.title.isNull()) {
            y0 = this.position == 4 ? this.amin.y - this.label.getLeading((Graphics)g) - this.label.getDescent((Graphics)g) - this.title.getLeading((Graphics)g) - this.title.getDescent((Graphics)g) : this.amax.y + this.label.getLeading((Graphics)g) + this.label.getAscent((Graphics)g) + this.title.getLeading((Graphics)g) + this.title.getAscent((Graphics)g);
            x0 = this.amin.x + (this.amax.x - this.amin.x) / 2;
            this.title.draw(g, x0, y0, 0);
        }
    }

    protected void drawVAxis(VectorGraphics g) {
        int y0;
        int x0;
        int i;
        int offset = 0;
        Color gc = g.getColor();
        Font gf = g.getFont();
        double vmin = this.minimum * 1.001;
        double vmax = this.maximum * 1.001;
        double scale = (double)(this.amax.y - this.amin.y) / (this.maximum - this.minimum);
        if (this.axiscolor != null) {
            g.setColor(this.axiscolor);
        }
        g.drawLine(this.amin.x, this.amin.y, this.amax.x, this.amax.y);
        int direction = this.position == 3 ? -1 : 1;
        double minor_step = this.label_step / (double)(this.minor_tic_count + 1);
        double val = this.label_start;
        for (i = 0; i < this.label_count; ++i) {
            int y1;
            int x1;
            Color c;
            if (val >= vmin && val <= vmax) {
                x0 = this.amin.x;
                y0 = this.amax.y - (int)((val - this.minimum) * scale);
                if ((double)Math.abs(this.label_value[i]) <= 1.0E-4 && this.drawzero) {
                    c = g.getColor();
                    if (this.zerocolor != null) {
                        g.setColor(this.zerocolor);
                    }
                    g.drawLine(x0, y0, x0 + this.data_window.width * direction, y0);
                    g.setColor(c);
                } else if (this.drawgrid) {
                    c = g.getColor();
                    if (this.gridcolor != null) {
                        g.setColor(this.gridcolor);
                    }
                    g.drawLine(x0, y0, x0 + this.data_window.width * direction, y0);
                    g.setColor(c);
                }
                x1 = x0 + this.major_tic_size * direction;
                y1 = y0;
                g.drawLine(x0, y0, x1, y1);
            }
            double minor = val + minor_step;
            for (int j = 0; j < this.minor_tic_count; ++j) {
                if (minor >= vmin && minor <= vmax) {
                    x0 = this.amin.x;
                    y0 = this.amax.y - (int)((minor - this.minimum) * scale);
                    if (this.drawgrid) {
                        c = g.getColor();
                        if (this.gridcolor != null) {
                            g.setColor(this.gridcolor);
                        }
                        g.drawLine(x0, y0, x0 + this.data_window.width * direction, y0);
                        g.setColor(c);
                    }
                    x1 = x0 + this.minor_tic_size * direction;
                    y1 = y0;
                    g.drawLine(x0, y0, x1, y1);
                }
                minor += minor_step;
            }
            val += this.label_step;
        }
        val = this.label_start;
        for (i = 0; i < this.label_count; ++i) {
            if (val >= vmin && val <= vmax) {
                x0 = this.amin.x + offset;
                y0 = this.amax.y - (int)((val - this.minimum) * scale) + this.label.getAscent((Graphics)g) / 2;
                if (this.position == 3) {
                    this.label.setText(" " + this.label_string[i]);
                    this.label.draw(g, x0, y0, 1);
                } else {
                    this.label.setText(this.label_string[i] + " ");
                    this.label.draw(g, x0, y0, 2);
                }
            }
            val += this.label_step;
        }
        if (!this.exponent.isNull()) {
            y0 = this.amin.y;
            if (this.position == 3) {
                x0 = this.amin.x + this.max_label_width + this.exponent.charWidth((Graphics)g, ' ');
                this.exponent.draw(g, x0, y0, 1);
            } else {
                x0 = this.amin.x - this.max_label_width - this.exponent.charWidth((Graphics)g, ' ');
                this.exponent.draw(g, x0, y0, 2);
            }
        }
        if (!this.title.isNull()) {
            y0 = this.amin.y + (this.amax.y - this.amin.y) / 2;
            if (this.title.getRotation() == 0 || this.title.getRotation() == 180) {
                if (this.position == 3) {
                    x0 = this.amin.x + this.max_label_width + this.title.charWidth((Graphics)g, ' ');
                    this.title.draw(g, x0, y0, 1);
                } else {
                    x0 = this.amin.x - this.max_label_width - this.title.charWidth((Graphics)g, ' ');
                    this.title.draw(g, x0, y0, 2);
                }
            } else {
                this.title.setJustification(0);
                x0 = this.position == 3 ? this.amin.x + this.max_label_width - this.title.getLeftEdge(g) + this.title.charWidth((Graphics)g, ' ') : this.amin.x - this.max_label_width - this.title.getRightEdge(g) - this.title.charWidth((Graphics)g, ' ');
                this.title.draw(g, x0, y0);
            }
        }
    }

    protected void attachXdata(DataSet d) {
        this.dataset.addElement(d);
        d.xaxis = this;
        if (this.dataset.size() == 1) {
            this.minimum = d.dxmin;
            this.maximum = d.dxmax;
        } else {
            if (this.minimum > d.dxmin) {
                this.minimum = d.dxmin;
            }
            if (this.maximum < d.dxmax) {
                this.maximum = d.dxmax;
            }
        }
    }

    protected void attachYdata(DataSet d) {
        this.dataset.addElement(d);
        d.yaxis = this;
        if (this.dataset.size() == 1) {
            this.minimum = d.dymin;
            this.maximum = d.dymax;
        } else {
            if (this.minimum > d.dymin) {
                this.minimum = d.dymin;
            }
            if (this.maximum < d.dymax) {
                this.maximum = d.dymax;
            }
        }
    }

    protected void calculateGridLabels() {
        this.label_exponent = Math.abs(this.minimum) > Math.abs(this.maximum) ? (int)Math.floor(SpecialFunction.log10(Math.abs(this.minimum)) / 3.0) * 3 : (int)Math.floor(SpecialFunction.log10(Math.abs(this.maximum)) / 3.0) * 3;
        this.label_step = this.RoundUp((this.maximum - this.minimum) / (double)this.guess_label_number);
        double val = this.label_start = Math.floor(this.minimum / this.label_step) * this.label_step;
        this.label_count = 1;
        while (val < this.maximum) {
            val += this.label_step;
            ++this.label_count;
        }
        this.label_string = new String[this.label_count];
        this.label_value = new float[this.label_count];
        for (int i = 0; i < this.label_count; ++i) {
            int j;
            val = this.label_start + (double)i * this.label_step;
            if (this.label_exponent < 0) {
                for (j = this.label_exponent; j < 0; ++j) {
                    val *= 10.0;
                }
            } else {
                for (j = 0; j < this.label_exponent; ++j) {
                    val /= 10.0;
                }
            }
            this.label_string[i] = String.valueOf(val);
            this.label_value[i] = (float)val;
        }
    }

    private double RoundUp(double val) {
        int i;
        int exponent = (int)Math.floor(SpecialFunction.log10(val));
        if (exponent < 0) {
            for (i = exponent; i < 0; ++i) {
                val *= 10.0;
            }
        } else {
            for (i = 0; i < exponent; ++i) {
                val /= 10.0;
            }
        }
        val = val > 5.0 ? 10.0 : (val > 2.0 ? 5.0 : (val > 1.0 ? 2.0 : 1.0));
        if (exponent < 0) {
            for (i = exponent; i < 0; ++i) {
                val /= 10.0;
            }
        } else {
            for (i = 0; i < exponent; ++i) {
                val *= 10.0;
            }
        }
        return val;
    }
}

