/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.rungeKutta;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsTabPanel;
import jv.project.PjProject_IP;
import vgp.vector.rungeKutta.PjRungeKutta;

public class PjRungeKutta_IP
extends PjProject_IP
implements ActionListener,
ItemListener {
    protected PjRungeKutta m_pjRungeKutta;
    protected PsTabPanel m_tabPanel;
    protected PsPanel m_pIntegral;
    protected PsPanel m_pAllVec;
    protected Panel m_pLicSize;
    protected Label m_lLicTime;
    protected Button m_bLicCalc;
    protected Checkbox m_cProj;
    protected Checkbox m_cGeod;
    protected Checkbox m_cGeod2;
    protected Checkbox m_cGeod3;
    protected CheckboxGroup m_cgType;
    protected Checkbox m_cFast;
    protected Checkbox m_cRedraw;
    static /* synthetic */ Class class$vgp$vector$rungeKutta$PjRungeKutta_IP;

    public PjRungeKutta_IP() {
        if (this.getClass() == (class$vgp$vector$rungeKutta$PjRungeKutta_IP == null ? (class$vgp$vector$rungeKutta$PjRungeKutta_IP = PjRungeKutta_IP.class$("vgp.vector.rungeKutta.PjRungeKutta_IP")) : class$vgp$vector$rungeKutta$PjRungeKutta_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addNotice(this.getNotice());
        this.m_pAllVec = new PsPanel();
        this.m_pIntegral = new PsPanel();
        PsPanel psPanel = new PsPanel((LayoutManager)new GridLayout(1, 2));
        psPanel.addSubTitle("Integration");
        this.m_cFast = new Checkbox("Fast mode (Euler)", false);
        this.m_cFast.addItemListener(this);
        psPanel.add(this.m_cFast);
        this.m_pIntegral.add((Component)psPanel);
        PsPanel psPanel2 = new PsPanel((LayoutManager)new GridLayout(2, 2));
        this.m_cgType = new CheckboxGroup();
        this.m_cProj = new Checkbox("Projection", this.m_cgType, true);
        this.m_cProj.addItemListener(this);
        psPanel2.add(this.m_cProj);
        this.m_cGeod2 = new Checkbox("Geod. transl. (angle/2)", this.m_cgType, false);
        this.m_cGeod2.addItemListener(this);
        psPanel2.add(this.m_cGeod2);
        this.m_cGeod = new Checkbox("Geodesic completion", this.m_cgType, false);
        this.m_cGeod.addItemListener(this);
        psPanel2.add(this.m_cGeod);
        this.m_cGeod3 = new Checkbox("Geod. transl. (cont.)", this.m_cgType, false);
        this.m_cGeod3.addItemListener(this);
        psPanel2.add(this.m_cGeod3);
        this.m_pIntegral.add((Component)psPanel2);
        this.m_pAllVec.add((Component)this.m_pIntegral);
        this.m_pAllVec.addLine(1);
        psPanel = new PsPanel();
        psPanel2 = new PsPanel((LayoutManager)new GridLayout(1, 2));
        psPanel2.addSubTitle("LIC Visualization");
        this.m_cRedraw = new Checkbox("Enable Redraw", false);
        this.m_cRedraw.addItemListener(this);
        psPanel2.add(this.m_cRedraw);
        psPanel.add((Component)psPanel2);
        this.m_pLicSize = new PsPanel();
        psPanel.add(this.m_pLicSize);
        Panel panel = new Panel(new GridLayout(1, 2));
        this.m_lLicTime = new Label("LIC Time: --");
        panel.add(this.m_lLicTime);
        this.m_bLicCalc = new Button("Calculate Lic Texture");
        this.m_bLicCalc.addActionListener(this);
        panel.add(this.m_bLicCalc);
        psPanel.add(panel);
        this.m_pAllVec.add((Component)psPanel);
        this.m_tabPanel = new PsTabPanel();
        this.m_tabPanel.addPanel("Runge-Kutta", this.m_pAllVec);
        ((Container)((Object)this)).add((Component)this.m_tabPanel);
    }

    public String getNotice() {
        String string = "Demo computes integral curves of a vector field using various geodesic Runge-Kutta method. Press 'i' and pick initial point of integral line.";
        return string;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.setTitle(psUpdateIf.getName());
        this.m_pjRungeKutta = (PjRungeKutta)psUpdateIf;
        this.m_pjRungeKutta.m_bLicCalc = this.m_bLicCalc;
        this.m_pIntegral.add((Component)this.m_pjRungeKutta.m_length.assureInspector("Info", "_IP"));
        this.m_pIntegral.add((Component)this.m_pjRungeKutta.m_discr.assureInspector("Info", "_IP"));
        this.m_pIntegral.validate();
        this.m_pLicSize.add((Component)this.m_pjRungeKutta.m_LICSize.assureInspector("Info", "_IP"));
        PjProject_IP pjProject_IP = (PjProject_IP)this.m_pjRungeKutta.m_import.getInfoPanel();
        pjProject_IP.removeTitle();
        pjProject_IP.removeNotice();
        pjProject_IP.setBorderType(0);
        this.m_tabPanel.addPanel("Models", (PsPanel)pjProject_IP);
        this.m_tabPanel.setVisible("Runge-Kutta");
        ((Container)((Object)this)).validate();
    }

    public boolean update(Object object) {
        if (this.m_pjRungeKutta == null) {
            PsDebug.warning((String)"missing project");
            return false;
        }
        if (object == this.m_pjRungeKutta) {
            PsPanel.setState((Checkbox)this.m_cFast, (boolean)this.m_pjRungeKutta.isEnabledFast());
            PsPanel.setText((Label)this.m_lLicTime, (String)("LIC Time: " + String.valueOf(this.m_pjRungeKutta.getTime()) + " ms"));
            PsPanel.setState((Checkbox)this.m_cRedraw, (boolean)this.m_pjRungeKutta.m_bRedraw);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bLicCalc) {
            if (!this.m_pjRungeKutta.isRunning()) {
                this.m_bLicCalc.setLabel("Preparing Lic ...");
                this.m_pjRungeKutta.startLIC();
            } else {
                this.m_pjRungeKutta.stopLIC();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (this.m_pjRungeKutta == null) {
            PsDebug.warning((String)"missing parent project");
            return;
        }
        if (itemEvent.getSource() == this.m_cProj) {
            this.m_pjRungeKutta.setMethod(1);
        } else if (object == this.m_cGeod) {
            this.m_pjRungeKutta.setMethod(2);
        } else if (object == this.m_cGeod2) {
            this.m_pjRungeKutta.setMethod(3);
        } else if (object == this.m_cGeod3) {
            this.m_pjRungeKutta.setMethod(4);
        } else if (object == this.m_cFast) {
            this.m_pjRungeKutta.setEnabledFast(this.m_cFast.getState());
        } else {
            if (object == this.m_cRedraw) {
                this.m_pjRungeKutta.m_bRedraw = this.m_cRedraw.getState();
                return;
            }
            return;
        }
        this.m_pjRungeKutta.update(this.m_pjRungeKutta);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

