/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.moebiusTransformation;

import java.awt.Color;
import jv.function.PuComplexFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuComplex;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwTexture;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;

public class PjMoebiusTransformation
extends PjProject {
    protected PgDomain m_domain;
    protected PgElementSet m_image;
    protected PuComplexFunction m_function;
    protected static String m_defExpression = "(a*z+b)/(c*z+d)";
    protected PuComplex[] m_z;
    protected PuComplex[] m_w;
    protected PgPointSet m_zPoints;
    protected PgPointSet m_wPoints;
    static /* synthetic */ Class class$vgp$surface$moebiusTransformation$PjMoebiusTransformation;

    public PjMoebiusTransformation() {
        super("Moebius Transformation");
        int n = 2;
        this.m_domain = new PgDomain(n);
        this.m_domain.setName("Domain of Graph");
        this.m_domain.setVisible(true);
        this.m_domain.addUpdateListener((PsUpdateIf)this);
        this.m_domain.setDescr(new PgDomainDescr(n), 0);
        this.m_domain.setDescr(new PgDomainDescr(n), 1);
        this.m_image = new PgElementSet(2);
        this.m_function = new PuComplexFunction(1, 1);
        this.m_function.setParent((PsUpdateIf)this);
        this.m_z = new PuComplex[3];
        this.m_w = new PuComplex[3];
        this.m_zPoints = new PgPointSet(2);
        this.m_zPoints.setName("Domain Points");
        this.m_zPoints.setParent((PsUpdateIf)this);
        this.m_wPoints = new PgPointSet(2);
        this.m_wPoints.setName("Target Points");
        this.m_wPoints.setParent((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$moebiusTransformation$PjMoebiusTransformation == null ? (class$vgp$surface$moebiusTransformation$PjMoebiusTransformation = PjMoebiusTransformation.class$("vgp.surface.moebiusTransformation.PjMoebiusTransformation")) : class$vgp$surface$moebiusTransformation$PjMoebiusTransformation)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        PgDomainDescr pgDomainDescr = this.m_domain.getDescr(0);
        pgDomainDescr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        pgDomainDescr.setSize(-1.0, -1.0, 1.0, 1.0);
        pgDomainDescr.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr.setDiscr(20, 20);
        PgDomainDescr pgDomainDescr2 = this.m_domain.getDescr(1);
        pgDomainDescr2.setMaxSize(0.0, 0.0, 10.0, Math.PI * 2);
        pgDomainDescr2.setSize(0.0, 0.0, 1.0, Math.PI * 2);
        pgDomainDescr2.setDiscrBounds(2, 2, 50, 50);
        pgDomainDescr2.setDiscr(11, 43);
        this.m_domain.setDomainType(1);
        this.m_domain.init();
        this.m_domain.setName("Complex Domain");
        this.m_domain.setDimOfElements(4);
        this.m_domain.showElements(false);
        this.m_domain.makeVertexColorsFromXYZ();
        this.m_domain.showEdgeColorFromVertices(true);
        this.m_domain.showEdgeColors(true);
        this.m_domain.setGlobalEdgeColor(new Color(161, 161, 161));
        this.m_domain.setGlobalElementColor(Color.white);
        this.m_domain.setVisible(false);
        this.m_image.setName("Complex Map");
        this.m_image.copy((PsObject)this.m_domain);
        this.m_image.setGlobalEdgeColor(Color.gray);
        this.m_image.showElementColorFromVertices(true);
        this.m_image.showElementColors(true);
        this.m_function.setName("Moebius Transformation");
        this.setExpression(m_defExpression);
        this.m_z[0] = new PuComplex(-1.0, 0.0);
        this.m_z[1] = new PuComplex(0.0, -1.0);
        this.m_z[2] = new PuComplex(1.0, 0.0);
        this.m_w[0] = new PuComplex(-1.0, 0.0);
        this.m_w[1] = new PuComplex(0.0, -1.0);
        this.m_w[2] = new PuComplex(1.0, 0.0);
        this.m_zPoints.setNumVertices(3);
        this.m_zPoints.setGlobalVertexColor(Color.blue);
        this.m_zPoints.setGlobalVertexSize(3.0);
        this.m_zPoints.setVisible(true);
        this.m_wPoints.setNumVertices(3);
        this.m_wPoints.setGlobalVertexColor(Color.green);
        this.m_wPoints.setGlobalVertexSize(5.0);
        for (int i = 0; i < 3; ++i) {
            this.m_zPoints.setVertex(i, this.m_z[i].re(), this.m_z[i].im());
            this.m_wPoints.setVertex(i, this.m_w[i].re(), this.m_w[i].im());
        }
    }

    public void start() {
        String string;
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null && (string = pvViewerIf.getParameter("dev.cfun.PjMoebiusFunction#expression")) != null) {
            m_defExpression = string;
            this.setExpression(m_defExpression);
        }
        this.compute();
        this.addGeometry((PgGeometryIf)this.m_domain);
        this.addGeometry((PgGeometryIf)this.m_image);
        this.addGeometry((PgGeometryIf)this.m_zPoints);
        this.addGeometry((PgGeometryIf)this.m_wPoints);
        this.selectGeometry((PgGeometryIf)this.m_wPoints);
        string = this.getDisplay();
        if (string != null) {
            string.setBackgroundColor(new Color(155, 255, 255));
            string.showAxes(true);
            PgAxes pgAxes = ((PvDisplay)string).getAxes();
            pgAxes.setMode(3);
            pgAxes.setEnabledAutoBounds(false);
            if (!pgAxes.isEnabledAutoBounds()) {
                pgAxes.setBounds(this.m_domain.getBounds());
            }
            string.selectCamera(1);
        }
        string.setMajorMode(5);
        super.start();
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == this) {
            this.compute();
            this.setUpdateSender(true);
            this.m_domain.update((Object)this.m_domain);
            this.m_function.update((Object)this.m_function);
            this.m_image.update((Object)this.m_image);
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_function) {
            this.compute();
            this.m_image.update((Object)this.m_image);
            return super.update((Object)this);
        }
        if (object == this.m_domain) {
            PgAxes pgAxes = ((PvDisplay)this.getDisplay()).getAxes();
            if (!pgAxes.isEnabledAutoBounds()) {
                pgAxes.setBounds(this.m_domain.getBounds());
            }
            this.m_domain.makeVertexColorsFromXYZ();
            this.m_image.copy((PsObject)this.m_domain);
            this.compute();
            this.m_image.update((Object)this.m_image);
            return super.update((Object)this);
        }
        if (object == this.m_zPoints) {
            for (int i = 0; i < 3; ++i) {
                this.m_z[i].set(this.m_zPoints.getVertex(i));
            }
            this.compute();
            this.m_image.update((Object)this.m_image);
            return super.update((Object)this);
        }
        if (object == this.m_wPoints) {
            for (int i = 0; i < 3; ++i) {
                this.m_w[i].set(this.m_wPoints.getVertex(i));
            }
            this.compute();
            this.m_image.update((Object)this.m_image);
            return super.update((Object)this);
        }
        return false;
    }

    public void setExpression(String string) {
        this.m_function.setExpression(string);
    }

    public void compute() {
        int n = this.m_domain.getNumVertices();
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = PuComplex.moebius((PuComplex)this.m_z[1], (PuComplex)PuComplex.neg((PuComplex)this.m_z[2]), (PuComplex)this.m_z[1], (PuComplex)PuComplex.neg((PuComplex)this.m_z[0]), (PuComplex)PuComplex.ONE);
        PuComplex puComplex3 = PuComplex.moebius((PuComplex)this.m_w[1], (PuComplex)PuComplex.neg((PuComplex)this.m_w[2]), (PuComplex)this.m_w[1], (PuComplex)PuComplex.neg((PuComplex)this.m_w[0]), (PuComplex)PuComplex.ONE);
        for (int i = 0; i < n; ++i) {
            PuComplex puComplex4;
            puComplex.set(pdVectorArray[i].m_data[0], pdVectorArray[i].m_data[1]);
            if (PuComplex.equals((PuComplex)puComplex, (PuComplex)this.m_z[2], (double)1.0E-10)) {
                puComplex4 = this.m_w[2];
            } else {
                PuComplex puComplex5 = puComplex2;
                PuComplex puComplex6 = PuComplex.neg((PuComplex)PuComplex.mult((PuComplex)this.m_z[0], (PuComplex)puComplex2));
                PuComplex puComplex7 = PuComplex.ONE;
                PuComplex puComplex8 = PuComplex.neg((PuComplex)this.m_z[2]);
                PuComplex puComplex9 = PuComplex.moebius((PuComplex)puComplex5, (PuComplex)puComplex6, (PuComplex)puComplex7, (PuComplex)puComplex8, (PuComplex)puComplex);
                puComplex5 = PuComplex.neg((PuComplex)this.m_w[2]);
                puComplex6 = PuComplex.mult((PuComplex)this.m_w[0], (PuComplex)puComplex3);
                puComplex7 = PuComplex.neg((PuComplex)PuComplex.ONE);
                puComplex8 = puComplex3;
                puComplex4 = PuComplex.moebius((PuComplex)puComplex5, (PuComplex)puComplex6, (PuComplex)puComplex7, (PuComplex)puComplex8, (PuComplex)puComplex9);
            }
            this.m_image.setVertex(i, puComplex4.re, puComplex4.im);
        }
        PwTexture.makePatchTexture((PgElementSet)this.m_image);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

