/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Catalan
extends PgSurfaceDescr {
    private double m_defAngle = 1.5707963267948966;
    protected PuDouble m_angle;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_Catalan;

    public PgSurface_Catalan() {
        this.setName("Catalan Surface");
        this.m_angle = new PuDouble("Associate Family", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        this.m_function.setName("Coordinate Functions");
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Catalan == null ? (class$vgp$surface$common$PgSurface_Catalan = PgSurface_Catalan.class$("vgp.surface.common.PgSurface_Catalan")) : class$vgp$surface$common$PgSurface_Catalan)) {
            this.init();
        }
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 4 && this.m_angle.getValue() == 0.0;
    }

    public void init() {
        super.init();
        this.setSize(-Math.PI, -2.0, Math.PI * 3, 2.0);
        this.setDiscr(33, 17);
        this.m_angle.setDefBounds(0.0, 1.5707963267948966, 0.02, 0.1);
        this.m_angle.setDefValue(this.m_defAngle);
        this.m_angle.init();
        this.addParameter((PsObject)this.m_angle);
        this.m_function.setName("Coordinate Functions");
        this.m_function.setExpression(0, "sin(a)*(-cosh(v)*sin(u)+u-pi)+cos(a)*(-sinh(v)*cos(u)+v)");
        this.m_function.setExpression(1, "sin(a)*(-cosh(v)*cos(u))+cos(a)*(sinh(v)*sin(u))");
        this.m_function.setExpression(2, "sin(a)*(-sinh(v/2.)*sin(u/2.)*4.)+cos(a)*(-cosh(v/2.)*cos(u/2.)*4.+4.)");
        this.m_function.addParameter("a", this.m_angle.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean update(Object object) {
        if (object == this.m_angle) {
            this.m_function.setParameter("a", this.m_angle.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        pdVector2.set(-PuMath.cosh((double)d2) * Math.sin(d) + d - Math.PI, -PuMath.cosh((double)d2) * Math.cos(d), -PuMath.sinh((double)(d2 / 2.0)) * Math.sin(d / 2.0) * 4.0);
        pdVector3.set(-PuMath.sinh((double)d2) * Math.cos(d) + d2, PuMath.sinh((double)d2) * Math.sin(d), -PuMath.cosh((double)(d2 / 2.0)) * Math.cos(d / 2.0) * 4.0 + 4.0);
        pdVector.blend(Math.sin(this.m_angle.getValue()), pdVector2, Math.cos(this.m_angle.getValue()), pdVector3);
        return true;
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_angle.getValue();
        pdVector.set(Math.sin(d3) * (1.0 - Math.cos(d) * PuMath.cosh((double)d2)) + Math.cos(d3) * Math.sin(d) * PuMath.sinh((double)d2), Math.sin(d3) * Math.sin(d) * PuMath.cosh((double)d2) + Math.cos(d3) * Math.cos(d) * PuMath.sinh((double)d2), Math.sin(d3) * (-2.0 * Math.cos(d / 2.0) * PuMath.sinh((double)(d2 / 2.0))) + Math.cos(d3) * 2.0 * Math.sin(d / 2.0) * PuMath.cosh((double)(d2 / 2.0)));
        return pdVector;
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_angle.getValue();
        pdVector.set(-Math.sin(d3) * Math.sin(d) * PuMath.sinh((double)d2) - Math.cos(d3) * Math.cos(d) * PuMath.cosh((double)d2), -Math.sin(d3) * Math.cos(d) * PuMath.sinh((double)d2) + Math.cos(d3) * Math.sin(d) * PuMath.cosh((double)d2), -Math.sin(d3) * 2.0 * Math.sin(d / 2.0) * PuMath.cosh((double)(d2 / 2.0)) - Math.cos(d3) * 2.0 * Math.cos(d / 2.0) * PuMath.sinh((double)(d2 / 2.0)));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_angle.getValue();
        pdVector.set(Math.sin(d3) * Math.sin(d) * PuMath.cosh((double)d2) + Math.cos(d3) * Math.cos(d) * PuMath.sinh((double)d2), Math.sin(d3) * Math.cos(d) * PuMath.cosh((double)d2) - Math.cos(d3) * Math.sin(d) * PuMath.sinh((double)d2), Math.sin(d3) * Math.sin(d / 2.0) * PuMath.sinh((double)(d2 / 2.0)) + Math.cos(d3) * Math.cos(d / 2.0) * PuMath.cosh((double)(d2 / 2.0)));
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_angle.getValue();
        pdVector.set(-Math.sin(d3) * Math.sin(d) * PuMath.cosh((double)d2) - Math.cos(d3) * Math.cos(d) * PuMath.sinh((double)d2), -Math.sin(d3) * Math.cos(d) * PuMath.cosh((double)d2) + Math.cos(d3) * Math.sin(d) * PuMath.sinh((double)d2), -Math.sin(d3) * Math.sin(d / 2.0) * PuMath.sinh((double)(d2 / 2.0)) - Math.cos(d3) * Math.cos(d / 2.0) * PuMath.cosh((double)(d2 / 2.0)));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_angle.getValue();
        pdVector.set(-Math.sin(d3) * Math.cos(d) * PuMath.sinh((double)d2) + Math.cos(d3) * Math.sin(d) * PuMath.cosh((double)d2), Math.sin(d3) * Math.sin(d) * PuMath.sinh((double)d2) + Math.cos(d3) * Math.cos(d) * PuMath.cosh((double)d2), -Math.sin(d3) * Math.cos(d / 2.0) * PuMath.cosh((double)(d2 / 2.0)) + Math.cos(d3) * Math.sin(d / 2.0) * PuMath.sinh((double)(d2 / 2.0)));
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

