/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_PlanarEnd
extends PgWeierstrassDescr {
    private double m_defaultRadius = 0.3;
    private double m_defaultRadiusPlane = 1.5;
    private int m_defaultSymmetry = 2;
    protected PuDouble m_dRadius;
    protected PuDouble m_dRadiusPlane;
    protected PuInteger m_iSymmetry;
    private double m_radius = this.m_defaultRadius;
    private double m_radiusPlane = this.m_defaultRadiusPlane;
    private int m_symmetry = this.m_defaultSymmetry;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_PlanarEnd;

    public PgWeierstrass_PlanarEnd() {
        super(1);
        this.setName("Planar End");
        this.m_dRadius = new PuDouble("Radius Enneper", (PsUpdateIf)this);
        this.m_dRadiusPlane = new PuDouble("Radius Plane", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_PlanarEnd == null ? (class$vgp$minimal$weier$PgWeierstrass_PlanarEnd = PgWeierstrass_PlanarEnd.class$("vgp.minimal.weier.PgWeierstrass_PlanarEnd")) : class$vgp$minimal$weier$PgWeierstrass_PlanarEnd)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 5);
        this.m_numLines[0].setDefValue(17);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 5);
        this.m_numLines[1].setDefValue(9);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.0, 2.0, 0.01, 0.1);
        this.m_dRadius.setDefValue(this.m_defaultRadius);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dRadiusPlane.setDefBounds(0.0, 4.0, 0.01, 0.1);
        this.m_dRadiusPlane.setDefValue(this.m_defaultRadiusPlane);
        this.m_dRadiusPlane.init();
        this.addParameter((PsObject)this.m_dRadiusPlane);
        this.m_iSymmetry.setDefBounds(1, 10, 1, 2);
        this.m_iSymmetry.setDefValue(this.m_defaultSymmetry);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.setDomain(0, -this.m_radiusPlane, this.m_radius, 0.0, Math.PI / (double)(2 * this.m_symmetry));
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadiusPlane) {
            this.m_radiusPlane = this.m_dRadiusPlane.getValue();
            this.setUMin(0, -this.m_radiusPlane);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            this.setVMax(0, Math.PI / (double)(2 * this.m_symmetry));
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        return PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sqr((PuComplex)puComplex);
        return puComplex2.inv();
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)(this.m_symmetry + 1));
        return puComplex2;
    }

    public void getConnections() {
        this.connectPart(4 * this.m_symmetry - 1, 0, 0, 0);
    }

    public void getReflections() {
        for (int i = 0; i < 2 * this.m_symmetry; ++i) {
            this.reflectPart(2 * i + 1, 2 * i, 2);
            this.reflectPart(2 * i + 2, 2 * i + 1, 0);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null && n == 0) {
            piVector2.m_data[0] = 0;
            piVector2.m_data[2] = 1;
        }
    }

    public int getNumParts() {
        return 4 * this.m_symmetry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

