/*
 * Decompiled with CFR 0.152.
 */
package vgp.iterate.juliaSet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.number.PuComplex;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjJuliaSet
extends PjProject
implements ComponentListener {
    protected static final int COLOR_BLACK = 1;
    protected static final int COLOR_REDBLACK = 2;
    protected static final int COLOR_HUE = 3;
    protected static final int COLOR_HUEOFFSET = 4;
    protected PvDisplayIf m_dispJulia;
    protected Image m_image;
    protected int m_imageHeight;
    protected int m_imageWidth;
    private MemoryImageSource m_mis;
    private PiVector m_pix = new PiVector();
    private PiVector m_pixStore;
    private PiVector m_pixIter = new PiVector();
    protected PdVector m_bounds;
    private PiVector m_pixTrace;
    private PiVector m_colMap;
    protected PuInteger m_maxIter;
    protected PuInteger m_blockSize;
    protected PuComplex m_const;
    protected PuInteger m_hueOffset;
    protected boolean m_bMandelbrotHueoffset;
    protected PvDisplayIf m_dispMandelbrot;
    protected Image m_imageMandelbrot;
    protected int m_imageHeightMandelbrot;
    protected int m_imageWidthMandelbrot;
    private MemoryImageSource m_misMandelbrot;
    private PiVector m_pixMandelbrot;
    private PiVector m_pixStoreMandelbrot;
    private PiVector m_pixIterMandelbrot;
    protected PdVector m_boundsMandelbrot;
    static /* synthetic */ Class class$vgp$iterate$juliaSet$PjJuliaSet;

    public PjJuliaSet() {
        super("Julia Set Explorer");
        this.m_pixStore = new PiVector();
        this.m_pixMandelbrot = new PiVector();
        this.m_pixIterMandelbrot = new PiVector();
        this.m_pixStoreMandelbrot = new PiVector();
        this.m_pixTrace = new PiVector();
        this.m_colMap = new PiVector();
        this.m_bounds = new PdVector(-2.0, -1.5, 2.0, 1.5);
        this.m_boundsMandelbrot = new PdVector(-2.2, -1.0, 0.8, 1.0);
        this.m_maxIter = new PuInteger("Number of Iterations", (PsUpdateIf)this);
        this.m_blockSize = new PuInteger("Block Size", (PsUpdateIf)this);
        this.m_hueOffset = new PuInteger("Hue Offset", (PsUpdateIf)this);
        if (this.getClass() == (class$vgp$iterate$juliaSet$PjJuliaSet == null ? (class$vgp$iterate$juliaSet$PjJuliaSet = PjJuliaSet.class$("vgp.iterate.juliaSet.PjJuliaSet")) : class$vgp$iterate$juliaSet$PjJuliaSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_image = null;
        this.m_imageMandelbrot = null;
        this.m_pix.setSize(0);
        this.m_pixIter.setSize(0);
        this.m_pixStore.setSize(0);
        this.m_pixMandelbrot.setSize(0);
        this.m_pixIterMandelbrot.setSize(0);
        this.m_pixStoreMandelbrot.setSize(0);
        this.m_imageHeight = 0;
        this.m_imageWidth = 0;
        this.m_imageHeightMandelbrot = 0;
        this.m_imageWidthMandelbrot = 0;
        this.m_maxIter.setDefBounds(1, 200, 1, 5);
        this.m_maxIter.setDefValue(40);
        this.m_maxIter.init();
        this.m_colMap.setSize(this.m_maxIter.getValue() + 1);
        this.m_pixTrace.setSize(this.m_maxIter.getValue() + 1);
        this.m_blockSize.setDefBounds(1, 10, 1, 2);
        this.m_blockSize.setDefValue(1);
        this.m_blockSize.init();
        this.m_hueOffset.setDefBounds(0, 255, 1, 5);
        this.m_hueOffset.setDefValue(0);
        this.m_hueOffset.init();
        this.m_bMandelbrotHueoffset = true;
        this.m_const = new PuComplex(0.0, 0.75);
    }

    public void start() {
        if (this.m_dispJulia == null) {
            this.m_dispJulia = this.getDispJulia();
        }
        if (this.m_dispMandelbrot == null) {
            this.m_dispMandelbrot = this.getDispMandelbrot();
        }
        this.m_bounds.set(-2.0, -1.5, 2.0, 1.5);
        this.m_boundsMandelbrot.set(-2.2, -1.0, 0.8, 1.0);
        if (this.resizeImage(this.m_dispJulia)) {
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
        }
        if (this.resizeImage(this.m_dispMandelbrot)) {
            this.computeImageMandelbrot(this.m_dispMandelbrot, this.m_boundsMandelbrot.m_data[0], this.m_boundsMandelbrot.m_data[1], this.m_boundsMandelbrot.m_data[2], this.m_boundsMandelbrot.m_data[3]);
            this.m_dispMandelbrot.update(null);
        }
        if (this.m_dispJulia != null) {
            this.m_dispJulia.showScenegraph(false);
            this.m_dispJulia.selectCamera(1);
            this.m_dispJulia.setBackgroundImageFit(2);
            this.m_dispJulia.setMajorMode(6);
            this.m_dispJulia.showBackgroundImage(true);
        }
        if (this.m_dispMandelbrot != null) {
            this.m_dispMandelbrot.showScenegraph(false);
            this.m_dispMandelbrot.showCopyright(false);
            this.m_dispMandelbrot.selectCamera(1);
            this.m_dispMandelbrot.setBackgroundImageFit(2);
            this.m_dispMandelbrot.setMajorMode(6);
            this.m_dispMandelbrot.showBackgroundImage(true);
        }
        this.update(this);
        super.start();
    }

    public boolean update(Object object) {
        if (this.m_dispJulia == null) {
            return super.update(object);
        }
        if (object == this) {
            return super.update((Object)this);
        }
        if (object == this.m_maxIter) {
            this.m_colMap.setSize(this.m_maxIter.getValue() + 1);
            this.m_pixTrace.setSize(this.m_maxIter.getValue() + 1);
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
            this.computeImageMandelbrot(this.m_dispMandelbrot, this.m_boundsMandelbrot.m_data[0], this.m_boundsMandelbrot.m_data[1], this.m_boundsMandelbrot.m_data[2], this.m_boundsMandelbrot.m_data[3]);
            this.m_dispMandelbrot.update(null);
            return true;
        }
        if (object == this.m_blockSize) {
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
            return true;
        }
        if (object == this.m_const) {
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
            return super.update((Object)this);
        }
        if (object == this.m_hueOffset) {
            this.computeColors(this.m_pix.m_data, this.m_pixIter.m_data, this.m_imageWidth * this.m_imageHeight, this.m_maxIter.getValue() + 1, 4);
            this.m_pixStore.copy(this.m_pix.m_data, this.m_imageWidth * this.m_imageHeight);
            this.m_mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
            this.m_dispJulia.update(null);
            if (this.m_bMandelbrotHueoffset) {
                this.computeColors(this.m_pixMandelbrot.m_data, this.m_pixIterMandelbrot.m_data, this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot, this.m_maxIter.getValue() + 1, 4);
                this.m_pixStoreMandelbrot.copy(this.m_pixMandelbrot.m_data, this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot);
                this.m_misMandelbrot.newPixels(0, 0, this.m_imageWidthMandelbrot, this.m_imageHeightMandelbrot);
                this.m_dispMandelbrot.update(null);
            }
            return true;
        }
        return super.update(object);
    }

    private boolean resizeImage(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            return false;
        }
        boolean bl = false;
        if (pvDisplayIf == this.m_dispJulia) {
            Dimension dimension = this.m_dispJulia.getSize();
            if (dimension.height > 0 && dimension.width > 0 && (this.m_mis == null || this.m_imageHeight != dimension.height || this.m_imageWidth != dimension.width)) {
                this.m_imageHeight = dimension.height;
                this.m_imageWidth = dimension.width;
                this.m_pix.setSize(this.m_imageWidth * this.m_imageHeight);
                this.m_pixIter.setSize(this.m_imageWidth * this.m_imageHeight);
                this.m_mis = new MemoryImageSource(this.m_imageWidth, this.m_imageHeight, this.m_pix.m_data, 0, this.m_imageWidth);
                this.m_mis.setAnimated(true);
                this.m_image = ((Component)this.m_dispJulia).createImage(this.m_mis);
                this.m_dispJulia.setBackgroundImage(this.m_image);
                this.m_dispJulia.update(null);
                bl = true;
            }
            return bl;
        }
        if (pvDisplayIf == this.m_dispMandelbrot) {
            Dimension dimension = this.m_dispMandelbrot.getSize();
            if (dimension.height > 0 && dimension.width > 0 && (this.m_misMandelbrot == null || this.m_imageHeightMandelbrot != dimension.height || this.m_imageWidthMandelbrot != dimension.width)) {
                this.m_imageHeightMandelbrot = dimension.height;
                this.m_imageWidthMandelbrot = dimension.width;
                this.m_pixMandelbrot.setSize(this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot);
                this.m_pixIterMandelbrot.setSize(this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot);
                this.m_misMandelbrot = new MemoryImageSource(this.m_imageWidthMandelbrot, this.m_imageHeightMandelbrot, this.m_pixMandelbrot.m_data, 0, this.m_imageWidthMandelbrot);
                this.m_misMandelbrot.setAnimated(true);
                this.m_imageMandelbrot = ((Component)this.m_dispMandelbrot).createImage(this.m_misMandelbrot);
                this.m_dispMandelbrot.setBackgroundImage(this.m_imageMandelbrot);
                this.m_dispMandelbrot.update(null);
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Object object = componentEvent.getSource();
        if (object == this.m_dispJulia) {
            if (!this.resizeImage(this.m_dispJulia)) {
                return;
            }
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
        } else if (object == this.m_dispMandelbrot) {
            if (!this.resizeImage(this.m_dispMandelbrot)) {
                return;
            }
            this.computeImageMandelbrot(this.m_dispMandelbrot, this.m_boundsMandelbrot.m_data[0], this.m_boundsMandelbrot.m_data[1], this.m_boundsMandelbrot.m_data[2], this.m_boundsMandelbrot.m_data[3]);
            this.m_dispMandelbrot.update(null);
        }
    }

    public PvDisplayIf getDispJulia() {
        if (this.m_dispJulia != null) {
            return this.m_dispJulia;
        }
        if (this.getDisplay() != null) {
            this.m_dispJulia = this.getDisplay();
        } else {
            PvViewerIf pvViewerIf = this.getViewer();
            this.m_dispJulia = pvViewerIf.newDisplay("Julia Set", false);
            this.m_dispJulia.addPickListener((PvPickListenerIf)this);
        }
        this.m_dispJulia.setBackgroundColor(Color.white);
        ((Component)this.m_dispJulia).addComponentListener(this);
        return this.m_dispJulia;
    }

    public PvDisplayIf getDispMandelbrot() {
        if (this.m_dispMandelbrot != null) {
            return this.m_dispMandelbrot;
        }
        PvViewerIf pvViewerIf = this.getViewer();
        this.m_dispMandelbrot = pvViewerIf.newDisplay("Mandelbrot Set", false);
        this.m_dispMandelbrot.setBackgroundColor(new Color(255, 255, 150));
        this.m_dispMandelbrot.addPickListener((PvPickListenerIf)this);
        ((Component)this.m_dispMandelbrot).addComponentListener(this);
        return this.m_dispMandelbrot;
    }

    public void markVertices(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getSource() == this.m_dispJulia) {
            PiVector piVector = pvPickEvent.getMarkBox();
            int[] nArray = piVector.m_data;
            double d = this.m_bounds.m_data[2] - this.m_bounds.m_data[0];
            double d2 = this.m_bounds.m_data[3] - this.m_bounds.m_data[1];
            double d3 = this.m_bounds.m_data[0] + d * (double)nArray[0] / ((double)this.m_imageWidth - 1.0);
            double d4 = this.m_bounds.m_data[0] + d * (double)nArray[2] / ((double)this.m_imageWidth - 1.0);
            double d5 = this.m_bounds.m_data[1] + d2 * (double)nArray[1] / ((double)this.m_imageHeight - 1.0);
            double d6 = this.m_bounds.m_data[1] + d2 * (double)nArray[3] / ((double)this.m_imageHeight - 1.0);
            this.computeImageJulia(this.m_dispJulia, d3, d5, d4, d6);
            this.m_dispJulia.update(null);
        } else if (pvPickEvent.getSource() == this.m_dispMandelbrot) {
            PiVector piVector = pvPickEvent.getMarkBox();
            int[] nArray = piVector.m_data;
            double d = this.m_boundsMandelbrot.m_data[2] - this.m_boundsMandelbrot.m_data[0];
            double d7 = this.m_boundsMandelbrot.m_data[3] - this.m_boundsMandelbrot.m_data[1];
            double d8 = this.m_boundsMandelbrot.m_data[0] + d * (double)nArray[0] / ((double)this.m_imageWidthMandelbrot - 1.0);
            double d9 = this.m_boundsMandelbrot.m_data[0] + d * (double)nArray[2] / ((double)this.m_imageWidthMandelbrot - 1.0);
            double d10 = this.m_boundsMandelbrot.m_data[1] + d7 * (double)nArray[1] / ((double)this.m_imageHeightMandelbrot - 1.0);
            double d11 = this.m_boundsMandelbrot.m_data[1] + d7 * (double)nArray[3] / ((double)this.m_imageHeightMandelbrot - 1.0);
            this.computeImageMandelbrot(this.m_dispMandelbrot, d8, d10, d9, d11);
            this.m_dispMandelbrot.update(null);
        }
        this.update(this);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getSource() == this.m_dispJulia) {
            double d = this.m_bounds.m_data[0];
            double d2 = this.m_bounds.m_data[2];
            double d3 = this.m_bounds.m_data[1];
            double d4 = this.m_bounds.m_data[3];
            double d5 = d2 - d;
            double d6 = d4 - d3;
            Point point = pvPickEvent.getLocation();
            double d7 = d + d5 * (double)point.x / ((double)this.m_imageWidth - 1.0);
            double d8 = d3 + d6 * (double)point.y / ((double)this.m_imageHeight - 1.0);
            this.m_pix.copyArray(this.m_pixStore);
            PuComplex puComplex = new PuComplex();
            PuComplex puComplex2 = new PuComplex(d7, d8);
            puComplex.copy(this.m_const);
            int n = 3 * PsConfig.getMonitorScale();
            int n2 = 20;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.getImagePosition(puComplex2.re, puComplex2.im);
                if (n3 != -1) {
                    int n4;
                    this.m_pix.m_data[n3] = n4 = PdColor.hsv2rgbAsInt((int)0, (int)(255 * i / n2), (int)255);
                    if (n3 + n * (this.m_imageWidth + 1) < this.m_imageWidth * this.m_imageHeight) {
                        int n5 = n3;
                        for (int j = 0; j < n; ++j) {
                            for (int k = 0; k < n; ++k) {
                                this.m_pix.m_data[n5 + k] = n4;
                            }
                            n5 += this.m_imageWidth;
                        }
                    }
                }
                puComplex2.sqr().add(puComplex);
                if (puComplex2.sqrAbs() > 4.0) break;
                if (!(puComplex2.re < d || puComplex2.re > d2 || puComplex2.im < d3) && !(puComplex2.im > d4)) continue;
            }
            this.m_mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
            this.m_dispJulia.update(null);
        } else if (pvPickEvent.getSource() == this.m_dispMandelbrot) {
            double d = this.m_boundsMandelbrot.m_data[0];
            double d9 = this.m_boundsMandelbrot.m_data[2];
            double d10 = this.m_boundsMandelbrot.m_data[1];
            double d11 = this.m_boundsMandelbrot.m_data[3];
            double d12 = d9 - d;
            double d13 = d11 - d10;
            Point point = pvPickEvent.getLocation();
            double d14 = d + d12 * (double)point.x / ((double)this.m_imageWidthMandelbrot - 1.0);
            double d15 = d10 + d13 * (double)point.y / ((double)this.m_imageHeightMandelbrot - 1.0);
            this.m_const.set(d14, d15);
            this.computeImageJulia(this.m_dispJulia, this.m_bounds.m_data[0], this.m_bounds.m_data[1], this.m_bounds.m_data[2], this.m_bounds.m_data[3]);
            this.m_dispJulia.update(null);
        }
        this.update(this);
    }

    private int getImagePosition(double d, double d2) {
        double d3 = this.m_bounds.m_data[0];
        double d4 = this.m_bounds.m_data[2];
        double d5 = this.m_bounds.m_data[1];
        double d6 = this.m_bounds.m_data[3];
        if (d < d3 || d > d4 || d2 < d5 || d2 > d6) {
            return -1;
        }
        double d7 = d6 - d5;
        int n = (int)((double)(this.m_imageHeight - 1) * (d2 - d5) / d7 + 0.5);
        double d8 = d4 - d3;
        int n2 = (int)((double)(this.m_imageWidth - 1) * (d - d3) / d8 + 0.5);
        int n3 = n * this.m_imageWidth + n2;
        if (n3 < 0 || n3 >= this.m_pix.m_data.length) {
            return -1;
        }
        return n3;
    }

    public void computeImageJulia(PvDisplayIf pvDisplayIf, double d, double d2, double d3, double d4) {
        this.m_bounds.set(d, d2, d3, d4);
        int n = this.m_maxIter.getValue();
        int n2 = this.m_blockSize.getValue();
        this.computeJulia(this.m_pixIter.m_data, this.m_imageWidth, this.m_imageHeight, n2, d, d2, d3, d4, n, this.m_const);
        this.computeColors(this.m_pix.m_data, this.m_pixIter.m_data, this.m_imageWidth * this.m_imageHeight, n + 1, 4);
        this.m_pixStore.copy(this.m_pix.m_data, this.m_imageWidth * this.m_imageHeight);
        this.m_mis.newPixels(0, 0, this.m_imageWidth, this.m_imageHeight);
    }

    public void computeImageMandelbrot(PvDisplayIf pvDisplayIf, double d, double d2, double d3, double d4) {
        this.m_boundsMandelbrot.set(d, d2, d3, d4);
        int n = this.m_maxIter.getValue();
        int n2 = this.m_blockSize.getValue();
        this.computeMandelbrot(this.m_pixIterMandelbrot.m_data, this.m_imageWidthMandelbrot, this.m_imageHeightMandelbrot, n2, d, d2, d3, d4, n);
        if (!this.m_bMandelbrotHueoffset) {
            this.computeColors(this.m_pixMandelbrot.m_data, this.m_pixIterMandelbrot.m_data, this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot, n + 1, 4);
        } else {
            this.computeColors(this.m_pixMandelbrot.m_data, this.m_pixIterMandelbrot.m_data, this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot, n + 1, 4);
        }
        this.m_pixStoreMandelbrot.copy(this.m_pixMandelbrot.m_data, this.m_imageWidthMandelbrot * this.m_imageHeightMandelbrot);
        this.m_misMandelbrot.newPixels(0, 0, this.m_imageWidthMandelbrot, this.m_imageHeightMandelbrot);
    }

    public void computeJulia(int[] nArray, int n, int n2, int n3, double d, double d2, double d3, double d4, int n4, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        double d7 = d2;
        int n5 = 0;
        for (int i = 0; i < n2; i += n3) {
            int n6;
            int n7;
            double d8 = d;
            int n8 = n5;
            for (n7 = 0; n7 < n; n7 += n3) {
                int n9;
                puComplex2.set(d8, d7);
                int n10 = 0;
                for (n9 = 0; n9 < n4; ++n9) {
                    puComplex2.sqr().add(puComplex);
                    if (!(puComplex2.sqrAbs() > 4.0)) continue;
                    n10 = n9 + 1;
                    break;
                }
                n6 = Math.min(n3, n - n7);
                for (n9 = 0; n9 < n6; ++n9) {
                    nArray[n5++] = n10;
                }
                d8 += d5;
            }
            n6 = Math.min(n3, n2 - i) - 1;
            for (n7 = 0; n7 < n6; ++n7) {
                System.arraycopy(nArray, n8, nArray, n5, n);
                n5 += n;
            }
            d7 += d6;
        }
    }

    public void computeMandelbrot(int[] nArray, int n, int n2, int n3, double d, double d2, double d3, double d4, int n4) {
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = new PuComplex();
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        int n5 = 0;
        double d7 = d2;
        for (int i = 0; i < n2; i += n3) {
            int n6;
            int n7;
            int n8 = n5;
            double d8 = d;
            for (n7 = 0; n7 < n; n7 += n3) {
                int n9;
                puComplex2.set(d8, d7);
                puComplex.set(d8, d7);
                n6 = 0;
                for (n9 = 0; n9 < n4; ++n9) {
                    puComplex.sqr().add(puComplex2);
                    if (!(puComplex.sqrAbs() > 4.0)) continue;
                    n6 = n9 + 1;
                    break;
                }
                n9 = Math.min(n3, n - n7);
                for (int j = 0; j < n9; ++j) {
                    nArray[n5++] = n6;
                }
                d8 += d5;
            }
            n7 = Math.min(n3, n2 - i) - 1;
            for (n6 = 0; n6 < n7; ++n6) {
                System.arraycopy(nArray, n8, nArray, n5, n);
                n5 += n;
            }
            d7 += d6;
        }
    }

    public void computeColors(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5;
        this.m_colMap.setSize(n2);
        int n6 = this.m_hueOffset.getValue();
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = 0;
            if (n5 == 0) {
                n4 = -13158601;
            } else {
                int n7 = 0;
                switch (n3) {
                    case 2: {
                        n4 = 0xFF000000 | (50 + 205 * n5 / n2) % 255 << 16 | 0 | 0;
                        break;
                    }
                    case 4: {
                        n7 += n6;
                    }
                    case 3: {
                        if ((n7 += 205 * n5 / n2) > 255) {
                            n7 -= 255;
                        }
                        n4 = PdColor.hsv2rgbAsInt((int)n7, (int)255, (int)255);
                        break;
                    }
                    case 1: {
                        n4 = 0;
                    }
                }
            }
            this.m_colMap.m_data[n5] = n4;
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = nArray2[n5];
            nArray[n5] = this.m_colMap.m_data[n4];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

