/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.lantern;

import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;

public class PgLantern
extends PgElementSet {
    protected PuDouble m_height;
    protected PuDouble m_radius;
    protected PuInteger m_profile;
    protected PuInteger m_waist;
    protected double m_areaOfLimit;
    protected double m_quotient;
    protected boolean m_bConstantArea;
    protected boolean m_bShowCylinder;
    private double m_defHeight = 2.0;
    private double m_defRadius = 1.0;
    private double m_defArea;
    private int m_defProfile = 5;
    protected int m_defWaist = 5;
    static /* synthetic */ Class class$vgp$discrete$lantern$PgLantern;

    public PgLantern() {
        super(3);
        this.setTag(10);
        this.m_height = new PuDouble("Height", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_profile = new PuInteger("Vertical Discr", (PsUpdateIf)this);
        this.m_waist = new PuInteger("Circular Discr", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$lantern$PgLantern == null ? (class$vgp$discrete$lantern$PgLantern = PgLantern.class$("vgp.discrete.lantern.PgLantern")) : class$vgp$discrete$lantern$PgLantern)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setDimOfElements(3);
        this.m_height.setDefBounds(0.01, 10.0, 0.01, 0.1);
        this.m_height.setDefValue(this.m_defHeight);
        this.m_height.init();
        this.m_radius.setDefBounds(0.01, 10.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.m_profile.setDefBounds(2, 100, 1, 1);
        this.m_profile.setDefValue(this.m_defProfile);
        this.m_profile.init();
        this.m_waist.setDefBounds(3, 100, 1, 1);
        this.m_waist.setDefValue(this.m_defWaist);
        this.m_waist.init();
        this.m_quotient = this.m_profile.getValue() / this.m_waist.getValue() / this.m_waist.getValue();
        this.m_areaOfLimit = this.computeAreaOfLimit();
        this.m_bShowCylinder = false;
        this.m_bConstantArea = true;
        this.showVertices(true);
        this.showElementColors(true);
    }

    public Object clone() {
        PgLantern pgLantern = (PgLantern)((Object)super.clone());
        if (pgLantern == null) {
            return null;
        }
        pgLantern.m_height = (PuDouble)this.m_height.clone();
        pgLantern.m_height.setParent((PsUpdateIf)pgLantern);
        pgLantern.m_radius = (PuDouble)this.m_radius.clone();
        pgLantern.m_radius.setParent((PsUpdateIf)pgLantern);
        pgLantern.m_profile = (PuInteger)this.m_profile.clone();
        pgLantern.m_profile.setParent((PsUpdateIf)pgLantern);
        pgLantern.m_waist = (PuInteger)this.m_waist.clone();
        pgLantern.m_waist.setParent((PsUpdateIf)pgLantern);
        return pgLantern;
    }

    public boolean isShowingCylinder() {
        return this.m_bShowCylinder;
    }

    public void showCylinder(boolean bl) {
        this.m_bShowCylinder = bl;
    }

    public boolean isAreaConstant() {
        return this.m_bConstantArea;
    }

    public void setAreaConstant(boolean bl) {
        this.m_bConstantArea = bl;
    }

    public double getHeight() {
        return this.m_height.getValue();
    }

    public void setHeight(double d) {
        this.m_height.setValue(d);
        this.m_defHeight = d;
        this.m_defArea = Math.PI * 2 * this.m_defHeight * this.m_defRadius;
        if (this.m_areaOfLimit < this.m_defArea) {
            this.setAreaOfLimit(this.m_defArea);
        }
    }

    public double getRadius() {
        return this.m_radius.getValue();
    }

    public void setRadius(double d) {
        this.m_radius.setValue(d);
        this.m_defRadius = d;
        this.m_defArea = Math.PI * 2 * this.m_defHeight * this.m_defRadius;
        if (this.m_areaOfLimit < this.m_defArea) {
            this.setAreaOfLimit(this.m_defArea);
        }
    }

    public double getAreaOfLimit() {
        return this.m_areaOfLimit;
    }

    public void setAreaOfLimit(double d) {
        if (d < this.m_defArea) {
            d = this.m_defArea;
        }
        this.m_areaOfLimit = d;
    }

    public int getProfile() {
        return this.m_profile.getValue();
    }

    public void setProfile(int n) {
        this.m_profile.setValue(n);
        this.m_quotient = this.m_profile.getValue() / this.m_waist.getValue() / this.m_waist.getValue();
    }

    public int getWaist() {
        return this.m_waist.getValue();
    }

    public void setWaist(int n) {
        this.m_waist.setValue(n);
        this.m_quotient = this.m_profile.getValue() / this.m_waist.getValue() / this.m_waist.getValue();
    }

    public double getAreaOfCylinder() {
        return Math.PI * 2 * this.m_radius.getValue() * this.m_height.getValue();
    }

    private double computeAreaOfLimit() {
        double d = this.m_radius.getValue();
        double d2 = this.m_height.getValue();
        double d3 = this.m_profile.getValue();
        double d4 = this.m_waist.getValue();
        double d5 = d3 / d4 / d4;
        double d6 = Math.PI * d;
        double d7 = d2 * 2.0;
        double d8 = d6 * Math.sqrt(d7 * d7 + d6 * d6 * Math.PI * Math.PI * d5 * d5);
        return d8;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == this) {
            double d = this.computeAreaOfLimit();
            this.setAreaOfLimit(d);
            this.computeSurface();
            return super.update((Object)this);
        }
        if (object == this.m_height) {
            double d = this.computeAreaOfLimit();
            this.setAreaOfLimit(d);
            this.computeSurface();
            return super.update((Object)this);
        }
        if (object == this.m_radius) {
            double d = this.computeAreaOfLimit();
            this.setAreaOfLimit(d);
            this.computeSurface();
            return super.update((Object)this);
        }
        if (object == this.m_profile) {
            double d = this.computeAreaOfLimit();
            this.setAreaOfLimit(d);
            this.computeSurface();
            return super.update((Object)this);
        }
        if (object == this.m_waist) {
            double d = this.computeAreaOfLimit();
            this.setAreaOfLimit(d);
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    protected void computeSurface() {
        int n;
        double d;
        int n2;
        int n3 = this.m_waist.getValue();
        int n4 = this.m_profile.getValue();
        int n5 = n3 + 1;
        int n6 = n4 + 1;
        this.setNumVertices(n5 * n6);
        double d2 = Math.PI * 2 / (double)n3;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            d = d2 * (double)n2;
            dArray[n2] = Math.cos(d);
            dArray2[n2] = Math.sin(d);
        }
        double d3 = Math.PI / (double)n3;
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            d = d2 * (double)n2 + d3;
            dArray3[n2] = Math.cos(d);
            dArray4[n2] = Math.sin(d);
        }
        double[] dArray5 = new double[n6];
        double[] dArray6 = new double[n6];
        double d4 = this.m_radius.getValue();
        double d5 = this.m_height.getValue() / (double)(n6 - 1);
        for (n = 0; n < n6; ++n) {
            dArray6[n] = d5 * (double)n;
            dArray5[n] = d4;
        }
        int n7 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n6; ++n) {
                if (n % 2 == 0) {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray2[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n];
                } else {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray3[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray4[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n];
                }
                ++n7;
            }
        }
        this.makeAlternatingQuadrConn(n5, n6, false);
        this.makeQuadrBnd(n5, n6);
        this.close();
        this.makeElementColorsFromZHue();
        this.makeVertexNormals();
        this.makeElementNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

