/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.deCasteljau;

import java.awt.Color;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.curve.PgBezierCurve;

public class PjDeCasteljau
extends PjProject {
    protected PgPolygon m_geom = new PgPolygon(3);
    protected PgPolygonSet m_build;
    protected PgBezierCurve m_bezier;
    protected int m_nov;
    protected PuDouble m_position;
    protected PuInteger m_depth;
    static /* synthetic */ Class class$vgp$curve$deCasteljau$PjDeCasteljau;

    public PjDeCasteljau() {
        super("DeCasteljau Algorithm");
        this.m_geom.setParent((PsUpdateIf)this);
        this.m_geom.setName("Control Polygon");
        this.m_build = new PgPolygonSet(3);
        this.m_build.setName("Construction");
        this.m_bezier = new PgBezierCurve(3);
        this.m_bezier.setName("Bezier Curve");
        this.m_bezier.setNumVertices(100);
        this.m_depth = new PuInteger(PsConfig.getMessage((boolean)true, (int)24000, (String)"Depth"), (PsUpdateIf)this);
        this.m_position = new PuDouble(PsConfig.getMessage((boolean)true, (int)24000, (String)"Position"), (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$deCasteljau$PjDeCasteljau == null ? (class$vgp$curve$deCasteljau$PjDeCasteljau = PjDeCasteljau.class$("vgp.curve.deCasteljau.PjDeCasteljau")) : class$vgp$curve$deCasteljau$PjDeCasteljau)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.setGlobalVertexColor(new Color(255, 255, 100));
        this.m_geom.setGlobalVertexSize(5.0);
        this.m_geom.setGlobalEdgeColor(new Color(0, 0, 120));
        this.m_geom.setGlobalEdgeSize(3.0);
        this.m_geom.setNumVertices(4);
        this.m_geom.setVertex(0, -4.0, -4.0, 0.0);
        this.m_geom.setVertex(1, -6.0, 2.0, 0.0);
        this.m_geom.setVertex(2, 4.0, 3.0, 0.0);
        this.m_geom.setVertex(3, 1.0, -3.0, 0.0);
        this.m_nov = this.m_geom.getNumVertices();
        this.m_build.setGlobalVertexColor(new Color(192, 192, 192));
        this.m_build.setGlobalVertexSize(3.0);
        this.m_build.setGlobalPolygonColor(new Color(192, 192, 192));
        this.m_build.setGlobalPolygonSize(2.0);
        this.m_build.showVertexLabels(true);
        this.m_build.setEnabledIndexLabels(false);
        this.m_build.setLabelAttribute(0, 0, 0, 0, 2, 1);
        this.m_bezier.showVertices(false);
        this.m_bezier.setGlobalEdgeColor(new Color(200, 100, 50));
        this.m_bezier.setGlobalEdgeSize(3.0);
        this.m_depth.setDefBounds(0, this.m_geom.getNumVertices() - 1, 1, 1);
        this.m_depth.setDefValue(this.m_geom.getNumVertices() - 1);
        this.m_depth.init();
        this.m_position.setDefBounds(0.0, 1.0, 0.01, 0.1);
        this.m_position.setDefValue(0.2);
        this.m_position.init();
        this.compute(this.m_position.getValue());
        this.m_bezier.computeVertices();
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.addGeometry((PgGeometryIf)this.m_build);
        this.addGeometry((PgGeometryIf)this.m_bezier);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.setMajorMode(5);
        super.start();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.compute(this.m_position.getValue());
            this.m_build.update((Object)this.m_build);
            this.m_bezier.update((Object)this.m_bezier);
            return super.update((Object)this);
        }
        if (object == this.m_geom) {
            if (this.m_nov != this.m_geom.getNumVertices()) {
                this.m_nov = this.m_geom.getNumVertices();
                this.m_depth.setBounds(0, this.m_nov - 1);
                this.m_depth.setValue(this.m_nov - 1);
            }
            return this.update((Object)this);
        }
        if (object == this.m_depth) {
            return this.update((Object)this);
        }
        if (object == this.m_position) {
            return this.update((Object)this);
        }
        return super.update(object);
    }

    public void compute(double d) {
        int n;
        int n2;
        int n3 = this.m_geom.getNumVertices();
        if (n3 <= 1) {
            return;
        }
        int n4 = this.m_depth.getValue();
        int n5 = n3 - 1;
        int n6 = n3 - n4;
        int n7 = (n5 + n6) * (n5 - n6 + 1) / 2;
        if (n4 == n3 - 1) {
            ++n7;
        }
        this.m_build.setNumVertices(n7);
        this.m_build.setNumPolygons(n4);
        for (n2 = 0; n2 < n7; ++n2) {
            PdVector pdVector = this.m_build.getVertex(n2);
            pdVector.clearTag(1);
            pdVector.setName("");
        }
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            int n8 = n3 - 1 - n;
            this.m_build.setSizeOfPolygon(n, Math.max(2, n8));
            PiVector piVector = this.m_build.getPolygon(n);
            for (int i = 0; i < n8; ++i) {
                PdVector pdVector;
                PdVector pdVector2;
                if (n2 == 0) {
                    pdVector2 = this.m_geom.getVertex(i);
                    pdVector = this.m_geom.getVertex(i + 1);
                } else {
                    pdVector2 = this.m_build.getVertex(n2 - (n8 + 1) + i);
                    pdVector = this.m_build.getVertex(n2 - (n8 + 1) + i + 1);
                }
                this.m_build.getVertex(n2 + i).blend(1.0 - d, pdVector2, d, pdVector);
                piVector.setEntry(i, n2 + i);
            }
            if (n8 == 1) {
                this.m_build.setVertex(n2 + 1, this.m_build.getVertex(n2));
                this.m_build.setTagVertex(n2 + 1, 1);
                this.m_build.getVertex(n2 + 1).setName("t = " + PuString.toString((float)((float)d)));
                piVector.setEntry(1, n2 + 1);
            }
            n2 += n8;
        }
        this.m_bezier.setNumControlPoints(n3);
        for (n = 0; n < n3; ++n) {
            this.m_bezier.setControlPoint(n, this.m_geom.getVertex(n));
        }
    }

    public double getPosition() {
        return this.m_position.getValue();
    }

    public void setPosition(double d) {
        this.m_position.setValue(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

