/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.curvatureCircle;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jvx.geom.PnPolygon;
import jvx.geom.PwRefinePolygon;

public class PjCurvatureCircle
extends PjProject {
    protected static final double MAX_DISCR_DIST = 0.1;
    protected static final int MIN_DISCR = 40;
    protected PgPolygon m_reference = new PgPolygon(2);
    protected PgPolygon m_poly;
    protected PgPolygon m_circle;
    protected PgPointSet m_point;
    protected PdVector[] m_mcf;
    protected PuInteger m_refine;
    protected PuInteger m_position;
    protected PsAnimation m_anim;
    static /* synthetic */ Class class$vgp$curve$curvatureCircle$PjCurvatureCircle;

    public PjCurvatureCircle() {
        super("Curvature Circle");
        this.m_reference.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Control Polygon"));
        this.m_reference.addUpdateListener((PsUpdateIf)this);
        this.m_poly = new PgPolygon(2);
        this.m_poly.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Curve"));
        this.m_circle = new PgPolygon(2);
        this.m_circle.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Curvature Circle"));
        this.m_point = new PgPointSet(2);
        this.m_point.setName(PsConfig.getMessage((boolean)true, (int)75000, (String)"Position Marker"));
        this.m_refine = new PuInteger(PsConfig.getMessage((boolean)true, (int)84000, (String)"Refinements"), (PsUpdateIf)this);
        this.m_position = new PuInteger(PsConfig.getMessage((boolean)true, (int)84000, (String)"Circle Position"), (PsUpdateIf)this);
        this.m_anim = new PsAnimation();
        this.m_anim.setName("Curvature Circle");
        this.m_anim.addTimeListener((PsTimeListenerIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$curvatureCircle$PjCurvatureCircle == null ? (class$vgp$curve$curvatureCircle$PjCurvatureCircle = PjCurvatureCircle.class$("vgp.curve.curvatureCircle.PjCurvatureCircle")) : class$vgp$curve$curvatureCircle$PjCurvatureCircle)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_reference.computeCircle(7, 1.0);
        this.m_reference.setVertex(0, 1.11, -0.45);
        this.m_reference.setVertex(1, 0.38, 0.4);
        this.m_reference.setVertex(2, -0.54, -0.86);
        this.m_reference.setVertex(3, -1.58, -0.4);
        this.m_reference.setVertex(4, -1.72, -1.92);
        this.m_reference.setVertex(5, -0.91, -2.62);
        this.m_reference.setVertex(6, 0.43, -2.64);
        this.m_reference.setClosed(true);
        this.m_reference.showVertices(true);
        this.m_reference.setGlobalEdgeColor(Color.gray);
        this.m_reference.setGlobalVertexColor(Color.gray);
        this.m_poly.showVertices(false);
        this.m_poly.setGlobalEdgeColor(Color.black);
        this.m_poly.setGlobalEdgeSize(3.0);
        this.m_circle.showVertices(false);
        this.m_circle.setGlobalEdgeColor(Color.red);
        this.m_circle.setGlobalEdgeSize(2.0);
        this.m_point.showVertices(true);
        this.m_point.setGlobalVertexColor(Color.blue);
        this.m_point.setGlobalVertexSize(5.0);
        this.m_refine.setDefBounds(0, 15, 1, 3);
        this.m_refine.setDefValue(5);
        this.m_refine.init();
        this.m_position.setDefBounds(0, 0, 0, 0);
        this.m_position.setDefValue(0);
        this.m_position.init();
        this.setAnimation(this.m_anim);
        this.update();
    }

    public void start() {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        if (pvDisplayIf != null) {
            pvDisplayIf.selectCamera(1);
            pvDisplayIf.setMajorMode(5);
        }
        this.addGeometry((PgGeometryIf)this.m_reference);
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.fitDisplays();
        this.addGeometry((PgGeometryIf)this.m_circle);
        this.addGeometry((PgGeometryIf)this.m_point);
        this.selectGeometry((PgGeometryIf)this.m_reference);
    }

    protected void computePolygon() {
        this.m_poly.setNumVertices(this.m_reference.getNumVertices());
        PdVector.copy((PdVector[])this.m_poly.getVertices(), (int)0, (PdVector[])this.m_reference.getVertices(), (int)0, (int)this.m_poly.getNumVertices());
        this.m_poly.setClosed(this.m_reference.isClosed());
        int n = this.m_refine.getValue();
        for (int i = 0; i < n; ++i) {
            PwRefinePolygon.refineDFH((PgPolygon)this.m_poly, (PdVector)PwRefinePolygon.getFourPointMask());
        }
    }

    protected void update() {
        this.computePolygon();
        this.setPositionBounds();
        this.setAnimationBounds();
        this.m_mcf = PnPolygon.computeCurvatureVectors((PgPolygon)this.m_poly, (PdVector[])this.m_mcf);
        this.computeCircle();
    }

    protected void setPositionBounds() {
        this.m_position.setBounds(0, this.m_poly.getNumVertices() - 1, 1, 5);
    }

    protected void setAnimationBounds() {
        this.m_anim.setTimeInterval(0.0, (double)(this.m_poly.getNumVertices() - 1), 1.0, 5.0);
    }

    protected void computeCircle() {
        int n = this.m_position.getValue();
        if (n < 0 || n >= this.m_poly.getNumVertices() || n >= this.m_mcf.length) {
            this.m_circle.setNumVertices(0);
            this.m_point.setNumVertices(0);
            return;
        }
        double d = this.m_mcf[n].length();
        if (Math.abs(d) > 0.01) {
            PdVector pdVector = PdVector.copyNew((PdVector)this.m_poly.getVertex(n));
            double d2 = 1.0 / d;
            pdVector.add(d2 * d2, this.m_mcf[n]);
            int n2 = (int)(62.83185307179586 * d2);
            if (n2 < 40) {
                n2 = 40;
            }
            this.m_circle.computeCircle(n2, d2);
            this.m_circle.translate(pdVector);
        } else {
            this.m_circle.setNumVertices(0);
        }
        this.m_point.setNumVertices(1);
        this.m_point.setVertex(0, this.m_poly.getVertex(n));
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        double d = psTimeEvent.getTime();
        int n = (int)d;
        if (n >= 0 && n < this.m_poly.getNumVertices()) {
            this.m_position.setValue(n);
        }
        return this.m_position.update((Object)this.m_position);
    }

    public boolean update(Object object) {
        if (object == null || this.isUpdateSender()) {
            return super.update(null);
        }
        if (object == this) {
            this.update();
            this.setUpdateSender(true);
            this.m_poly.update((Object)this.m_poly);
            this.m_position.update((Object)this.m_position);
            this.m_circle.update((Object)this.m_circle);
            this.m_point.update((Object)this.m_point);
            this.setUpdateSender(false);
            return super.update((Object)this);
        }
        if (object == this.m_refine) {
            this.update();
            this.m_poly.update((Object)this.m_poly);
            this.m_position.update((Object)this.m_position);
            this.m_circle.update((Object)this.m_circle);
            this.m_point.update((Object)this.m_point);
            return super.update(null);
        }
        if (object == this.m_reference) {
            this.update();
            this.setUpdateSender(true);
            this.m_poly.update((Object)this.m_poly);
            this.m_position.update((Object)this.m_position);
            this.m_circle.update((Object)this.m_circle);
            this.m_point.update((Object)this.m_point);
            this.setUpdateSender(false);
            return super.update(null);
        }
        if (object == this.m_position) {
            this.computeCircle();
            this.m_circle.update((Object)this.m_circle);
            this.m_point.update((Object)this.m_point);
            return super.update(null);
        }
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

