/*
 * Decompiled with CFR 0.152.
 */
package org.hecl.load;

import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.hecl.Command;
import org.hecl.HeclException;
import org.hecl.HeclModule;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.Thing;

public class LoadCmd
implements Command {
    private static LoadCmd cmd = new LoadCmd();

    private LoadCmd() {
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        try {
            Vector urlv = ListThing.get(argv[2]);
            int sz = urlv.size();
            URL[] urls = new URL[sz];
            for (int i = 0; i < sz; ++i) {
                URI uri = new URI(((Thing)urlv.elementAt(i)).toString());
                if (!uri.isAbsolute()) {
                    // empty if block
                }
                urls[i] = uri.toURL();
            }
            URLClassLoader ucl = new URLClassLoader(urls);
            Class<?> c = ucl.loadClass(argv[1].toString());
            HeclModule module = (HeclModule)c.newInstance();
            module.loadModule(interp);
        }
        catch (Exception e) {
            throw new HeclException(e.toString());
        }
        return null;
    }

    public static void load(Interp interp) throws HeclException {
        interp.addCommand("load", cmd);
    }

    public static void unload(Interp interp) throws HeclException {
        interp.removeCommand("load");
    }
}

