/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HashThing;
import org.hecl.HeclException;
import org.hecl.ParseList;
import org.hecl.RealThing;
import org.hecl.Thing;

public class ListThing
implements RealThing {
    protected Vector val = null;
    private int depth = 0;
    static final int USE_BRACES = 1;
    static final int DONT_USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;

    public ListThing() {
        this.val = new Vector();
    }

    public ListThing(Vector v) {
        this.val = v;
    }

    public ListThing(String s) throws HeclException {
        ParseList parseList = new ParseList(s);
        this.val = parseList.parse();
        if (this.val == null) {
            this.val = new Vector();
        }
    }

    public static Thing create(Vector v) {
        return new Thing(new ListThing(v));
    }

    @Override
    public String thingclass() {
        return "list";
    }

    private static void setListFromAny(Thing thing) throws HeclException {
        RealThing realthing = thing.getVal();
        if (realthing instanceof ListThing) {
            return;
        }
        ListThing newthing = null;
        Vector<Thing> newval = new Vector<Thing>();
        if (realthing instanceof HashThing) {
            Hashtable h = HashThing.get(thing);
            Enumeration e = h.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                newval.addElement(new Thing(key));
                newval.addElement((Thing)h.get(key));
            }
            newthing = new ListThing(newval);
        } else {
            newthing = new ListThing(realthing.getStringRep());
        }
        thing.setVal(newthing);
    }

    public static Vector get(Thing thing) throws HeclException {
        ListThing.setListFromAny(thing);
        ListThing getlist = (ListThing)thing.getVal();
        if (thing.copy) {
            Enumeration e = getlist.val.elements();
            while (e.hasMoreElements()) {
                Thing te = (Thing)e.nextElement();
                te.copy = true;
            }
        }
        return getlist.val;
    }

    public static Thing[] getArray(Thing thing) throws HeclException {
        Vector v = ListThing.get(thing);
        Thing[] res = new Thing[v.size()];
        int i = 0;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            res[i] = (Thing)e.nextElement();
            ++i;
        }
        return res;
    }

    @Override
    public RealThing deepcopy() throws HeclException {
        Vector<Thing> newv = new Vector<Thing>();
        Enumeration e = this.val.elements();
        while (e.hasMoreElements()) {
            newv.addElement(((Thing)e.nextElement()).deepcopy());
        }
        return new ListThing(newv);
    }

    public static String toListString(Thing thing) {
        String elementstring = thing.toString();
        if (elementstring.indexOf(32) >= 0 || elementstring.indexOf(9) >= 0) {
            StringBuffer resbuf = new StringBuffer();
            resbuf.append('{').append(elementstring).append('}');
            return resbuf.toString();
        }
        return elementstring;
    }

    public static StringBuffer appendListItem(StringBuffer buf, Thing thing) {
        String elementstring = thing.toString();
        if (elementstring.indexOf(32) >= 0 || elementstring.indexOf(9) >= 0) {
            buf.append('{').append(elementstring).append('}');
        } else {
            buf.append(elementstring);
        }
        return buf;
    }

    static int scanElement(Thing t) {
        char ch;
        String s = t.toString();
        int flags = 0;
        int n = s.length();
        if (n == 0 || (ch = s.charAt(0)) == '{' || ch == '}') {
            flags |= 1;
        }
        int nestinglevel = 0;
        block6: for (int i = 0; i < n; ++i) {
            switch (s.charAt(i)) {
                case '{': {
                    ++nestinglevel;
                    continue block6;
                }
                case '}': {
                    if (--nestinglevel >= 0) continue block6;
                    flags |= 6;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    flags |= 1;
                    continue block6;
                }
                case '\\': {
                    if (i + 1 == n || s.charAt(i + 1) == '\n') {
                        flags = 6;
                        continue block6;
                    }
                    int size = 5;
                    i += size - 1;
                    flags |= 1;
                }
            }
        }
        if (nestinglevel != 0) {
            flags = 6;
        }
        return flags;
    }

    @Override
    public String getStringRep() {
        int sz = this.val.size();
        if (sz == 0) {
            return "";
        }
        int i = 0;
        int[] flags = new int[sz];
        for (i = 0; i < sz; ++i) {
            Thing elem = (Thing)this.val.elementAt(i);
            flags[i] = ListThing.scanElement(elem);
        }
        StringBuffer resbuf = new StringBuffer();
        for (i = 0; i < sz; ++i) {
            if (i > 0) {
                resbuf.append(' ');
            }
            ListThing.appendListItem(resbuf, (Thing)this.val.elementAt(i));
        }
        return resbuf.toString();
    }

    public static Thing stringSplit(String str, String splitstr) {
        int splitstringlen;
        int idx = 0;
        int last = 0;
        Vector<Thing> result = new Vector<Thing>();
        if (splitstr == null) {
            splitstr = " ";
        }
        if ((splitstringlen = splitstr.length()) > 0) {
            idx = str.indexOf(splitstr);
            while (idx >= 0) {
                result.addElement(new Thing(str.substring(last, idx)));
                last = idx + splitstringlen;
                idx = str.indexOf(splitstr, last);
            }
            result.addElement(new Thing(str.substring(last, str.length())));
        } else {
            for (int i = 0; i < str.length(); ++i) {
                char[] c = new char[]{str.charAt(i)};
                result.addElement(new Thing(new String(c)));
            }
        }
        return ListThing.create(result);
    }

    public static Thing buildCmdList(Thing cmd, Thing[] args) throws HeclException {
        Vector v = ListThing.get(cmd.deepcopy());
        for (int i = 0; i < args.length; ++i) {
            v.addElement(args[i]);
        }
        return ListThing.create(v);
    }
}

