/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hecl.HeclException;
import org.hecl.HeclTask;
import org.hecl.IntThing;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.LongThing;
import org.hecl.NumberThing;
import org.hecl.ObjectThing;
import org.hecl.Operator;
import org.hecl.Proc;
import org.hecl.Thing;

class InterpCmds
extends Operator {
    public static final int SET = 1;
    public static final int UNSET = 2;
    public static final int PROC = 3;
    public static final int RENAME = 4;
    public static final int EVAL = 5;
    public static final int GLOBAL = 6;
    public static final int INTROSPECT = 7;
    public static final int RETURN = 8;
    public static final int CATCH = 9;
    public static final int EXIT = 10;
    public static final int UPCMD = 11;
    public static final int TIMECMD = 12;
    public static final int COPY = 13;
    public static final int THROW = 14;
    public static final int AFTER = 15;
    public static final int BGERROR = 16;
    public static final int TOKENWAIT = 17;
    public static final int TOKENNOTIFY = 18;
    protected static final int GC = 19;
    protected static final int GETPROP = 20;
    protected static final int HASPROP = 21;
    protected static final int CLOCKCMD = 22;
    protected static final int FREEMEM = 23;
    protected static final int TOTALMEM = 24;
    public static final int ALIAS = 25;
    public static final int HASCLASS = 70;
    public static final int CLASSINFO = 80;
    public static final int GETINTERP = 100;
    private static Hashtable cmdtable = new Hashtable();

    @Override
    public Thing operate(int cmd, Interp interp, Thing[] argv) throws HeclException {
        Thing result = null;
        int retval = 0;
        String subcmd = null;
        block2 : switch (cmd) {
            case 1: {
                if (argv.length == 3) {
                    interp.setVar(argv[1], argv[2]);
                    return argv[2];
                }
                return interp.getVar(argv[1]);
            }
            case 13: {
                return argv[1].deepcopy();
            }
            case 2: {
                interp.unSetVar(argv[1]);
                break;
            }
            case 3: {
                if (argv.length == 4) {
                    interp.commands.put(argv[1].toString(), new Proc(argv[2], argv[3]));
                    break;
                }
                return ObjectThing.create(new Proc(argv[1], argv[2]));
            }
            case 4: {
                interp.cmdRename(argv[1].toString(), argv[2].toString());
                break;
            }
            case 25: {
                interp.cmdAlias(argv[1].toString(), argv[2].toString());
                break;
            }
            case 5: {
                return interp.eval(argv[1]);
            }
            case 6: {
                for (int i = 1; i < argv.length; ++i) {
                    interp.setVar(argv[i].toString(), Interp.GLOBALREFTHING, -1);
                }
                break;
            }
            case 7: {
                subcmd = argv[1].toString();
                Vector<Thing> results = new Vector<Thing>();
                if (subcmd.equals("commands")) {
                    Enumeration e = interp.commands.keys();
                    while (e.hasMoreElements()) {
                        Thing t = new Thing((String)e.nextElement());
                        results.addElement(t);
                    }
                    return ListThing.create(results);
                }
                if (subcmd.equals("proccode")) {
                    Proc p = (Proc)interp.commands.get(argv[2].toString());
                    return new Thing(p.getCode().getVal());
                }
                if (!subcmd.equals("objectid")) break;
                Vector<Thing> v = new Vector<Thing>();
                v.addElement(IntThing.create(argv[2].hashCode()));
                v.addElement(IntThing.create(argv[2].getVal().hashCode()));
                return ListThing.create(v);
            }
            case 8: {
                throw new HeclException("", "RETURN", argv.length > 1 ? argv[1] : Thing.emptyThing());
            }
            case 9: {
                try {
                    result = interp.eval(argv[1]);
                    retval = 0;
                }
                catch (HeclException e) {
                    result = e.getStack();
                    retval = 1;
                }
                if (argv.length == 3) {
                    interp.setVar(argv[2].toString(), result != null ? result : Thing.emptyThing());
                }
                return new Thing(retval != 0 ? IntThing.ONE : IntThing.ZERO);
            }
            case 14: {
                String errmsg = argv[1].toString();
                if (argv.length == 2) {
                    throw new HeclException(errmsg);
                }
                throw new HeclException(errmsg, argv[2].toString());
            }
            case 15: {
                subcmd = argv[1].toString();
                if (subcmd.equals("info")) {
                    if (argv.length == 2) {
                        Vector v = interp.getAllEvents();
                        int n = v.size();
                        for (int i = 0; i < n; ++i) {
                            HeclTask t = (HeclTask)v.elementAt(i);
                            v.setElementAt(new Thing(t.getName()), i);
                        }
                        return ListThing.create(v);
                    }
                    if (argv.length == 3) {
                        String evname = argv[2].toString();
                        HeclTask t = interp.getEvent(evname);
                        if (t != null) {
                            Vector<Thing> v = new Vector<Thing>();
                            v.addElement(new Thing(t.getScript().toString()));
                            v.addElement(new Thing(t.getType()));
                            return ListThing.create(v);
                        }
                        throw new HeclException("Event '" + evname + "' doesn't exist.");
                    }
                    throw HeclException.createWrongNumArgsException(argv, 2, "?id?");
                }
                if (subcmd.equals("cancel")) {
                    for (int i = 2; i < argv.length; ++i) {
                        String s = argv[2].toString();
                        if (s.startsWith("idle")) {
                            interp.cancelIdle(s);
                            continue;
                        }
                        if (s.startsWith("timer")) {
                            interp.cancelTimer(s);
                            continue;
                        }
                        if (!s.startsWith("async")) continue;
                        interp.cancelAsync(s);
                    }
                    break;
                }
                if (subcmd.equals("idle")) {
                    if (argv.length != 3) {
                        throw HeclException.createWrongNumArgsException(argv, 2, "script");
                    }
                    interp.evalIdle(argv[2]);
                    break;
                }
                int milli = IntThing.get(argv[1]);
                if (milli >= 0) {
                    switch (argv.length) {
                        case 3: {
                            return new Thing(interp.addTimer(argv[2], milli).getName());
                        }
                        case 2: {
                            HeclTask t = interp.addTimer(Thing.emptyThing(), milli);
                            while (!t.isDone()) {
                                interp.doOneEvent(-2);
                            }
                            break block2;
                        }
                        default: {
                            throw HeclException.createWrongNumArgsException(argv, 2, "script");
                        }
                    }
                }
                throw new HeclException("Unknown after option '" + subcmd + "'.");
            }
            case 17: {
                subcmd = argv[1].toString();
                interp.waitForToken(argv[1].toString());
                break;
            }
            case 18: {
                interp.notifyToken(argv[1].toString());
                break;
            }
            case 16: {
                System.err.println("bgerror - " + argv[1].toString());
                break;
            }
            case 10: {
                retval = 0;
                if (argv.length > 1) {
                    retval = IntThing.get(argv[1]);
                }
                System.exit(retval);
                break;
            }
            case 11: {
                Object save = null;
                Thing code = null;
                int level = -1;
                if (argv.length == 2) {
                    code = argv[1];
                } else if (argv.length == 3) {
                    code = argv[2];
                    level = IntThing.get(argv[1]);
                }
                return interp.eval(code, level);
            }
            case 12: {
                int times = 1;
                if (argv.length > 2) {
                    times = NumberThing.asNumber(argv[2]).intValue();
                }
                long then = new Date().getTime();
                while (times > 0) {
                    interp.eval(argv[1]);
                    --times;
                }
                return LongThing.create(new Date().getTime() - then);
            }
            case 70: {
                retval = 0;
                try {
                    retval = null != Class.forName(argv[1].toString()) ? 1 : 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return IntThing.create(retval);
            }
            case 80: {
                return new Thing("<" + argv[1].getVal().thingclass() + ">");
            }
            case 100: {
                return ObjectThing.create(interp);
            }
            case 19: {
                System.gc();
                break;
            }
            case 20: {
                String s = System.getProperty(argv[1].toString());
                return new Thing(s != null ? s : "");
            }
            case 21: {
                return IntThing.create(System.getProperty(argv[1].toString()) != null ? 1 : 0);
            }
            case 22: {
                subcmd = argv[1].toString();
                long l = System.currentTimeMillis();
                if (subcmd.equals("seconds")) {
                    return LongThing.create(l / 1000L);
                }
                if (subcmd.equals("time") || subcmd.equals("milli")) {
                    return LongThing.create(l);
                }
                if (subcmd.equals("format")) {
                    if (argv.length == 3) {
                        return new Thing(new ListThing(new Date(LongThing.get(argv[2])).toString()));
                    }
                    throw HeclException.createWrongNumArgsException(argv, 2, "?milli?");
                }
                throw HeclException.createWrongNumArgsException(argv, 1, "option ?time?");
            }
            case 23: {
                return LongThing.create(Runtime.getRuntime().freeMemory());
            }
            case 24: {
                return LongThing.create(Runtime.getRuntime().totalMemory());
            }
            default: {
                throw new HeclException("Unknown interp command '" + argv[0].toString() + "' with code '" + cmd + "'.");
            }
        }
        return null;
    }

    public static void load(Interp ip) throws HeclException {
        Operator.load(ip, cmdtable);
    }

    public static void unload(Interp ip) throws HeclException {
        Operator.unload(ip, cmdtable);
    }

    private InterpCmds(int cmdcode, int minargs, int maxargs) {
        super(cmdcode, minargs, maxargs);
    }

    static {
        cmdtable.put("set", new InterpCmds(1, 1, 2));
        cmdtable.put("unset", new InterpCmds(2, 1, 1));
        cmdtable.put("proc", new InterpCmds(3, 2, 3));
        cmdtable.put("rename", new InterpCmds(4, 2, 2));
        cmdtable.put("alias", new InterpCmds(25, 2, 2));
        cmdtable.put("eval", new InterpCmds(5, 1, 1));
        cmdtable.put("global", new InterpCmds(6, 0, -1));
        cmdtable.put("intro", new InterpCmds(7, 1, -1));
        cmdtable.put("return", new InterpCmds(8, 0, 1));
        cmdtable.put("catch", new InterpCmds(9, 1, 2));
        cmdtable.put("throw", new InterpCmds(14, 1, 2));
        cmdtable.put("exit", new InterpCmds(10, 0, 1));
        cmdtable.put("upeval", new InterpCmds(11, 1, 2));
        cmdtable.put("time", new InterpCmds(12, 1, 2));
        cmdtable.put("after", new InterpCmds(15, 1, -1));
        cmdtable.put("bgerror", new InterpCmds(16, 1, 1));
        cmdtable.put("twait", new InterpCmds(17, 1, 1));
        cmdtable.put("tnotify", new InterpCmds(18, 1, 1));
        cmdtable.put("copy", new InterpCmds(13, 1, 1));
        cmdtable.put("system.gc", new InterpCmds(19, 0, 0));
        cmdtable.put("system.getproperty", new InterpCmds(20, 1, 1));
        cmdtable.put("system.hasproperty", new InterpCmds(21, 1, 1));
        cmdtable.put("clock", new InterpCmds(22, 1, 2));
        cmdtable.put("runtime.freememory", new InterpCmds(23, 0, 0));
        cmdtable.put("runtime.totalmemory", new InterpCmds(24, 0, 0));
        cmdtable.put("hasclass", new InterpCmds(70, 1, 1));
        cmdtable.put("classof", new InterpCmds(80, 1, 1));
        cmdtable.put("thisinterp", new InterpCmds(100, 0, 0));
    }
}

