/*
 * Decompiled with CFR 0.152.
 */
package org.hecl;

import org.hecl.HeclException;
import org.hecl.IntegralThing;
import org.hecl.NumberThing;
import org.hecl.RealThing;
import org.hecl.Thing;

public class IntThing
extends IntegralThing {
    public static IntThing ZERO = new IntThing(0);
    public static IntThing ONE = new IntThing(1);
    public static IntThing NEGONE = new IntThing(-1);
    private int val;

    public IntThing() {
        this.val = 0;
    }

    public IntThing(int i) {
        this.val = i;
    }

    public IntThing(boolean b) {
        this.val = b ? 1 : 0;
    }

    public IntThing(String s) {
        this.set(Integer.parseInt(s));
    }

    @Override
    public String thingclass() {
        return "int";
    }

    public static Thing create(int i) {
        return new Thing(new IntThing(i));
    }

    public static Thing create(boolean b) {
        return new Thing(new IntThing(b));
    }

    private static void set(Thing thing) throws HeclException {
        RealThing realthing = thing.getVal();
        if (realthing instanceof IntThing) {
            return;
        }
        if (NumberThing.isNumber(realthing)) {
            thing.setVal(new IntThing(((NumberThing)realthing).intValue()));
        } else {
            thing.setVal(new IntThing(thing.toString()));
        }
    }

    public static int get(Thing thing) throws HeclException {
        return NumberThing.asNumber(thing).intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.val;
    }

    @Override
    public short shortValue() {
        return (short)this.val;
    }

    @Override
    public int intValue() {
        return this.val;
    }

    @Override
    public long longValue() {
        return this.val;
    }

    @Override
    public float floatValue() {
        return this.val;
    }

    @Override
    public double doubleValue() {
        return this.val;
    }

    public void set(int i) {
        this.val = i;
    }

    @Override
    public RealThing deepcopy() {
        return new IntThing(this.val);
    }

    @Override
    public String getStringRep() {
        return Integer.toString(this.val);
    }
}

