/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import net.sf.drawj2d.cmd.Fkt;
import no.geosoft.cc.geometry.Geometry;

public class clKraft {
    public static boolean debug = false;
    protected boolean GESPERRT = false;
    protected boolean ZUERSTBERECHNEN = true;
    protected boolean HATGE\u00c4NDERT = false;
    private double Fx;
    private double Fy;
    private double x0;
    private double y0;

    public clKraft(double Fx, double Fy, double x0, double y0) {
        this.setKraftIntern(Fx, Fy, x0, y0);
    }

    public clKraft() {
        this.setKraftIntern(0.0, 0.0, 0.0, 0.0);
    }

    protected void setKraftIntern(double Fx, double Fy, double x0, double y0) {
        this.Fx = Fx;
        this.Fy = Fy;
        this.x0 = x0;
        this.y0 = y0;
    }

    public void setKraft(double Fx, double Fy, double x0, double y0) {
        if (this.GESPERRT) {
            System.err.println("[clKraft] Fehler: die Kraft darf nicht ueberschrieben werden!");
            assert (false);
        } else {
            this.setKraftIntern(Fx, Fy, x0, y0);
            this.HATGE\u00c4NDERT = true;
            this.ZUERSTBERECHNEN = true;
        }
    }

    public void setKraft(double Fx, double Fy) {
        if (this.GESPERRT) {
            System.err.println("[clKraft] Fehler: die Kraft darf nicht ueberschrieben werden!");
            assert (false);
        } else {
            this.Fx = Fx;
            this.Fy = Fy;
            this.HATGE\u00c4NDERT = true;
            this.ZUERSTBERECHNEN = true;
        }
    }

    public void setPkt(double x0, double y0) {
        if (this.GESPERRT) {
            System.err.println("[clKraft] Fehler: die Kraft darf nicht ueberschrieben werden!");
            assert (false);
        } else {
            this.x0 = x0;
            this.y0 = y0;
            this.HATGE\u00c4NDERT = true;
            this.ZUERSTBERECHNEN = true;
        }
    }

    public double[] F() {
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        double[] F = new double[]{this.Fx, this.Fy};
        return F;
    }

    public double f() {
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        return Math.sqrt(this.Fx * this.Fx + this.Fy * this.Fy);
    }

    public double[] pkt() {
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        double[] pkt = new double[]{this.x0, this.y0};
        return pkt;
    }

    protected boolean berechnen() {
        this.ZUERSTBERECHNEN = false;
        return true;
    }

    public boolean setAngriffspktAufLinie(double[] pktA, double[] pktB) {
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        boolean schneidensich = false;
        double[] schnittpunkt = new double[2];
        schneidensich = this.getAngriffspktAufLinie(pktA, pktB, schnittpunkt);
        if (schneidensich) {
            this.x0 = schnittpunkt[0];
            this.y0 = schnittpunkt[1];
        }
        return schneidensich;
    }

    public boolean getAngriffspktAufLinie(double[] pktA, double[] pktB, double[] schnittpunkt) {
        assert (schnittpunkt.length == 2);
        return this.getAngriffspktAufLinie(pktA[0], pktA[1], pktB[0], pktB[1], schnittpunkt);
    }

    public boolean getAngriffspktAufLinie(double x1, double y1, double x2, double y2, double[] schnittpunkt) {
        assert (schnittpunkt.length == 2);
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        boolean ok = false;
        double[] intersection = new double[2];
        int fall = Geometry.findLineSegmentIntersection(this.x0, this.y0, this.x0 + this.Fx, this.y0 + this.Fy, x1, y1, x2, y2, intersection);
        switch (fall) {
            case 0: 
            case 1: {
                ok = true;
                break;
            }
            case -2: {
                intersection[0] = this.x0;
                intersection[1] = this.y0;
                if (debug) {
                    System.out.println("[clKraft] Hinweis: Linien aufeinanderliegend");
                }
                ok = true;
                break;
            }
            default: {
                if (debug) {
                    System.out.println("clKraft: Kein Schnittpunkt, da Linien parallel");
                }
                intersection[0] = this.x0;
                intersection[1] = this.y0;
                ok = false;
            }
        }
        schnittpunkt[0] = intersection[0];
        schnittpunkt[1] = intersection[1];
        return ok;
    }

    public double getM(double[] bezugspunkt) {
        assert (bezugspunkt.length == 2);
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        double dx = this.x0 - bezugspunkt[0];
        double dy = this.y0 - bezugspunkt[1];
        double M = dx * this.Fy - dy * this.Fx;
        return M;
    }

    public void print() {
        System.out.println(this.text());
    }

    public String text() {
        if (this.ZUERSTBERECHNEN) {
            this.berechnen();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Fx= " + Fkt.nf(this.Fx, 1));
        sb.append(", Fy= " + Fkt.nf(this.Fy, 1));
        sb.append(", |F|= " + Fkt.nf(this.f(), 1) + "kN ");
        sb.append(", x=" + Fkt.nf(this.x0, 3, 3));
        sb.append(", y=" + Fkt.nf(this.y0, 3, 3));
        String text = sb.toString();
        return text;
    }

    public static void main(String[] args) {
        double Fx = 0.0;
        double Fy = -100.0;
        double x0 = 4.0;
        double y0 = 10.0;
        clKraft F = new clKraft(Fx, Fy, x0, y0);
        double xA = 1.0;
        double yA = 1.0;
        double xB = 2.0;
        double yB = 3.0;
        double[] schnittpunkt = new double[2];
        boolean geschnitten = F.getAngriffspktAufLinie(xA, yA, xB, yB, schnittpunkt);
        if (!geschnitten) {
            System.out.println("Kein Schnittpunkt!");
        } else {
            System.out.println("x = " + Fkt.nf(schnittpunkt[0], 3));
            System.out.println("y = " + Fkt.nf(schnittpunkt[1], 3));
        }
    }
}

