/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.statics;

import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class StatMultiplyCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        if (argv.length != 3) {
            throw new HeclException("Illegal nb of arguments.");
        }
        Thing[] factorargv = ListThing.getArray(argv[1]);
        if (factorargv.length != 1) {
            throw new HeclException("Illegal argument format. 'nb \"nb nb nb nb\"' expected.");
        }
        double factor = NumberThing.asNumber(factorargv[0]).doubleValue();
        Thing[] currentargv = ListThing.getArray(argv[2]);
        if (currentargv.length != 4) {
            throw new HeclException("Illegal argument format. 'nb \"x0 y0 Fx Fy\"' expected.");
        }
        double x0 = NumberThing.asNumber(currentargv[0]).doubleValue();
        double y0 = NumberThing.asNumber(currentargv[1]).doubleValue();
        double Fx = NumberThing.asNumber(currentargv[2]).doubleValue();
        double Fy = NumberThing.asNumber(currentargv[3]).doubleValue();
        String xstr = StringThing.get(DoubleThing.create(x0));
        String ystr = StringThing.get(DoubleThing.create(y0));
        String Fxstr = StringThing.get(DoubleThing.create(Fx *= factor));
        String Fystr = StringThing.get(DoubleThing.create(Fy *= factor));
        String answer = xstr + " " + ystr + " " + Fxstr + " " + Fystr;
        return new Thing(answer);
    }
}

