/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomToxCmd
implements Command {
    API api;
    boolean isX;
    boolean debug = false;

    public GeomToxCmd(API api, boolean isX) {
        this.api = api;
        this.isX = isX;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        double x1 = this.api.here()[0];
        double y1 = this.api.here()[1];
        switch (argd.length) {
            case 2: {
                if (this.isX) {
                    x1 = argd[0];
                    break;
                }
                y1 = argd[1];
                break;
            }
            case 1: {
                if (this.isX) {
                    x1 = argd[0];
                    break;
                }
                y1 = argd[0];
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        String xstr = StringThing.get(DoubleThing.create(x1));
        String ystr = StringThing.get(DoubleThing.create(y1));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

