/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import no.geosoft.cc.geometry.Geometry;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomIntersectlinepathCmd
implements Command {
    boolean debug = false;

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        double[] intersection;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        if (argd.length >= 8 && argd.length % 2 == 0) {
            assert ((argd.length - 4) % 2 == 0) : "nb of arguments not even";
            int n = (argd.length - 4) / 2;
            double[] pathx = new double[n];
            double[] pathy = new double[n];
            for (int i = 0; i < n; ++i) {
                pathx[i] = argd[4 + 2 * i];
                pathy[i] = argd[5 + 2 * i];
            }
            intersection = new double[2];
            boolean intersectionfound = false;
            block8: for (int i = 1; i < n && !intersectionfound; ++i) {
                int intersectionType = Geometry.findLineSegmentIntersection(argd[0], argd[1], argd[2], argd[3], pathx[i - 1], pathy[i - 1], pathx[i], pathy[i], intersection);
                switch (intersectionType) {
                    case 1: {
                        intersectionfound = true;
                        continue block8;
                    }
                    case 0: {
                        double[] ponline = Geometry.computePointOnLine(argd[0], argd[1], intersection[0], intersection[1], 1.1);
                        int intersectionTypePath = Geometry.findLineSegmentIntersection(argd[0], argd[1], ponline[0], ponline[1], pathx[i - 1], pathy[i - 1], pathx[i], pathy[i], intersection);
                        if (intersectionTypePath == 1) {
                            intersectionfound = true;
                            continue block8;
                        }
                        assert (intersectionTypePath == 0);
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                    case -2: {
                        if (!this.debug) continue block8;
                        System.out.println("Linien aufeinander liegend");
                        continue block8;
                    }
                    default: {
                        assert (false);
                        continue block8;
                    }
                }
            }
            if (!intersectionfound) {
                String answer = "none none";
                throw new HeclException("No intersection point.");
            }
        } else {
            throw new HeclException("Illegal nb of arguments.");
        }
        String xstr = StringThing.get(DoubleThing.create(intersection[0]));
        String ystr = StringThing.get(DoubleThing.create(intersection[1]));
        String answer = xstr + " " + ystr;
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

