/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd.geom;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.drawj2d.cmd.API;
import org.hecl.Command;
import org.hecl.DoubleThing;
import org.hecl.HeclException;
import org.hecl.Interp;
import org.hecl.ListThing;
import org.hecl.NumberThing;
import org.hecl.StringThing;
import org.hecl.Thing;

public class GeomAngleRadCmd
implements Command {
    API api;
    boolean debug = false;

    public GeomAngleRadCmd(API api) {
        this.api = api;
    }

    @Override
    public Thing cmdCode(Interp interp, Thing[] argv) throws HeclException {
        String answer;
        assert (argv.length > 0);
        if (this.debug) {
            System.out.println(argv[0].toString());
        }
        ArrayList<Thing> singleargv = this.splitArgv(argv);
        int nbsingleargs = singleargv.size();
        double[] argd = new double[nbsingleargs];
        for (int i = 0; i < nbsingleargs; ++i) {
            argd[i] = NumberThing.asNumber(singleargv.get(i)).doubleValue();
        }
        switch (argd.length) {
            case 6: {
                double dir2 = Math.atan2(argd[5] - argd[1], argd[4] - argd[0]);
                double dir1 = Math.atan2(argd[3] - argd[1], argd[2] - argd[0]);
                double anglerad = dir2 - dir1;
                if (anglerad < 0.0) {
                    anglerad += Math.PI * 2;
                }
                answer = StringThing.get(DoubleThing.create(anglerad));
                break;
            }
            case 4: {
                double[] here = this.api.here();
                double dirrel2 = Math.atan2(argd[3] - here[1], argd[2] - here[0]);
                double dirrel1 = Math.atan2(argd[1] - here[1], argd[0] - here[0]);
                double anglerelrad = dirrel2 - dirrel1;
                if (anglerelrad < 0.0) {
                    anglerelrad += Math.PI * 2;
                }
                answer = StringThing.get(DoubleThing.create(anglerelrad));
                break;
            }
            case 2: {
                double dirrad = Math.atan2(argd[1], argd[0]);
                answer = StringThing.get(DoubleThing.create(dirrad));
                break;
            }
            default: {
                throw new HeclException("Illegal nb of arguments.");
            }
        }
        return new Thing(answer);
    }

    private ArrayList<Thing> splitArgv(Thing[] argv) throws HeclException {
        ArrayList<Thing> singleargv = new ArrayList<Thing>(argv.length);
        for (int i = 1; i < argv.length; ++i) {
            Thing[] currentargv = ListThing.getArray(argv[i]);
            singleargv.addAll(Arrays.asList(currentargv));
        }
        return singleargv;
    }
}

