/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d.cmd;

public final class Fkt {
    public static double fix(double zahl, int anzStellen) {
        double erweitern = Math.pow(10.0, anzStellen);
        return (double)Math.round(erweitern * zahl) / erweitern;
    }

    public static double max(double[] liste) {
        double maximal = liste[0];
        for (int i = 0; i < liste.length; ++i) {
            if (!(liste[i] > maximal)) continue;
            maximal = liste[i];
        }
        return maximal;
    }

    public static double max(double[][] liste) {
        double maximal = liste[0][0];
        for (int i = 0; i < liste.length; ++i) {
            for (int j = 0; j < liste[i].length; ++j) {
                if (!(liste[i][j] > maximal)) continue;
                maximal = liste[i][j];
            }
        }
        return maximal;
    }

    public static double min(double[] liste) {
        double minimal = liste[0];
        for (int i = 0; i < liste.length; ++i) {
            if (!(liste[i] < minimal)) continue;
            minimal = liste[i];
        }
        return minimal;
    }

    public static double[] GLS2x2(double ax1, double ax2, double bx, double az1, double az2, double bz) {
        if (Fkt.det2x2(ax1, ax2, az1, az2) == 0.0) {
            System.err.println("Warnung: Determinante = 0, eventuell falsche Resultate!");
        }
        double[] s = new double[2];
        if (Math.abs(ax1) > Math.abs(az1)) {
            s[1] = (bz - bx * az1 / ax1) / (az2 - ax2 * az1 / ax1);
            s[0] = (bx - ax2 * s[1]) / ax1;
            return s;
        }
        s[1] = (bx - bz * ax1 / az1) / (ax2 - az2 * ax1 / az1);
        s[0] = (bz - az2 * s[1]) / az1;
        return s;
    }

    public static double det2x2(double ax1, double ax2, double az1, double az2) {
        return ax1 * az2 - ax2 * az1;
    }

    public static double[] kreuzprodukt(double ux, double uy, double uz, double vx, double vy, double vz) {
        double[] vektor = new double[]{Fkt.det2x2(uy, vy, uz, vz), Fkt.det2x2(uz, vz, ux, vx), Fkt.det2x2(ux, vx, uy, vy)};
        return vektor;
    }

    public static double vektorbetrag(double[] vektor) {
        assert (vektor.length > 0);
        double l\u00e4nge = 0.0;
        for (int i = 0; i < vektor.length; ++i) {
            l\u00e4nge += vektor[i] * vektor[i];
        }
        return Math.sqrt(l\u00e4nge);
    }

    public static double[] normiere(double[] vektor) {
        assert (vektor.length > 0);
        double nenner = 0.0;
        for (int i = 0; i < vektor.length; ++i) {
            nenner += vektor[i] * vektor[i];
        }
        nenner = Math.sqrt(nenner);
        double[] normiert = new double[vektor.length];
        for (int i = 0; i < vektor.length; ++i) {
            normiert[i] = vektor[i] / nenner;
        }
        return normiert;
    }

    public static String nf(int zahl, int minimaleAnzahlStellen) {
        if (minimaleAnzahlStellen < 1) {
            System.err.print("Formatierungsfehler: minimale Anzahlstellen: ");
            System.err.println(minimaleAnzahlStellen + " < 1");
        }
        StringBuffer ausg = new StringBuffer();
        ausg.append(zahl);
        while (ausg.length() < minimaleAnzahlStellen) {
            ausg.insert(0, " ");
        }
        return ausg.toString();
    }

    public static String nf(double zahl, int AnzNachkommaStellen) {
        if (Double.isNaN(zahl)) {
            return "NaN";
        }
        if (Double.isInfinite(zahl)) {
            if (zahl == Double.NEGATIVE_INFINITY) {
                return "-oo";
            }
            return "+oo";
        }
        StringBuffer ausg = new StringBuffer();
        if (AnzNachkommaStellen < 0) {
            System.err.print("Formatierungsfehler: Anzahl Nachkommastellen: ");
            System.err.println(AnzNachkommaStellen + " < 0");
            ausg.append(zahl);
            return ausg.toString();
        }
        double gerundet = Fkt.fix(zahl, AnzNachkommaStellen);
        if (AnzNachkommaStellen == 0) {
            ausg.append((int)gerundet);
        } else {
            ausg.append(gerundet);
            int vorhNkst = ausg.length() - 1 - ausg.indexOf(".");
            if (ausg.indexOf("E") < 0) {
                for (int i = vorhNkst; i < AnzNachkommaStellen; ++i) {
                    ausg.append("0");
                }
            }
        }
        return ausg.toString();
    }

    public static String nf(double zahl, int AnzNachkommaStellen, int minAnzStellenVorKomma) {
        StringBuffer ausg = new StringBuffer();
        if (AnzNachkommaStellen < 0 || minAnzStellenVorKomma < 0) {
            System.err.println("Formatierungsfehler");
            ausg.append(zahl);
            return ausg.toString();
        }
        ausg.append(Fkt.nf(zahl, AnzNachkommaStellen));
        while (ausg.length() < minAnzStellenVorKomma + 1 + AnzNachkommaStellen) {
            ausg.insert(0, " ");
        }
        return ausg.toString();
    }

    public static double signum(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (a > 0.0) {
            return 1.0;
        }
        if (a < 0.0) {
            return -1.0;
        }
        return a;
    }
}

