/*
 * Decompiled with CFR 0.152.
 */
package net.sf.drawj2d;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sf.drawj2d.EpsgraphicsMode;
import net.sf.drawj2d.FreehepMode;
import net.sf.drawj2d.JREMode;
import net.sf.drawj2d.JtikzMode;
import net.sf.drawj2d.inConst;

public class Drawj2d
implements inConst {
    double width = 210.0;
    double height = 297.0;
    double originX = 0.0;
    double originY = 0.0;
    boolean docenter = false;
    String outputtype = "pdf";
    String quelldatei;
    String zieldatei;
    boolean zieldateigesetzt = false;
    double res;
    boolean resgesetzt = false;
    boolean verbose = false;
    boolean quiet = false;
    static final int ModeJRE = 1;
    static final int ModeFreehep = 2;
    static final int ModeEpsgraphics = 4;
    static final int ModeJtikz = 5;
    int mode;
    boolean defaultmode = true;
    int srcType = 101;
    private String[] iArgs;
    private static final String PGM = "Drawj2d";
    private static final String VERSION = "0.83";
    private static final String USAGE_en = "Usage:\njava -jar drawj2d.jar  [-TWHcXYrfvqhV] \n                       [-o OutputFile]  \n                       [InputFile] \n\n-T, --type                Output file type: pdf, svg, eps, emf, png \n                                            screen (displays the drawing) \n-W, --width               Graphics width (default 210mm)\n-H, --height              Graphics height (default 297mm)\n-c, --center              Set origin to center of sheet, instead of top left\n-X, --originx             Offset origin right (default 0mm) \n-Y, --originy             Offset origin down (default 0mm) \n-r, --resolution          Resolution of images (default 200dpi), svg (96dpi)\n-f, --fallback            Fallback mode\n-F, --frontend            Input file type: hcl (default), bgd, ypd\n-v, --verbose             Verbose output\n-q, --quiet               No messages to stdout\n-h, --help                Usage information; this help screen\n-V, --version             Display version\n-o  --outfile OutputFile  OutputFile name (default: out-filename)\nInputFile                 InputFile. If omitted reads from stdin\n\nExamples:\njava -jar drawj2d.jar mydrawing.hcl \njava -jar drawj2d.jar -T png -W 100 -H 150 -X 50 -Y 75 mydrawing.hcl \njava -jar drawj2d.jar -T svg mydrawing.hcl \n";

    public Drawj2d(String[] args) {
        this.iArgs = args;
    }

    private void startinfo() {
        System.out.println("");
        System.out.println("            Welcome to Drawj2d");
        System.out.println("            Copyright (c) A. Vontobel, 2014-2017");
        System.out.println("            Version 0.83");
        System.out.println("");
    }

    public void usage(int exitStatus) {
        this.startinfo();
        System.out.println(USAGE_en);
        System.exit(exitStatus);
    }

    public void parseArguments() {
        String suffix;
        int c;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("verbose", 0, null, 118), new LongOpt("quiet", 0, null, 113), new LongOpt("version", 0, null, 86), new LongOpt("outfile", 1, null, 111), new LongOpt("type", 1, null, 84), new LongOpt("width", 1, null, 87), new LongOpt("height", 1, null, 72), new LongOpt("originx", 1, null, 88), new LongOpt("originy", 1, null, 89), new LongOpt("fallback", 0, null, 102), new LongOpt("resolution", 1, null, 114), new LongOpt("center", 0, null, 99), new LongOpt("frontend", 1, null, 70)};
        Getopt g = new Getopt(PGM, this.iArgs, ":T:W:H:X:Y:r:F:o:cfvqhV", longopts);
        g.setOpterr(false);
        block28: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 118: {
                    this.verbose = true;
                    continue block28;
                }
                case 113: {
                    this.verbose = false;
                    this.quiet = true;
                    continue block28;
                }
                case 104: {
                    this.usage(0);
                    continue block28;
                }
                case 86: {
                    this.startinfo();
                    System.exit(0);
                    continue block28;
                }
                case 84: {
                    this.outputtype = g.getOptarg();
                    continue block28;
                }
                case 102: {
                    this.defaultmode = false;
                    continue block28;
                }
                case 87: {
                    String widthstring = g.getOptarg();
                    try {
                        this.width = Double.parseDouble(widthstring);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Width not an Number");
                        this.usage(1);
                    }
                    continue block28;
                }
                case 72: {
                    String heightstring = g.getOptarg();
                    try {
                        this.height = Double.parseDouble(heightstring);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Height not an Number");
                        this.usage(1);
                    }
                    continue block28;
                }
                case 99: {
                    this.docenter = true;
                    continue block28;
                }
                case 88: {
                    String originxstring = g.getOptarg();
                    try {
                        this.originX = Double.parseDouble(originxstring);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Origin x position not an Number");
                        this.usage(1);
                    }
                    continue block28;
                }
                case 89: {
                    String originystring = g.getOptarg();
                    try {
                        this.originY = Double.parseDouble(originystring);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Origin y position not an Number");
                        this.usage(1);
                    }
                    continue block28;
                }
                case 114: {
                    String resstring = g.getOptarg();
                    try {
                        this.res = Double.parseDouble(resstring);
                        this.resgesetzt = this.res > 0.0;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Resolution not an Number");
                        this.usage(1);
                    }
                    continue block28;
                }
                case 70: {
                    String srcTypestring = g.getOptarg();
                    if (srcTypestring.equalsIgnoreCase("hcl")) {
                        this.srcType = 101;
                        continue block28;
                    }
                    if (srcTypestring.equalsIgnoreCase("bgd")) {
                        this.srcType = 102;
                        continue block28;
                    }
                    if (srcTypestring.equalsIgnoreCase("ypd")) {
                        this.srcType = 103;
                        continue block28;
                    }
                    System.err.println("Unknown frontend: " + srcTypestring);
                    System.err.println("Expected: hcl | bgd | ypd");
                    this.usage(1);
                    continue block28;
                }
                case 111: {
                    this.zieldatei = g.getOptarg();
                    if (this.zieldatei.equals("-")) {
                        System.err.println("Output to stdout not implemented.");
                    }
                    this.zieldateigesetzt = true;
                    continue block28;
                }
                case 58: {
                    System.err.println("Missing Argument " + (char)g.getOptopt());
                    this.usage(1);
                    continue block28;
                }
                case 63: {
                    System.err.println("Option Not Valid " + (char)g.getOptopt());
                    this.usage(1);
                    continue block28;
                }
            }
            this.usage(1);
        }
        String[] iDateien = new String[this.iArgs.length - g.getOptind()];
        for (int i = g.getOptind(); i < this.iArgs.length; ++i) {
            iDateien[i - g.getOptind()] = this.iArgs[i];
        }
        this.quelldatei = iDateien.length < 1 ? "_opt_stdin" : iDateien[0];
        if (iDateien.length > 1) {
            System.err.println("Max one file");
        }
        if (!this.zieldateigesetzt) {
            if (this.quelldatei.equals("_opt_stdin")) {
                this.zieldatei = "out." + this.outputtype.toLowerCase();
            } else {
                File d = new File(this.quelldatei);
                this.zieldatei = d.getParent() == null ? "out-" + d.getName() : d.getParent() + System.getProperty("file.separator") + "out-" + d.getName();
                if (this.zieldatei.endsWith(".hcl")) {
                    this.zieldatei = this.zieldatei.substring(0, this.zieldatei.lastIndexOf(".hcl"));
                }
                this.zieldatei = this.zieldatei + "." + this.outputtype.toLowerCase();
            }
        }
        if (this.docenter) {
            this.originX = this.width / 2.0;
            this.originY = this.height / 2.0;
        }
        this.mode = (suffix = this.outputtype.toLowerCase()).equals("pdf") || suffix.equals("svg") ? 2 : (suffix.equals("eps") || suffix.equals("ps") ? (this.defaultmode ? 4 : 2) : (suffix.equals("tikz") || suffix.equals("jtikz") ? 5 : (suffix.equals("screen") ? 1 : (this.defaultmode ? 2 : 1))));
    }

    public static void Run(String[] args) {
        boolean success;
        if (args.length == 1 && args[0].equals("TESTRUN")) {
            Drawj2d.test("png");
            return;
        }
        Drawj2d c = new Drawj2d(args);
        c.parseArguments();
        if (!c.quiet) {
            c.startinfo();
        }
        switch (c.mode) {
            case 2: {
                FreehepMode mF = new FreehepMode(c);
                if (c.resgesetzt) {
                    mF.setResolution(c.res);
                }
                success = mF.run();
                break;
            }
            case 4: {
                EpsgraphicsMode mE = new EpsgraphicsMode(c);
                if (c.resgesetzt) {
                    mE.setResolution(c.res);
                }
                success = mE.run();
                break;
            }
            case 5: {
                JtikzMode mt = new JtikzMode(c);
                if (c.resgesetzt) {
                    mt.setResolution(c.res);
                }
                success = mt.run();
                break;
            }
            default: {
                JREMode mJ = new JREMode(c);
                if (c.resgesetzt) {
                    mJ.setResolution(c.res);
                }
                success = mJ.run();
            }
        }
        if (!c.outputtype.equalsIgnoreCase("screen")) {
            if (success) {
                System.out.println("Done!");
            } else {
                if (c.verbose) {
                    System.out.println("ERROR occured! Drawj2d quits.");
                }
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        Drawj2d.Run(args);
    }

    static void drawGraph(Graphics2D g) {
        double x;
        g.setStroke(new BasicStroke(0.35f));
        g.setColor(Color.RED);
        g.fillOval(20, 30, 100, 150);
        g.setClip(new Ellipse2D.Double(70.0, 80.0, 50.0, 100.0));
        g.setColor(Color.BLACK);
        for (x = 0.0; x < 210.0; x += 2.0) {
            g.draw(new Line2D.Double(x, 0.0, x, 297.0));
        }
        g.setClip(null);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.BLUE);
        for (x = 0.0; x < 210.0; x += 5.0) {
            g.draw(new Line2D.Double(x, 0.0, x, 297.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(String suffix) {
        String[] IOsuffixes;
        double width = 210.0;
        double height = 297.0;
        int type = 0;
        for (String t : IOsuffixes = ImageIO.getWriterFileSuffixes()) {
            if (!t.equals(suffix)) continue;
            type = 5;
        }
        String filename = "export." + suffix;
        switch (type) {
            case 5: {
                break;
            }
            default: {
                System.err.println("Not supported for test: " + suffix);
                return;
            }
        }
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(filename);
            int imgtype = 2;
            if (suffix.equals("jpeg") || suffix.equals("jpg") || suffix.equals("bmp")) {
                imgtype = 1;
            }
            if (suffix.equals("wbmp")) {
                imgtype = 12;
            }
            float res = 7.874016f;
            BufferedImage bi = new BufferedImage((int)(width * (double)res), (int)(height * (double)res), imgtype);
            Graphics2D ig2 = bi.createGraphics();
            ig2.scale(res, res);
            Drawj2d.drawGraph(ig2);
            ImageIO.write((RenderedImage)bi, suffix, file);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Drawj2d.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Drawj2d.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Drawj2d.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

