/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util;

public class TimeSpanFormatter {
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int SECONDS_IN_HOUR = 3600;
    public static final int SECONDS_IN_DAY = 86400;

    public static String formatDigit(long d) {
        StringBuilder result = new StringBuilder();
        if (d < 10L) {
            result.append('0');
        }
        result.append(d);
        return result.toString();
    }

    public static String formatTime(long seconds) {
        StringBuilder result = new StringBuilder();
        long days = seconds / 86400L;
        long hours = (seconds -= days * 86400L) / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        seconds -= minutes * 60L;
        if (days > 0L) {
            result.append(days);
            result.append(" days, ");
        }
        result.append(TimeSpanFormatter.formatDigit(hours));
        result.append(':');
        result.append(TimeSpanFormatter.formatDigit(minutes));
        result.append(':');
        result.append(TimeSpanFormatter.formatDigit(seconds));
        return result.toString();
    }

    private TimeSpanFormatter() {
    }
}

