/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter {
    private final String[] extensions;
    private final String description;

    public static String getExtension(File file) {
        String filename = file.getName();
        String ext = filename.lastIndexOf(".") == -1 ? null : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        return ext;
    }

    public ExtensionFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ExtensionFilter(String description, String[] extensions) {
        this.description = description;
        this.extensions = (String[])extensions.clone();
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        int count = this.extensions.length;
        String path = file.getAbsolutePath();
        int i = 0;
        while (i < count) {
            String ext = this.extensions[i];
            if (path.endsWith(ext) && path.charAt(path.length() - ext.length()) == '.') {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description == null ? this.extensions[0] : this.description;
    }
}

