/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.encog.workbench.models.TrainingSetTableModel;

public class ExcelAdapter
implements ActionListener {
    private Clipboard system;
    private JTable table;
    private TrainingSetTableModel model;

    public ExcelAdapter(JTable table) {
        if (!(table.getModel() instanceof TrainingSetTableModel)) {
            System.out.println(table.getModel());
            throw new RuntimeException("Table model not supported by ExcelAdapter.");
        }
        this.model = (TrainingSetTableModel)table.getModel();
        this.table = table;
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        this.table.registerKeyboardAction(this, "Copy", copy, 0);
        this.table.registerKeyboardAction(this, "Paste", paste, 0);
        this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public JTable getJTable() {
        return this.table;
    }

    public void setJTable(JTable jTable1) {
        this.table = jTable1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("Copy") == 0) {
            StringBuffer sbf = new StringBuffer();
            int numcols = this.table.getSelectedColumnCount();
            int numrows = this.table.getSelectedRowCount();
            int[] rowsselected = this.table.getSelectedRows();
            int[] colsselected = this.table.getSelectedColumns();
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            int i = 0;
            while (i < numrows) {
                int j = 0;
                while (j < numcols) {
                    sbf.append(this.table.getValueAt(rowsselected[i], colsselected[j]));
                    if (j < numcols - 1) {
                        sbf.append("\t");
                    }
                    ++j;
                }
                sbf.append("\n");
                ++i;
            }
            StringSelection stsel = new StringSelection(sbf.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(stsel, stsel);
        }
        if (e.getActionCommand().compareTo("Paste") == 0) {
            int startRow = this.table.getSelectedRows()[0];
            int startCol = this.table.getSelectedColumns()[0];
            try {
                String trstring = (String)this.system.getContents(this).getTransferData(DataFlavor.stringFlavor);
                StringTokenizer st1 = new StringTokenizer(trstring, "\n");
                int i = 0;
                while (st1.hasMoreTokens()) {
                    String rowstring = st1.nextToken();
                    StringTokenizer st2 = new StringTokenizer(rowstring, "\t");
                    int j = 0;
                    while (st2.hasMoreTokens()) {
                        String value = st2.nextToken();
                        this.setValue(value, startRow + i, startCol + j);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setValue(String value, int row, int column) {
        if (this.table.getRowCount() <= row) {
            this.model.addRow(-1);
        }
        this.table.setValueAt(value, row, column);
    }
}

