/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.models.TrainingListModel;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.grid.GridPanel;

public class VisualizeGridTab
extends EncogCommonTab
implements ListSelectionListener,
ActionListener {
    private BufferedMLDataSet data;
    private JScrollPane scroll;
    private JList list;
    private TrainingListModel model;
    private JTextField fieldWidth;
    private JTextField fieldHeight;
    private GridPanel grid;
    private JButton btnUpdate;

    public VisualizeGridTab(BufferedMLDataSet data) {
        super((ProjectFile)null);
        int width;
        this.data = data;
        this.setLayout(new BorderLayout());
        this.model = new TrainingListModel(data);
        this.list = new JList(this.model);
        this.scroll = new JScrollPane(this.list);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.add((Component)this.scroll, "West");
        this.list.addListSelectionListener(this);
        JPanel rightPanel = new JPanel();
        this.add((Component)rightPanel, "Center");
        rightPanel.setLayout(new BorderLayout());
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new FlowLayout(0));
        rightPanel.add((Component)upperPanel, "North");
        upperPanel.add(new JLabel("Grid Dimensions(h x w):"));
        this.fieldHeight = new JTextField(5);
        upperPanel.add(this.fieldHeight);
        upperPanel.add(new JLabel(" x "));
        this.fieldWidth = new JTextField(5);
        upperPanel.add(this.fieldWidth);
        this.btnUpdate = new JButton("Update");
        upperPanel.add(this.btnUpdate);
        this.grid = new GridPanel();
        rightPanel.add((Component)this.grid, "Center");
        int height = width = (int)Math.sqrt(this.data.getInputSize());
        while (width * height < this.data.getInputSize()) {
            ++height;
        }
        this.fieldHeight.setText("" + height);
        this.fieldWidth.setText("" + width);
        this.btnUpdate.addActionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.refresh();
    }

    @Override
    public void refresh() {
        int gridWidth;
        int gridHeight;
        int selected = this.list.getSelectedIndex();
        if (selected == -1) {
            return;
        }
        MLDataPair pair = BasicMLDataPair.createPair(this.data.getInputSize(), this.data.getIdealSize());
        this.data.getRecord(selected, pair);
        try {
            gridHeight = Integer.parseInt(this.fieldHeight.getText());
            if (gridHeight <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            EncogWorkBench.displayError("Error", "Invalid height.");
            return;
        }
        try {
            gridWidth = Integer.parseInt(this.fieldWidth.getText());
            if (gridHeight <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            EncogWorkBench.displayError("Error", "Invalid width.");
            return;
        }
        this.grid.updateData(gridHeight, gridWidth, pair.getInput().getData());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnUpdate) {
            this.refresh();
        }
    }

    @Override
    public String getName() {
        if (this.getEncogObject() == null) {
            return "Visualize";
        }
        return "Visualize :" + this.getEncogObject().getName();
    }
}

