/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.grid;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class GridPanel
extends JPanel {
    private static final int WIDTH = 5;
    private double[] data;
    private int gridWidth;
    private int gridHeight;

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        if (this.data == null) {
            g.drawString("Nothing selected", 10, 20);
            return;
        }
        int row = 0;
        while (row < this.gridHeight) {
            int col = 0;
            while (col < this.gridWidth) {
                int index = row * this.gridWidth + col;
                int x = col * 5;
                int y = row * 5;
                boolean selected = false;
                if (index < this.data.length) {
                    boolean bl = selected = this.data[index] > 0.0;
                }
                if (selected) {
                    g.fillRect(x, y, 5, 5);
                } else {
                    g.drawRect(x, y, 5, 5);
                }
                ++col;
            }
            ++row;
        }
    }

    public void updateData(int gridHeight, int gridWidth, double[] data) {
        this.data = data;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.repaint();
    }
}

