/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.training;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import javax.swing.JPanel;
import org.encog.workbench.EncogWorkBench;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    XYSeries series1;
    XYSeries series2;
    XYSeries series3;
    XYSeriesCollection dataset1;
    XYSeriesCollection dataset2;
    XYSeriesCollection dataset3;
    JFreeChart chart;
    ChartPanel chartPanel;
    int count;
    private boolean trackValidation;
    private boolean trackImprovement;

    public ChartPane(boolean trackValidation) {
        int historySize = EncogWorkBench.getInstance().getConfig().getTrainingHistory();
        this.trackValidation = trackValidation;
        this.trackImprovement = EncogWorkBench.getInstance().getConfig().isShowTrainingImprovement();
        this.series1 = new XYSeries((Comparable)((Object)"Current Error"));
        this.dataset1 = new XYSeriesCollection();
        this.dataset1.addSeries(this.series1);
        if (historySize > 0) {
            this.series1.setMaximumItemCount(Math.min(historySize, 100));
        }
        if (this.trackImprovement) {
            this.series2 = new XYSeries((Comparable)((Object)"Error Improvement"));
            this.dataset2 = new XYSeriesCollection();
            this.dataset2.addSeries(this.series2);
            if (historySize > 0) {
                this.series2.setMaximumItemCount(Math.min(historySize, 100));
            }
        }
        if (trackValidation) {
            this.series3 = new XYSeries((Comparable)((Object)"Validation Error"));
            this.dataset3 = new XYSeriesCollection();
            this.dataset3.addSeries(this.series3);
            if (historySize > 0) {
                this.series3.setMaximumItemCount(Math.min(historySize, 100));
            }
        }
        JFreeChart chart = this.createChart();
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.setPreferredSize(new Dimension(600, 270));
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
    }

    public void addData(int iteration, double error, double improvement, double val) {
        this.series1.add((double)iteration, error * 100.0);
        if (this.trackImprovement) {
            this.series2.add((double)iteration, improvement * 100.0);
        }
        if (this.trackValidation) {
            this.series3.add((double)iteration, val * 100.0);
        }
    }

    private JFreeChart createChart() {
        this.chart = ChartFactory.createXYLineChart(null, (String)"Iteration", (String)"Current Error", (XYDataset)this.dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.getRangeAxis().setFixedDimension(15.0);
        plot.getDomainAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        if (this.trackImprovement) {
            NumberAxis axis2 = new NumberAxis("Error Improvement");
            axis2.setFixedDimension(10.0);
            axis2.setAutoRangeIncludesZero(false);
            axis2.setLabelPaint((Paint)Color.red);
            axis2.setTickLabelPaint((Paint)Color.red);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setDataset(1, (XYDataset)this.dataset2);
            StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
            renderer2.setSeriesPaint(0, (Paint)Color.red);
            plot.setRenderer(1, (XYItemRenderer)renderer2);
        }
        if (this.trackValidation) {
            plot.setRangeAxisLocation(2, AxisLocation.BOTTOM_OR_RIGHT);
            plot.mapDatasetToRangeAxis(2, 0);
            plot.setDataset(2, (XYDataset)this.dataset3);
            StandardXYItemRenderer renderer3 = new StandardXYItemRenderer();
            renderer3.setSeriesPaint(0, (Paint)Color.magenta);
            plot.setRenderer(2, (XYItemRenderer)renderer3);
        }
        ChartUtilities.applyCurrentTheme((JFreeChart)this.chart);
        return this.chart;
    }
}

