/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.proben;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.encog.app.analyst.AnalystError;
import org.encog.mathutil.NumericRange;
import org.encog.mathutil.error.ErrorCalculation;
import org.encog.ml.MLError;
import org.encog.ml.MLMethod;
import org.encog.ml.factory.MLMethodFactory;
import org.encog.ml.factory.MLTrainFactory;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EarlyStoppingStrategy;
import org.encog.ml.train.strategy.end.EndIterationsStrategy;
import org.encog.util.Format;
import org.encog.util.Stopwatch;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.proben.ProBenData;
import org.encog.workbench.tabs.proben.ProBenFiles;
import org.encog.workbench.tabs.proben.ProbenStatusPanel;
import org.encog.workbench.util.EncogFonts;

public class ProbenStatusTab
extends EncogCommonTab
implements Runnable,
ActionListener {
    private final JButton buttonStart;
    private final JButton buttonStopAll;
    private final JButton buttonStopCurrent;
    private final JButton buttonClose;
    private final JPanel panelBody;
    private final JPanel panelButtons;
    private Thread thread;
    private boolean cancelCommand;
    private boolean cancelAll;
    private Font headFont;
    private Font bodyFont;
    private String status;
    private int currentDataset = 0;
    private String trainingError = "";
    private String validationError = "";
    private String testError = "";
    private String trainingIterations = "";
    private String currentTrainingRun = "";
    private boolean shouldExit;
    private long lastUpdate;
    private Stopwatch totalTime = new Stopwatch();
    private Stopwatch commandTime = new Stopwatch();
    private MLTrain train;
    private ProBenFiles files = new ProBenFiles();
    private String methodName;
    private String methodArchitecture;
    private String trainingName;
    private String trainingArgs;
    private ProBenData data;
    private int trainingRuns;
    private int maxIterations;
    private List<Double> listTrainingError = new ArrayList<Double>();
    private List<Double> listValidationError = new ArrayList<Double>();
    private List<Double> listTestError = new ArrayList<Double>();
    private List<Double> listIterations = new ArrayList<Double>();

    public ProbenStatusTab(int theTrainingRuns, int theMaxIterations, String theMethodName, String theMethodArchitecture, String theTrainingName, String theTrainingArgs) {
        super((ProjectFile)null);
        this.trainingRuns = theTrainingRuns;
        this.maxIterations = theMaxIterations;
        this.methodName = theMethodName;
        this.methodArchitecture = theMethodArchitecture;
        this.trainingName = theTrainingName;
        this.trainingArgs = theTrainingArgs;
        this.status = "Waiting to start.";
        this.buttonStart = new JButton("Start");
        this.buttonStopAll = new JButton("Stop All Datasets");
        this.buttonStopCurrent = new JButton("Stop Current Dataset");
        this.buttonClose = new JButton("Close");
        this.buttonStart.addActionListener(this);
        this.buttonStopAll.addActionListener(this);
        this.buttonClose.addActionListener(this);
        this.buttonStopCurrent.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.panelBody = new ProbenStatusPanel(this);
        this.panelButtons = new JPanel();
        this.panelButtons.add(this.buttonStart);
        this.panelButtons.add(this.buttonStopAll);
        this.panelButtons.add(this.buttonStopCurrent);
        this.panelButtons.add(this.buttonClose);
        this.add((Component)this.panelBody, "Center");
        this.add((Component)this.panelButtons, "South");
        this.buttonStopAll.setEnabled(false);
        this.buttonStopCurrent.setEnabled(false);
        this.bodyFont = EncogFonts.getInstance().getBodyFont();
        this.headFont = EncogFonts.getInstance().getHeadFont();
    }

    private void performClose() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        } else if (e.getSource() == this.buttonStart) {
            this.performStart();
        } else if (e.getSource() == this.buttonStopAll) {
            this.performStopAll();
        } else if (e.getSource() == this.buttonStopCurrent) {
            this.performStopCurrent();
        }
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            this.performClose();
            return true;
        }
        this.shouldExit = true;
        this.cancelAll = true;
        return false;
    }

    public void paintStatus(Graphics g) {
        g.setColor(Color.white);
        int width = this.getWidth();
        int height = this.getHeight();
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(this.headFont);
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Overall Status:", 10, y);
        g.drawString("Total Datasets:", 10, y += fm.getHeight());
        g.drawString("Current Dataset Name:", 10, y += fm.getHeight());
        g.drawString("Current Dataset Number:", 10, y += fm.getHeight());
        g.drawString("Max Iterations:", 10, y += fm.getHeight());
        g.drawString("Training run:", 10, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString("Elapsed Time:", 350, y);
        g.drawString("Command Elapsed Time:", 350, y += fm.getHeight());
        g.drawString("Training Type:", 350, y += fm.getHeight());
        g.drawString("Error Calc Type:", 350, y += fm.getHeight());
        g.drawString("Training Iterations:", 350, y += fm.getHeight());
        g.drawString("Training Error:", 350, y += fm.getHeight());
        g.drawString("Validation Error:", 350, y += fm.getHeight());
        g.drawString("Test Error:", 350, y += fm.getHeight());
        y = fm.getHeight();
        g.setFont(this.bodyFont);
        g.drawString(this.status, 175, y);
        g.drawString("" + this.files.getList().size(), 175, y += fm.getHeight());
        g.drawString(this.currentDataset == 0 ? "N/A" : this.files.getList().get(this.currentDataset - 1), 175, y += fm.getHeight());
        g.drawString(String.valueOf(this.currentDataset) + " / " + this.files.getList().size(), 175, y += fm.getHeight());
        g.drawString(Format.formatInteger(this.maxIterations), 175, y += fm.getHeight());
        g.drawString(this.currentTrainingRun, 175, y += fm.getHeight());
        y += fm.getHeight();
        String time1 = Format.formatTimeSpan((int)(this.totalTime.getElapsedMilliseconds() / 1000L));
        String time2 = Format.formatTimeSpan((int)(this.commandTime.getElapsedMilliseconds() / 1000L));
        y = fm.getHeight();
        g.setFont(this.bodyFont);
        g.drawString(time1, 500, y);
        g.drawString(time2, 500, y += fm.getHeight());
        y += fm.getHeight();
        if (this.train != null) {
            g.drawString(this.train.getClass().getSimpleName(), 500, y);
        }
        g.drawString(ErrorCalculation.getMode().toString(), 500, y += fm.getHeight());
        g.drawString(this.trainingIterations, 500, y += fm.getHeight());
        g.drawString(this.trainingError, 500, y += fm.getHeight());
        g.drawString(this.validationError, 500, y += fm.getHeight());
        g.drawString(this.testError, 500, y += fm.getHeight());
    }

    private void performStart() {
        this.buttonStart.setEnabled(false);
        this.buttonStopAll.setEnabled(true);
        this.buttonStopCurrent.setEnabled(true);
        this.cancelAll = false;
        this.cancelCommand = false;
        this.status = "Started";
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void performStopAll() {
        this.status = "Canceled";
        this.cancelCommand = true;
        this.cancelAll = true;
    }

    private void performStopCurrent() {
        this.cancelCommand = true;
    }

    private void evaluate() {
        this.cancelCommand = false;
        this.commandTime.reset();
        MLMethodFactory methodFactory = new MLMethodFactory();
        MLMethod method = methodFactory.create(this.methodName, this.methodArchitecture, this.data.getInputCount(), this.data.getIdealCount());
        MLTrainFactory trainFactory = new MLTrainFactory();
        this.train = trainFactory.create(method, this.data.getTrainingDataSet(), this.trainingName, this.trainingArgs);
        this.train.addStrategy(new EndIterationsStrategy(this.maxIterations));
        this.train.addStrategy(new EarlyStoppingStrategy(this.data.getValidationDataSet()));
        Stopwatch sw = new Stopwatch();
        sw.start();
        MLError calc = (MLError)this.train.getMethod();
        int iterations = 0;
        do {
            this.train.iteration();
            ++iterations;
            if (sw.getElapsedMilliseconds() <= 1000L) continue;
            this.trainingError = Format.formatPercent(this.train.getError());
            this.testError = Format.formatPercent(calc.calculateError(this.data.getTestDataSet()));
            this.validationError = Format.formatPercent(calc.calculateError(this.data.getValidationDataSet()));
            this.trainingIterations = Format.formatInteger(iterations);
            this.update();
            sw.reset();
        } while (this.train.getError() > 0.01 && !this.shouldExit && !this.cancelCommand && !this.cancelAll && !this.train.isTrainingDone());
        double trainError = calc.calculateError(this.data.getTrainingDataSet());
        double testError = calc.calculateError(this.data.getTestDataSet());
        double validationError = calc.calculateError(this.data.getValidationDataSet());
        this.listTrainingError.add(trainError);
        this.listValidationError.add(validationError);
        this.listTestError.add(testError);
        this.listIterations.add(Double.valueOf(iterations));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            try {
                this.status = "Running...";
                this.totalTime.reset();
                this.commandTime.reset();
                this.totalTime.start();
                this.update();
                int i = 0;
                while (i < this.files.getList().size() && !this.shouldExit && !this.cancelAll) {
                    this.listIterations.clear();
                    this.listTestError.clear();
                    this.listTrainingError.clear();
                    this.listValidationError.clear();
                    this.currentDataset = i + 1;
                    this.data = new ProBenData(this.files.getList().get(i));
                    this.data.load();
                    int r = 0;
                    while (r < this.trainingRuns) {
                        this.currentTrainingRun = String.valueOf(r + 1) + "/" + this.trainingRuns;
                        this.evaluate();
                        ++r;
                    }
                    this.writeResult();
                    this.update();
                    ++i;
                }
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                return;
            }
            catch (AnalystError ex) {
                ex.printStackTrace();
                EncogWorkBench.getInstance().outputLine("***Encog Analyst Error");
                EncogWorkBench.getInstance().outputLine(ex.getMessage());
                this.status = "Error encountered.";
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                this.shutdown();
                this.stopped();
                this.status = "Done.";
                this.update(true);
                EncogWorkBench.getInstance().refresh();
                if (!this.shouldExit) return;
                this.dispose();
                return;
            }
            catch (Throwable t) {
                EncogWorkBench.displayError("Error", t);
                EncogWorkBench.getInstance().outputLine("***Encog Analyst Exception");
                EncogWorkBench.getInstance().outputLine(t.getMessage());
                this.status = "Exception encountered.";
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                this.dispose();
                this.shutdown();
                this.stopped();
                this.status = "Done.";
                this.update(true);
                EncogWorkBench.getInstance().refresh();
                if (!this.shouldExit) return;
                this.dispose();
                return;
            }
        }
        finally {
            this.shutdown();
            this.stopped();
            this.status = "Done.";
            this.update(true);
            EncogWorkBench.getInstance().refresh();
            if (this.shouldExit) {
                this.dispose();
            }
        }
    }

    private String formatRange(NumericRange r) {
        StringBuilder result = new StringBuilder();
        result.append(Format.formatDouble(r.getMean(), 2));
        result.append(" (sdev=");
        result.append(Format.formatDouble(r.getStandardDeviation(), 2));
        result.append(")");
        return result.toString();
    }

    private String formatPercentRange(NumericRange r) {
        StringBuilder result = new StringBuilder();
        result.append(Format.formatPercent(r.getMean()));
        result.append(" (sdev=");
        result.append(Format.formatPercent(r.getStandardDeviation()));
        result.append(")");
        return result.toString();
    }

    private void writeResult() {
        NumericRange rangeIterations = new NumericRange(this.listIterations);
        NumericRange rangeTest = new NumericRange(this.listTestError);
        NumericRange rangeValidation = new NumericRange(this.listValidationError);
        NumericRange rangeTraining = new NumericRange(this.listTrainingError);
        String str = String.valueOf(this.data.getName()) + "; Iterations=" + this.formatRange(rangeIterations) + "; Data Size=" + Format.formatInteger((int)this.data.getTrainingDataSet().getRecordCount()) + "; Training Error=" + this.formatPercentRange(rangeTraining) + "; Validation Error=" + this.formatPercentRange(rangeValidation);
        EncogWorkBench.getInstance().outputLine(str);
    }

    public void shutdown() {
    }

    public void startup() {
    }

    private void stopped() {
        this.thread = null;
        this.buttonStart.setEnabled(true);
        this.buttonStopAll.setEnabled(false);
        this.buttonStopCurrent.setEnabled(false);
        this.cancelAll = true;
    }

    public void requestShutdown() {
        this.cancelAll = true;
    }

    public boolean shouldShutDown() {
        return this.cancelAll;
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean force) {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 1000L || force) {
            this.lastUpdate = now;
            this.repaint();
        }
    }

    public void requestCancelCommand() {
        this.cancelCommand = true;
    }

    public boolean shouldStopCommand() {
        return this.cancelCommand;
    }

    @Override
    public String getName() {
        return "Proben1 Progress";
    }

    public ProBenFiles getFiles() {
        return this.files;
    }
}

