/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.analyst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.encog.app.analyst.EncogAnalyst;

public class TasksModel
implements ComboBoxModel {
    private EncogAnalyst analyst;
    private Object selectedItem;
    private List<String> tasks = new ArrayList<String>();
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public TasksModel(EncogAnalyst analyst) {
        this.analyst = analyst;
    }

    @Override
    public int getSize() {
        return this.tasks.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.tasks.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void refresh() {
        this.tasks.clear();
        for (String task : this.analyst.getScript().getTasks().keySet()) {
            this.tasks.add(task);
        }
        Collections.sort(this.tasks);
        ListDataEvent e = new ListDataEvent(this, 0, 0, Integer.MAX_VALUE);
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(e);
        }
    }
}

