/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.analyst;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.AnalystListener;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.mathutil.randomize.Distort;
import org.encog.ml.MLMethod;
import org.encog.ml.MLResettable;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.train.MLTrain;
import org.encog.util.Format;
import org.encog.util.Stopwatch;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.analyst.AnalystStatusPanel;
import org.encog.workbench.util.EncogFonts;

public class AnalystProgressTab
extends EncogCommonTab
implements Runnable,
ActionListener,
AnalystListener {
    private final JButton buttonStart;
    private final JButton buttonStopAll;
    private final JButton buttonStopCurrent;
    private final JButton buttonClose;
    private final JPanel panelBody;
    private final JPanel panelButtons;
    private Thread thread;
    private boolean cancelCommand;
    private boolean cancelAll;
    private Font headFont;
    private Font bodyFont;
    private String status = "Waiting to start.";
    private EncogAnalyst analyst;
    private String targetTask = "";
    private String currentCommandName = "";
    private String commandStatus = "";
    private String trainingError = "";
    private String trainingIterations = "";
    private int currentCommandNumber;
    private int totalCommands;
    private boolean shouldExit;
    private long lastUpdate;
    private Stopwatch totalTime = new Stopwatch();
    private Stopwatch commandTime = new Stopwatch();
    private MLTrain train;
    private AtomicInteger resetOption = new AtomicInteger(-1);
    private final JComboBox comboReset;

    public AnalystProgressTab(EncogAnalyst analyst, String targetTask) {
        super((ProjectFile)null);
        this.analyst = analyst;
        this.targetTask = targetTask;
        this.buttonStart = new JButton("Start");
        this.buttonStopAll = new JButton("Stop All Commands");
        this.buttonStopCurrent = new JButton("Stop Current Command");
        this.buttonClose = new JButton("Close");
        this.buttonStart.addActionListener(this);
        this.buttonStopAll.addActionListener(this);
        this.buttonClose.addActionListener(this);
        this.buttonStopCurrent.addActionListener(this);
        ArrayList<String> list = new ArrayList<String>();
        list.add("<Select Option>");
        list.add("Reset");
        list.add("Perturb 1%");
        list.add("Perturb 5%");
        list.add("Perturb 10%");
        list.add("Perturb 15%");
        list.add("Perturb 20%");
        list.add("Perturb 50%");
        this.comboReset = new JComboBox<Object>(list.toArray());
        this.comboReset.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.panelBody = new AnalystStatusPanel(this);
        this.panelButtons = new JPanel();
        this.panelButtons.add(this.buttonStart);
        this.panelButtons.add(this.buttonStopAll);
        this.panelButtons.add(this.buttonStopCurrent);
        this.panelButtons.add(this.buttonClose);
        this.panelButtons.add(this.comboReset);
        this.add((Component)this.panelBody, "Center");
        this.add((Component)this.panelButtons, "South");
        this.buttonStopAll.setEnabled(false);
        this.buttonStopCurrent.setEnabled(false);
        this.bodyFont = EncogFonts.getInstance().getBodyFont();
        this.headFont = EncogFonts.getInstance().getHeadFont();
        this.comboReset.setEnabled(false);
    }

    private void performClose() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        } else if (e.getSource() == this.buttonStart) {
            this.performStart();
        } else if (e.getSource() == this.buttonStopAll) {
            this.performStopAll();
        } else if (e.getSource() == this.buttonStopCurrent) {
            this.performStopCurrent();
        } else if (e.getSource() == this.comboReset) {
            this.resetOption.set(this.comboReset.getSelectedIndex() - 1);
            this.comboReset.setSelectedIndex(0);
        }
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            this.performClose();
            return true;
        }
        this.shouldExit = true;
        this.cancelAll = true;
        return false;
    }

    public void paintStatus(Graphics g) {
        g.setColor(Color.white);
        int width = this.getWidth();
        int height = this.getHeight();
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(this.headFont);
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Overall Status:", 10, y);
        g.drawString("Running Task:", 10, y += fm.getHeight());
        g.drawString("Current Command Name:", 10, y += fm.getHeight());
        g.drawString("Current Command Number:", 10, y += fm.getHeight());
        g.drawString("Current Command Status:", 10, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString("Elapsed Time:", 350, y);
        g.drawString("Command Elapsed Time:", 350, y += fm.getHeight());
        g.drawString("Training Iterations:", 350, y += fm.getHeight());
        g.drawString("Training Error:", 350, y += fm.getHeight());
        g.drawString("Training Type:", 350, y += fm.getHeight());
        if (this.train instanceof EvolutionaryAlgorithm) {
            g.drawString("Species Count:", 350, y += fm.getHeight());
        }
        y = fm.getHeight();
        g.setFont(this.bodyFont);
        g.drawString(this.status, 175, y);
        g.drawString(this.targetTask, 175, y += fm.getHeight());
        g.drawString(this.currentCommandName, 175, y += fm.getHeight());
        g.drawString(String.valueOf(this.currentCommandNumber) + " / " + this.totalCommands, 175, y += fm.getHeight());
        g.drawString(this.commandStatus, 175, y += fm.getHeight());
        y += fm.getHeight();
        String time1 = Format.formatTimeSpan((int)(this.totalTime.getElapsedMilliseconds() / 1000L));
        String time2 = Format.formatTimeSpan((int)(this.commandTime.getElapsedMilliseconds() / 1000L));
        y = fm.getHeight();
        g.setFont(this.bodyFont);
        g.drawString(time1, 500, y);
        g.drawString(time2, 500, y += fm.getHeight());
        g.drawString(this.trainingIterations, 500, y += fm.getHeight());
        g.drawString(this.trainingError, 500, y += fm.getHeight());
        y += fm.getHeight();
        if (this.train != null) {
            g.drawString(this.train.getClass().getSimpleName(), 500, y);
            y += fm.getHeight();
            if (this.train instanceof EvolutionaryAlgorithm) {
                EvolutionaryAlgorithm ea = (EvolutionaryAlgorithm)((Object)this.train);
                g.drawString(Format.formatInteger(ea.getPopulation().getSpecies().size()), 500, y);
            }
        }
    }

    private void performStart() {
        this.buttonStart.setEnabled(false);
        this.buttonStopAll.setEnabled(true);
        this.buttonStopCurrent.setEnabled(true);
        this.cancelAll = false;
        this.cancelCommand = false;
        this.status = "Started";
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void performStopAll() {
        this.status = "Canceled";
        this.cancelCommand = true;
        this.cancelAll = true;
        this.analyst.stopCurrentTask();
    }

    private void performStopCurrent() {
        this.cancelCommand = true;
        this.analyst.stopCurrentTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            try {
                this.status = "Running...";
                this.totalTime.reset();
                this.commandTime.reset();
                this.totalTime.start();
                this.update();
                this.analyst.getListeners().clear();
                this.analyst.addAnalystListener(this);
                this.analyst.executeTask(this.targetTask);
                this.analyst.removeAnalystListener(this);
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                return;
            }
            catch (AnalystError ex) {
                ex.printStackTrace();
                EncogWorkBench.getInstance().outputLine("***Encog Analyst Error");
                EncogWorkBench.getInstance().outputLine(ex.getMessage());
                this.status = "Error encountered.";
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                this.shutdown();
                this.stopped();
                this.status = "Done.";
                this.update(true);
                EncogWorkBench.getInstance().refresh();
                if (!this.shouldExit) return;
                this.dispose();
                return;
            }
            catch (Throwable t) {
                EncogWorkBench.displayError("Error", t);
                EncogWorkBench.getInstance().outputLine("***Encog Analyst Exception");
                EncogWorkBench.getInstance().outputLine(t.getMessage());
                this.status = "Exception encountered.";
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                this.dispose();
                this.shutdown();
                this.stopped();
                this.status = "Done.";
                this.update(true);
                EncogWorkBench.getInstance().refresh();
                if (!this.shouldExit) return;
                this.dispose();
                return;
            }
        }
        finally {
            this.shutdown();
            this.stopped();
            this.status = "Done.";
            this.update(true);
            EncogWorkBench.getInstance().refresh();
            if (this.shouldExit) {
                this.dispose();
            }
        }
    }

    public void shutdown() {
    }

    public void startup() {
    }

    private void stopped() {
        this.thread = null;
        this.buttonStart.setEnabled(true);
        this.buttonStopAll.setEnabled(false);
        this.buttonStopCurrent.setEnabled(false);
        this.cancelAll = true;
    }

    @Override
    public void requestShutdown() {
        this.cancelAll = true;
    }

    @Override
    public boolean shouldShutDown() {
        return this.cancelAll;
    }

    @Override
    public void reportCommandBegin(int total, int current, String name) {
        this.cancelCommand = false;
        this.currentCommandName = name;
        this.totalCommands = total;
        this.currentCommandNumber = current;
        this.commandTime.reset();
        this.commandTime.start();
        String str = "Beginning Command #" + current + "/" + total + ": " + name;
        this.commandStatus = "Running";
        EncogWorkBench.getInstance().outputLine(str);
        this.update();
    }

    @Override
    public void reportCommandEnd(boolean canceled) {
        this.commandTime.stop();
        String str = canceled ? "Canceled" : "Done with";
        str = String.valueOf(str) + " Command #" + this.currentCommandNumber + ": " + this.currentCommandName + ", elapsed time: " + Format.formatTimeSpan((int)(this.commandTime.getElapsedMilliseconds() / 1000L));
        EncogWorkBench.getInstance().outputLine(str);
        this.update(true);
    }

    @Override
    public void reportTrainingBegin() {
        this.comboReset.setEnabled(true);
        this.update();
    }

    @Override
    public void reportTrainingEnd() {
        this.comboReset.setEnabled(false);
        this.commandStatus = "Training Done";
        this.train = null;
        this.update(true);
    }

    @Override
    public void reportTraining(MLTrain train) {
        if (this.resetOption.get() != -1) {
            MLMethod method = this.analyst.getMethod();
            if (method == null) {
                this.resetOption.set(-1);
                EncogWorkBench.displayError("Error", "This machine learning method cannot be reset or randomized.");
                return;
            }
            switch (this.resetOption.get()) {
                case 0: {
                    if (method instanceof MLResettable) {
                        ((MLResettable)method).reset();
                        break;
                    }
                    EncogWorkBench.displayError("Error", "This Machine Learning method cannot be reset.");
                    break;
                }
                case 1: {
                    new Distort(0.01).randomize(method);
                    break;
                }
                case 2: {
                    new Distort(0.05).randomize(method);
                    break;
                }
                case 3: {
                    new Distort(0.1).randomize(method);
                    break;
                }
                case 4: {
                    new Distort(0.15).randomize(method);
                    break;
                }
                case 5: {
                    new Distort(0.2).randomize(method);
                    break;
                }
                case 6: {
                    new Distort(0.5).randomize(method);
                }
            }
            this.resetOption.set(-1);
        }
        this.train = train;
        this.commandStatus = "Training";
        this.trainingIterations = Format.formatInteger(train.getIteration());
        this.trainingError = Format.formatPercent(train.getError());
        this.update();
    }

    @Override
    public void report(int total, int current, String message) {
        this.commandStatus = total == 0 ? String.valueOf(Format.formatInteger(current)) + " : " + message : String.valueOf(Format.formatInteger(current)) + "/" + Format.formatInteger(total) + " : " + message;
        this.update();
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean force) {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 1000L || force) {
            this.lastUpdate = now;
            this.repaint();
        }
    }

    @Override
    public void requestCancelCommand() {
        this.cancelCommand = true;
    }

    @Override
    public boolean shouldStopCommand() {
        return this.cancelCommand;
    }

    @Override
    public String getName() {
        return "Analyst Progress";
    }
}

