/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.process;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.encog.ml.CalculateScore;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.VariableMapping;
import org.encog.ml.prg.extension.StandardExtensions;
import org.encog.ml.prg.generator.RampedHalfAndHalf;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.ml.prg.train.ZeroEvalScoreFunction;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.networks.training.TrainingSetScore;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.createfile.CreateFileDialog;
import org.encog.workbench.dialogs.createfile.CreateFileType;
import org.encog.workbench.dialogs.createfile.CreatePopulationDialog;
import org.encog.workbench.dialogs.population.epl.CreateEPLPopulationDialog;
import org.encog.workbench.dialogs.population.neat.NewPopulationDialog;
import org.encog.workbench.dialogs.trainingdata.CreateEmptyTrainingDialog;
import org.encog.workbench.process.CreateNeuralNetwork;
import org.encog.workbench.process.EncogAnalystWizard;
import org.encog.workbench.util.FileUtil;

public class CreateNewFile {
    public static void performCreateFile() throws IOException {
        CreateFileDialog dialog = new CreateFileDialog(EncogWorkBench.getInstance().getMainWindow());
        dialog.setTheType(CreateFileType.MachineLearningMethod);
        if (dialog.process()) {
            String name = dialog.getFilename();
            if (name == null || name.length() == 0) {
                EncogWorkBench.displayError("Data Missing", "Must specify a filename.");
                return;
            }
            File basePath = EncogWorkBench.getInstance().getMainWindow().getTree().getPath();
            if (dialog.getTheType() == CreateFileType.MachineLearningMethod) {
                File path = new File(basePath, name = FileUtil.forceExtension(new File(name).getName(), "eg"));
                if (FileUtil.checkOverWrite(path)) {
                    CreateNeuralNetwork.process(path);
                }
            } else if (dialog.getTheType() == CreateFileType.TextFile) {
                File path = new File(basePath, name = FileUtil.forceExtension(new File(name).getName(), "txt"));
                if (FileUtil.checkOverWrite(path)) {
                    FileUtil.writeFileAsString(path, "");
                }
            } else if (dialog.getTheType() == CreateFileType.CSVFile) {
                File path = new File(basePath, name = FileUtil.forceExtension(new File(name).getName(), "csv"));
                if (FileUtil.checkOverWrite(path)) {
                    FileUtil.writeFileAsString(path, "");
                }
            } else if (dialog.getTheType() == CreateFileType.TrainingFile) {
                name = FileUtil.forceExtension(new File(name).getName(), "egb");
                File path = new File(basePath, name);
                CreateNewFile.createNewEGB(path);
            } else if (dialog.getTheType() == CreateFileType.Population) {
                name = FileUtil.forceExtension(new File(name).getName(), "eg");
                File path = new File(basePath, name);
                CreateNewFile.createNewPopulation(path);
            } else if (dialog.getTheType() == CreateFileType.AnalystIndicator) {
                name = FileUtil.forceExtension(new File(name).getName(), "ega");
                File path = new File(basePath, name);
                CreateNewFile.createNewAnalystIndicator(path);
            }
            EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
        }
    }

    private static void createNewAnalystIndicator(File path) {
        EncogAnalystWizard.createRealtimeEncogAnalyst(path);
    }

    private static void createNewEGB(File file) {
        CreateEmptyTrainingDialog dialog = new CreateEmptyTrainingDialog(EncogWorkBench.getInstance().getMainWindow());
        if (dialog.process()) {
            int elements = dialog.getElements().getValue();
            int input = dialog.getInput().getValue();
            int output = dialog.getIdeal().getValue();
            BufferedMLDataSet trainingData = new BufferedMLDataSet(file);
            MLDataPair pair = BasicMLDataPair.createPair(input, output);
            trainingData.beginLoad(input, output);
            int i = 0;
            while (i < elements) {
                trainingData.add(pair);
                ++i;
            }
            trainingData.endLoad();
        }
    }

    private static void createPopulationNEAT(File path) {
        NewPopulationDialog dialog = new NewPopulationDialog();
        if (dialog.process()) {
            int populationSize = dialog.getPopulationSize().getValue();
            int inputCount = dialog.getInputNeurons().getValue();
            int outputCount = dialog.getOutputNeurons().getValue();
            int cycles = dialog.getActivationCycles().getValue();
            NEATPopulation pop = new NEATPopulation(inputCount, outputCount, populationSize);
            pop.setActivationCycles(cycles);
            pop.setNEATActivationFunction(dialog.getNeatActivationFunction());
            EncogWorkBench.getInstance().save(path, pop);
            EncogWorkBench.getInstance().refresh();
        }
    }

    public static void createPopulationEPL(File path, PrgPopulation pop) {
        CreateEPLPopulationDialog dialog = new CreateEPLPopulationDialog();
        if (pop != null) {
            dialog.getPopulationSize().setValue(pop.size());
            for (VariableMapping mapping : pop.getContext().getDefinedVariables()) {
                dialog.getInputVariables().getModel().addElement(mapping.getName());
            }
        } else {
            dialog.getInputVariables().getModel().addElement("x");
            dialog.getPopulationSize().setValue(1000);
        }
        if (dialog.process()) {
            int populationSize = dialog.getPopulationSize().getValue();
            int maxDepth = dialog.getMaxDepth().getValue();
            CalculateScore score = dialog.getTrainingSet() != null ? new TrainingSetScore(dialog.getTrainingSet()) : new ZeroEvalScoreFunction();
            EncogProgramContext context = new EncogProgramContext();
            int i = 0;
            while (i < dialog.getInputVariables().getModel().getSize()) {
                String str = (String)dialog.getInputVariables().getModel().get(i);
                context.defineVariable(str);
                ++i;
            }
            StandardExtensions.createNumericOperators(context);
            if (pop == null) {
                pop = new PrgPopulation(context, populationSize);
            }
            try {
                EncogWorkBench.getInstance().getMainWindow().beginWait();
                RampedHalfAndHalf generate = new RampedHalfAndHalf(pop.getContext(), 2, maxDepth);
                generate.setScore(score);
                generate.generate(new Random(), pop);
            }
            finally {
                EncogWorkBench.getInstance().getMainWindow().endWait();
            }
            if (path != null) {
                EncogWorkBench.getInstance().save(path, pop);
                EncogWorkBench.getInstance().refresh();
            }
        }
    }

    private static void createNewPopulation(File path) {
        CreatePopulationDialog dialog = new CreatePopulationDialog();
        if (dialog.process()) {
            switch (dialog.getTheType()) {
                case NEAT: {
                    CreateNewFile.createPopulationNEAT(path);
                    break;
                }
                case EPL: {
                    CreateNewFile.createPopulationEPL(path, null);
                }
            }
        }
    }
}

