/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;

public class TrainingSetTableModel
implements TableModel {
    private final BasicMLDataSet data;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

    public TrainingSetTableModel(BasicMLDataSet data) {
        this.data = data;
    }

    public void addIdealColumn() {
        for (MLDataPair pair : this.data) {
            BasicMLData ideal = (BasicMLData)pair.getIdeal();
            double[] d = new double[ideal.size() + 1];
            int i = 0;
            while (i < ideal.size()) {
                d[i] = ideal.getData(i);
                ++i;
            }
            ideal.setData(d);
        }
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void addInputColumn() {
        for (MLDataPair pair : this.data) {
            BasicMLData input = (BasicMLData)pair.getInput();
            double[] d = new double[input.size() + 1];
            int i = 0;
            while (i < input.size()) {
                d[i] = input.getData(i);
                ++i;
            }
            input.setData(d);
        }
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void addRow(int row) {
        int idealSize = this.data.getIdealSize();
        int inputSize = this.data.getInputSize();
        BasicMLData idealData = new BasicMLData(idealSize);
        BasicMLData inputData = new BasicMLData(inputSize);
        BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
        if (row == -1) {
            this.data.getData().add(pair);
        } else {
            this.data.getData().add(row, pair);
        }
        TableModelEvent tce = new TableModelEvent(this);
        this.notifyListeners(tce);
    }

    @Override
    public void addTableModelListener(TableModelListener listner) {
        this.listeners.add(listner);
    }

    public void delColumn(int col) {
        int inputSize = this.data.getInputSize();
        if (col < inputSize) {
            for (MLDataPair pair : this.data) {
                MLData input = pair.getInput();
                double[] d = new double[input.size() - 1];
                int t = 0;
                int i = 0;
                while (i < input.size()) {
                    if (i != col) {
                        d[t] = pair.getInput().getData(i);
                        ++t;
                    }
                    ++i;
                }
                input.setData(d);
            }
        } else {
            for (MLDataPair pair : this.data) {
                MLData ideal = pair.getIdeal();
                double[] d = new double[ideal.size() - 1];
                int t = 0;
                int i = 0;
                while (i < ideal.size()) {
                    if (i != col - inputSize) {
                        d[t] = pair.getInput().getData(i);
                        ++t;
                    }
                    ++i;
                }
                ideal.setData(d);
            }
        }
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.notifyListeners(tce);
    }

    public void delRow(int row) {
        this.data.getData().remove(row);
        TableModelEvent tce = new TableModelEvent(this);
        this.notifyListeners(tce);
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        return this.data.getIdealSize() + this.data.getInputSize();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.data.getInputSize()) {
            return "Input " + (columnIndex + 1);
        }
        return "Ideal " + (columnIndex + 1 - this.data.getInputSize());
    }

    @Override
    public int getRowCount() {
        int i = 0;
        for (MLDataPair pair : this.data) {
            ++i;
        }
        return i;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        for (MLDataPair pair : this.data) {
            if (rowIndex == 0) {
                if (columnIndex >= pair.getInput().size()) {
                    return pair.getIdeal().getData(columnIndex - pair.getInput().size());
                }
                return pair.getInput().getData(columnIndex);
            }
            --rowIndex;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    private void notifyListeners(TableModelEvent tce) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tce);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValueAt(Object rawValue, int rowIndex, int columnIndex) {
        Double value = null;
        value = rawValue instanceof Double ? (Double)rawValue : Double.valueOf(Double.parseDouble(rawValue.toString()));
        for (MLDataPair pair : this.data) {
            if (rowIndex == 0) {
                if (columnIndex >= pair.getInput().size()) {
                    pair.getIdeal().setData(columnIndex - pair.getInput().size(), value);
                } else {
                    pair.getInput().setData(columnIndex, value);
                }
            }
            --rowIndex;
        }
    }
}

