/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.encog.app.generate.EncogCodeGeneration;
import org.encog.app.generate.TargetLanguage;
import org.encog.ml.MLMethod;
import org.encog.util.file.FileUtil;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.wizard.generate.CodeGenerateDialog;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectItem;
import org.encog.workbench.process.CreateNewFile;
import org.encog.workbench.process.EncogAnalystWizard;
import org.encog.workbench.process.ImportExport;
import org.encog.workbench.tabs.files.TextDisplayTab;

public class EncogPopupMenus {
    private JPopupMenu popupFile;
    private JMenuItem popupFileRefresh;
    private JMenuItem popupFileDelete;
    private JMenuItem popupFileOpen;
    private JMenuItem popupFileProperties;
    private JMenuItem popupFileOpenText;
    private JMenuItem popupFileCSVExport;
    private JMenuItem popupFileCSVNormalize;
    private JMenuItem popupFileCSVWizard;
    private JMenuItem popupFileNewFile;
    private JMenuItem popupFileGenerate;
    private JMenuItem popupFileCopy;
    private EncogDocumentFrame owner;

    public EncogPopupMenus(EncogDocumentFrame owner) {
        this.owner = owner;
    }

    public void actionPerformed(ActionEvent event) {
        this.performPopupMenu(event.getSource());
    }

    public void performPopupMenu(Object source) {
        try {
            if (source == this.popupFileRefresh) {
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                return;
            }
            if (source == this.popupFileNewFile) {
                CreateNewFile.performCreateFile();
                return;
            }
            if (source == this.popupFileDelete) {
                EncogWorkBench.getInstance().getMainWindow().getOperations().performDelete();
                return;
            }
            boolean first = true;
            List<ProjectItem> list = this.owner.getTree().getSelectedValue();
            if (list == null) {
                return;
            }
            for (ProjectItem selected : list) {
                String targetFile;
                Object sourceFile;
                if (source == this.popupFileOpen) {
                    if (selected instanceof ProjectFile) {
                        EncogWorkBench.getInstance().getMainWindow().openFile((ProjectFile)selected);
                    }
                } else if (source == this.popupFileOpenText) {
                    if (selected instanceof ProjectFile) {
                        EncogWorkBench.getInstance().getMainWindow().openTextFile((ProjectFile)selected);
                    }
                } else if (source == this.popupFileCSVExport) {
                    sourceFile = ((ProjectFile)selected).getFile().toString();
                    targetFile = FileUtil.forceExtension((String)sourceFile, "egb");
                    ImportExport.performExternal2Bin(new File((String)sourceFile), new File(targetFile), null);
                } else if (source == this.popupFileCSVNormalize) {
                    sourceFile = ((ProjectFile)selected).getFile().toString();
                    targetFile = FileUtil.forceExtension((String)sourceFile, "egb");
                    ImportExport.performNormalize2Bin(new File((String)sourceFile), new File(targetFile), null);
                    EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
                } else if (source == this.popupFileCSVWizard) {
                    sourceFile = ((ProjectFile)selected).getFile();
                    EncogAnalystWizard.createEncogAnalyst((File)sourceFile);
                } else if (source == this.popupFileProperties) {
                    if (selected instanceof ProjectFile) {
                        EncogWorkBench.getInstance().getMainWindow().getOperations().performFileProperties((ProjectFile)selected);
                    }
                } else if (source == this.popupFileCopy) {
                    this.performCopy((ProjectFile)selected);
                } else if (source == this.popupFileGenerate) {
                    this.performGenerate((ProjectFile)selected);
                }
                first = false;
            }
        }
        catch (IOException e) {
            EncogWorkBench.displayError("Error", e);
        }
    }

    private void performGenerate(ProjectFile selected) {
        if (selected.getExtension().equalsIgnoreCase("eg")) {
            this.performGenerateMethod(selected);
        } else {
            this.performGenerateData(selected);
        }
    }

    private void performGenerateData(ProjectFile selected) {
        CodeGenerateDialog dialog = new CodeGenerateDialog();
        if (dialog.process()) {
            TargetLanguage targetLang = dialog.getTargetLanguage();
            EncogCodeGeneration gen = new EncogCodeGeneration(targetLang);
            gen.setEmbedData(dialog.getEmbed());
            gen.generate(null, selected.getFile());
            String code = gen.save();
            TextDisplayTab tab = new TextDisplayTab(targetLang.toString());
            tab.setText(code);
            EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
        }
    }

    private void performGenerateMethod(ProjectFile selected) {
        MLMethod method = (MLMethod)((ProjectEGFile)selected).getObject();
        if (!EncogCodeGeneration.isSupported(method)) {
            EncogWorkBench.displayError("Error", "Code generation for " + method.getClass().getSimpleName() + " is not currently supported.");
            return;
        }
        CodeGenerateDialog dialog = new CodeGenerateDialog();
        if (dialog.process()) {
            TargetLanguage targetLang = dialog.getTargetLanguage();
            EncogCodeGeneration gen = new EncogCodeGeneration(targetLang);
            gen.setEmbedData(dialog.getEmbed());
            gen.generate(selected.getFile(), null);
            String code = gen.save();
            TextDisplayTab tab = new TextDisplayTab(targetLang.toString());
            tab.setText(code);
            EncogWorkBench.getInstance().getMainWindow().getTabManager().openTab(tab);
        }
    }

    private void performCopy(ProjectFile selected) {
        try {
            File t = FileUtil.addFilenameBase(selected.getFile(), "-copy");
            String targetStr = EncogWorkBench.displayInput("Name to copy file to", t.getName());
            if (targetStr != null) {
                File targetFile = new File(EncogWorkBench.getInstance().getProjectDirectory(), new File(targetStr).getName());
                if (targetFile.exists()) {
                    if (EncogWorkBench.askQuestion("File Exists", "Do you wish to overwrite the file of the same name?")) {
                        FileUtil.copy(selected.getFile(), targetFile);
                    }
                } else {
                    FileUtil.copy(selected.getFile(), targetFile);
                }
                EncogWorkBench.getInstance().getMainWindow().redraw();
            }
        }
        catch (Exception ex) {
            EncogWorkBench.displayError("Error", ex);
        }
    }

    public void rightMouseClicked(MouseEvent e, Object item) {
        File file = null;
        String ext = null;
        if (item instanceof ProjectFile) {
            file = ((ProjectFile)item).getFile();
            ext = FileUtil.getFileExt(file);
        }
        this.popupFile = new JPopupMenu();
        this.popupFileRefresh = this.owner.addItem(this.popupFile, "Refresh", 114);
        this.popupFileOpen = file != null && !"eg".equalsIgnoreCase(ext) ? this.owner.addItem(this.popupFile, "Open", 111) : null;
        if (file != null) {
            this.popupFileDelete = this.owner.addItem(this.popupFile, "Delete", 100);
            this.popupFileCopy = this.owner.addItem(this.popupFile, "Copy", 99);
            this.popupFileProperties = this.owner.addItem(this.popupFile, "Rename...", 112);
        } else {
            this.popupFileDelete = null;
            this.popupFileOpen = null;
            this.popupFileProperties = null;
        }
        this.popupFileOpenText = ext != null && !"txt".equalsIgnoreCase(ext) ? this.owner.addItem(this.popupFile, "Open as Text", 116) : null;
        if (ext != null && "csv".equalsIgnoreCase(ext)) {
            this.popupFileCSVExport = this.owner.addItem(this.popupFile, "Export to Training(EGB)", 120);
            this.popupFileCSVNormalize = this.owner.addItem(this.popupFile, "Normalize to Training(EGB)", 110);
            this.popupFileCSVWizard = this.owner.addItem(this.popupFile, "Analyst Wizard...", 119);
        } else {
            this.popupFileCSVExport = null;
            this.popupFileCSVWizard = null;
        }
        this.popupFileGenerate = ext != null && ("eg".equalsIgnoreCase(ext) || "egb".equalsIgnoreCase(ext)) ? this.owner.addItem(this.popupFile, "Generate Code...", 110) : null;
        this.popupFileNewFile = file == null ? this.owner.addItem(this.popupFile, "New File", 110) : null;
        this.popupFile.show(e.getComponent(), e.getX(), e.getY());
    }
}

