/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JSplitPane;
import org.encog.ml.MLMethod;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.splash.EncogWorkbenchSplash;
import org.encog.workbench.frames.EncogCommonFrame;
import org.encog.workbench.frames.document.EncogDocumentOperations;
import org.encog.workbench.frames.document.EncogMenus;
import org.encog.workbench.frames.document.EncogOutputPanel;
import org.encog.workbench.frames.document.EncogPopupMenus;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectTree;
import org.encog.workbench.tabs.AboutTab;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.EncogTabManager;
import org.encog.workbench.tabs.TrainingContTab;
import org.encog.workbench.tabs.UnknownObjectTab;
import org.encog.workbench.tabs.analyst.EncogAnalystTab;
import org.encog.workbench.tabs.bayesian.BayesianNetworkTab;
import org.encog.workbench.tabs.files.BinaryDataTab;
import org.encog.workbench.tabs.files.GenericFileTab;
import org.encog.workbench.tabs.files.HTMLFileTab;
import org.encog.workbench.tabs.files.ImageFileTab;
import org.encog.workbench.tabs.files.TextFileTab;
import org.encog.workbench.tabs.mlmethod.MLMethodTab;
import org.encog.workbench.tabs.population.epl.EPLPopulationTab;
import org.encog.workbench.tabs.population.neat.NEATPopulationTab;
import org.encog.workbench.util.ExtensionFilter;
import org.encog.workbench.util.FileUtil;

public class EncogDocumentFrame
extends EncogCommonFrame {
    private EncogDocumentOperations operations;
    private EncogMenus menus;
    private EncogPopupMenus popupMenus;
    private boolean closed = false;
    private boolean splashed = false;
    private JSplitPane projectSplit;
    private EncogTabManager tabManager;
    private AboutTab aboutTab;
    private JSplitPane documentSplit;
    private EncogOutputPanel outputPanel;
    private ProjectTree tree;
    private static final String[] B = new String[]{".csv", ".xlsx"};
    public static final ExtensionFilter ENCOG_FILTER = new ExtensionFilter("Encog Files (*.eg)", ".eg");
    public static final ExtensionFilter CSV_FILTER = new ExtensionFilter("External Files (*.xlsx,*.csv)", B);
    public static final ExtensionFilter XML_FILTER = new ExtensionFilter("BIF Files (*.xml)", ".xml");
    public static final ExtensionFilter ENCOG_BINARY = new ExtensionFilter("Binary Encog Training Files (*.egb)", ".egb");
    public static final String WINDOW_TITLE = "Encog Workbench";
    private static final long serialVersionUID = -4161616483326975155L;

    public EncogDocumentFrame() {
        this.setSize(750, 480);
        EncogWorkBench.getInstance().setMainWindow(this);
        this.operations = new EncogDocumentOperations(this);
        this.menus = new EncogMenus(this);
        this.popupMenus = new EncogPopupMenus(this);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(2);
        this.aboutTab = new AboutTab();
        this.menus.initMenuBar();
        this.initContents();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            this.menus.actionPerformed(event);
            this.popupMenus.actionPerformed(event);
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    private void initContents() {
        this.tree = new ProjectTree(this);
        this.tabManager = new EncogTabManager(this);
        this.outputPanel = new EncogOutputPanel();
        this.documentSplit = new JSplitPane(0, this.tabManager.getDocumentTabs(), this.outputPanel);
        this.projectSplit = new JSplitPane(1, this.tree, this.documentSplit);
        this.projectSplit.setDividerLocation(150);
        this.documentSplit.setDividerLocation(this.getHeight() - 200);
        this.getContentPane().add(this.projectSplit);
        this.menus.updateMenus();
        this.redraw();
    }

    @Override
    public void redraw() {
        if (EncogWorkBench.getInstance().getProjectDirectory() == null) {
            this.setTitle("Encog Workbench : No Project");
        } else {
            this.setTitle("Encog Workbench : " + EncogWorkBench.getInstance().getProjectDirectory());
        }
        this.getMenus().updateMenus();
        this.tree.refresh();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.getOperations().performQuit();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (!this.splashed) {
            EncogWorkbenchSplash splash = new EncogWorkbenchSplash();
            splash.process();
            this.splashed = true;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!this.closed) {
            this.closed = true;
        }
        super.windowClosing(e);
        EncogWorkBench.getInstance().getConfig().saveConfig();
    }

    public EncogDocumentOperations getOperations() {
        return this.operations;
    }

    public EncogMenus getMenus() {
        return this.menus;
    }

    public EncogPopupMenus getPopupMenus() {
        return this.popupMenus;
    }

    public EncogTabManager getTabManager() {
        return this.tabManager;
    }

    public void displayAboutTab() {
        this.tabManager.openTab(this.aboutTab);
    }

    public void beginWait() {
        Cursor hourglassCursor = new Cursor(3);
        this.setCursor(hourglassCursor);
    }

    public void endWait() {
        Cursor normalCursor = new Cursor(0);
        this.setCursor(normalCursor);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.documentSplit != null) {
            this.documentSplit.setDividerLocation(this.getHeight() - 200);
        }
    }

    public EncogOutputPanel getOutputPane() {
        return this.outputPanel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public ProjectTree getTree() {
        return this.tree;
    }

    public void openEGFile(ProjectEGFile file) {
        file.refresh();
        Object obj = file.getObject();
        EncogCommonTab tab = null;
        tab = obj instanceof BayesianNetwork ? new BayesianNetworkTab(file) : (obj instanceof PrgPopulation ? new EPLPopulationTab(file) : (obj instanceof NEATPopulation ? new NEATPopulationTab(file) : (obj instanceof TrainingContinuation ? new TrainingContTab(file) : (obj instanceof MLMethod ? new MLMethodTab(file) : new UnknownObjectTab(file)))));
        if (tab != null) {
            this.tabManager.openTab(tab);
        }
    }

    public void openFile(ProjectFile file) {
        block16: {
            try {
                if (file == null) {
                    return;
                }
                EncogWorkBench.getInstance().getMainWindow().beginWait();
                EncogCommonTab tab = this.tabManager.find(file.getFile());
                if (tab != null) {
                    this.tabManager.selectTab(tab);
                    return;
                }
                if (file instanceof ProjectEGFile) {
                    this.openEGFile((ProjectEGFile)file);
                    return;
                }
                try {
                    if (tab != null) break block16;
                    String extension = FileUtil.getFileExt(file.getFile());
                    if (extension.equalsIgnoreCase("txt") || extension.equalsIgnoreCase("csv") || extension.equalsIgnoreCase("cs") || extension.equalsIgnoreCase("java") || extension.equalsIgnoreCase("mql4")) {
                        tab = new TextFileTab(file);
                        this.tabManager.openTab(tab);
                        break block16;
                    }
                    if (extension.equals("ega")) {
                        tab = new EncogAnalystTab(file);
                        this.tabManager.openTab(tab);
                        break block16;
                    }
                    if (extension.equalsIgnoreCase("html")) {
                        tab = new HTMLFileTab(file);
                        this.tabManager.openTab(tab);
                        break block16;
                    }
                    if (extension.equalsIgnoreCase("egb")) {
                        tab = new BinaryDataTab(file);
                        this.tabManager.openTab(tab);
                        break block16;
                    }
                    if (extension.equalsIgnoreCase("jpg") || extension.equalsIgnoreCase("jpeg") || extension.equalsIgnoreCase("gif") || extension.equalsIgnoreCase("png")) {
                        tab = new ImageFileTab(file);
                        this.tabManager.openTab(tab);
                        break block16;
                    }
                    tab = new GenericFileTab(file);
                    this.tabManager.openTab(tab);
                }
                catch (Throwable t) {
                    EncogWorkBench.displayError("Error Reading File", t);
                }
            }
            finally {
                EncogWorkBench.getInstance().getMainWindow().endWait();
            }
        }
    }

    public void openTextFile(ProjectFile file) {
        try {
            EncogWorkBench.getInstance().getMainWindow().beginWait();
            EncogCommonTab tab = this.tabManager.find(file.getFile());
            if (tab == null) {
                tab = new TextFileTab(file);
                this.tabManager.openTab(tab);
            } else {
                this.tabManager.selectTab(tab);
                this.menus.updateMenus();
            }
        }
        finally {
            EncogWorkBench.getInstance().getMainWindow().endWait();
        }
    }

    public void changeDirectory(File path) {
        if (this.tabManager.getTabs().size() > 0) {
            if (!EncogWorkBench.askQuestion("Changing Directory", "Before you can change the directory, all windows must be closed.\nDo you wish to continue?")) {
                return;
            }
            this.tabManager.closeAll();
        }
        EncogWorkBench.getInstance().getMainWindow().getTree().refresh(path);
    }

    public void openFile(File egaFile) {
        ProjectFile tf = this.getTree().findTreeFile(egaFile);
        if (tf != null) {
            this.openFile(tf);
        }
    }
}

